/*
 * Copyright (C) 2014, 2016 Karl Wette
 * Copyright (C) 2009-2013 Adam Mercer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * LALXMLVCSInfo.h - LALXML VCS Information Header
 */

/** \cond DONT_DOXYGEN */

#ifndef _LALXMLVCSINFOHEADER_H
#define _LALXMLVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALXMLVCSInfo.h>
#include <lal/LALXMLConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* VCS information */
#define LALXML_VCS_ID "5fd4ddfcd98132791ae58e05ca8e2ec0322bd47a"
#define LALXML_VCS_DATE "2017-02-6 18:15:58 +0000"
#define LALXML_VCS_BRANCH "None"
#define LALXML_VCS_TAG "lalxml-v1.2.4"
#define LALXML_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALXML_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALXML_VCS_CLEAN "CLEAN"
#define LALXML_VCS_STATUS "CLEAN: All modifications committed"

/* VCS header/library mismatch link check function */
#define LALXML_VCS_LINK_CHECK LALXML_CLEAN_5fd4ddfcd98132791ae58e05ca8e2ec0322bd47a_VCS_HEADER_LIBRARY_MISMATCH
void LALXML_VCS_LINK_CHECK(void);

#ifdef __cplusplus
}
#endif

#endif /* _LALXMLVCSINFOHEADER_H */

/** \endcond */
