/*
 * Copyright (C) 2014, 2016 Karl Wette
 * Copyright (C) 2009-2013 Adam Mercer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * LALStochasticVCSInfo.h - LALStochastic VCS Information Header
 */

/** \cond DONT_DOXYGEN */

#ifndef _LALSTOCHASTICVCSINFOHEADER_H
#define _LALSTOCHASTICVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALStochasticVCSInfo.h>
#include <lal/LALStochasticConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* VCS information */
#define LALSTOCHASTIC_VCS_ID "983bcce6cab260b3a08bae6f7076d8007b8990db"
#define LALSTOCHASTIC_VCS_DATE "2017-02-6 18:17:17 +0000"
#define LALSTOCHASTIC_VCS_BRANCH "None"
#define LALSTOCHASTIC_VCS_TAG "lalstochastic-v1.1.20"
#define LALSTOCHASTIC_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALSTOCHASTIC_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALSTOCHASTIC_VCS_CLEAN "CLEAN"
#define LALSTOCHASTIC_VCS_STATUS "CLEAN: All modifications committed"

/* VCS header/library mismatch link check function */
#define LALSTOCHASTIC_VCS_LINK_CHECK LALSTOCHASTIC_CLEAN_983bcce6cab260b3a08bae6f7076d8007b8990db_VCS_HEADER_LIBRARY_MISMATCH
void LALSTOCHASTIC_VCS_LINK_CHECK(void);

#ifdef __cplusplus
}
#endif

#endif /* _LALSTOCHASTICVCSINFOHEADER_H */

/** \endcond */
