/*
 * LALStochasticVCSInfo.h - LALStochastic VCS Information
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALSTOCHASTICVCSINFO_H
#define _LALSTOCHASTICVCSINFO_H

#include <lal/LALVCSInfoType.h>

#ifdef __cplusplus
extern "C" {
#endif

/* global variables for vcs information */
extern const char *const lalStochasticVCSVersion;
extern const char *const lalStochasticVCSId;
extern const char *const lalStochasticVCSDate;
extern const char *const lalStochasticVCSBranch;
extern const char *const lalStochasticVCSTag;
extern const char *const lalStochasticVCSAuthor;
extern const char *const lalStochasticVCSCommitter;
extern const char *const lalStochasticVCSStatus;

/* global variables for vcs information - identable */
extern const char *const lalStochasticVCSIdentId;
extern const char *const lalStochasticVCSIdentDate;
extern const char *const lalStochasticVCSIdentBranch;
extern const char *const lalStochasticVCSIdentTag;
extern const char *const lalStochasticVCSIdentAuthor;
extern const char *const lalStochasticVCSIdentCommitter;
extern const char *const lalStochasticVCSIdentStatus;

/* library vcs information structure */
extern const struct tagLALVCSInfo lalStochasticVCSInfo;

/* configure arguments */
extern const char *const lalStochasticConfigureArgs;

/* configure date */
extern const char *const lalStochasticConfigureDate;

/* build date */
extern const char *const lalStochasticBuildDate;

#ifdef __cplusplus
}
#endif

#endif /* _LALSTOCHASTICVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
