%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalstochastic
Version: 1.1.16
Release: 1
Summary: LSC Algorithm Stochastic Library
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.gz
URL: https://www.lsc-group.phys.uwm.edu/daswg/projects/lalsuite.html
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: swig, python-devel, octave-devel, libmetaio-devel, numpy
BuildRequires: lal-devel >= 6.14.0
BuildRequires: lal-python >= 6.14.0
BuildRequires: lal-octave >= 6.14.0
BuildRequires: lalmetaio-devel >= 1.2.0
BuildRequires: lalmetaio-python >= 1.2.0
BuildRequires: lalmetaio-octave >= 1.2.0
Requires: libmetaio
Requires: lal >= 6.14.0
Requires: lalmetaio >= 1.2.0
Prefix: %{_prefix}

%description
The LSC Algorithm Stochastic Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL Stochastic library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Stochastic
Group: LAL
Requires: %{name} = %{version}
Requires: libmetaio-devel
Requires: lal-devel >= 6.14.0
Requires: lalmetaio-devel >= 1.2.0
%description devel
The LSC Algorithm Stochastic Library for gravitational wave data analysis.
This package contains files needed build applications that use the LAL
Stochastic library.

%package python
Summary: Python Bindings for LALStochastic
Group: LAL
Requires: %{name} = %{version}
Requires: python, numpy
Requires: lal-python >= 6.14.0
Requires: lalmetaio-python >= 1.2.0
%description python
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python bindings for LALFrame.

%package octave
Summary: Octave Bindings for LALStochastic
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.14.0
Requires: lalmetaio-octave >= 1.2.0
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALStochastic.

%prep
%setup -q

%check
%{__make} V=1 check

%build
%configure --disable-gcc-flags --enable-swig
%{__make} V=1

%install
%make_install
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/lal

%files python
%defattr(-,root,root)
%{_libdir}/python*/site-packages/lalstochastic/*.py
%{_libdir}/python*/site-packages/lalstochastic/*.pyc
%{_libdir}/python*/site-packages/lalstochastic/_lalstochastic.so*
%exclude %{_libdir}/python*/site-packages/lalstochastic/*.pyo

%files octave
%defattr(-,root,root)
%{_libexecdir}/octave/*/site/oct/*/lalstochastic.oct*
