/*
 * LALStochasticVCSInfo.h - LALStochastic VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 */

#ifndef _LALSTOCHASTICVCSINFO_H
#define _LALSTOCHASTICVCSINFO_H

#include <lal/LALVCSInfo.h>
#include <lal/LALStochasticLibVCSInfo.h>

#ifdef __cplusplus
extern "C" {
#endif

/* vcs information defines */
#define LALSTOCHASTIC_VCS_NAME "LALStochastic"
#define LALSTOCHASTIC_VCS_ID "3bfb5f9658451d9308d29441f72c658be6f6954a"
#define LALSTOCHASTIC_VCS_DATE "2014-01-07 22:51:48 +0000"
#define LALSTOCHASTIC_VCS_BRANCH "None"
#define LALSTOCHASTIC_VCS_TAG "lalstochastic-v1.1.10"
#define LALSTOCHASTIC_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALSTOCHASTIC_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALSTOCHASTIC_VCS_STATUS "CLEAN: All modifications committed"

/* vcs information defines - identable*/
#define LALSTOCHASTIC_VCS_IDENT_ID "$" "LALStochasticId: 3bfb5f9658451d9308d29441f72c658be6f6954a " "$"
#define LALSTOCHASTIC_VCS_IDENT_DATE "$" "LALStochasticDate: 2014-01-07 22:51:48 +0000 " "$"
#define LALSTOCHASTIC_VCS_IDENT_BRANCH "$" "LALStochasticBranch: None " "$"
#define LALSTOCHASTIC_VCS_IDENT_TAG "$" "LALStochasticTag: lalstochastic-v1.1.10 " "$"
#define LALSTOCHASTIC_VCS_IDENT_AUTHOR "$" "LALStochasticAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALSTOCHASTIC_VCS_IDENT_COMMITTER "$" "LALStochasticCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALSTOCHASTIC_VCS_IDENT_STATUS "$" "LALStochasticStatus: CLEAN: All modifications committed " "$"

/* vcs information structures */
static const struct tagLALVCSInfo lalStochasticHeaderVCSInfo = { \
  LALSTOCHASTIC_VCS_NAME, \
  LALSTOCHASTIC_VERSION, \
  LALSTOCHASTIC_VCS_ID, \
  LALSTOCHASTIC_VCS_DATE, \
  LALSTOCHASTIC_VCS_BRANCH, \
  LALSTOCHASTIC_VCS_TAG, \
  LALSTOCHASTIC_VCS_AUTHOR, \
  LALSTOCHASTIC_VCS_COMMITTER, \
  LALSTOCHASTIC_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALSTOCHASTICVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
