/*
 * LALSimulationVCSInfo.h - LALSimulation VCS Information
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALSIMULATIONVCSINFO_H
#define _LALSIMULATIONVCSINFO_H

#include <lal/LALVCSInfoType.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \defgroup LALSimulationVCSInfo_h Header LALSimulationVCSInfo.h
 * \ingroup lalsimulation_general
 * \brief VCS information for LALSimulation
 */
/*@{*/

/** \name Global variables for LALSimulation VCS information */
/*@{*/
extern const char *const lalSimulationVCSVersion;
extern const char *const lalSimulationVCSId;
extern const char *const lalSimulationVCSDate;
extern const char *const lalSimulationVCSBranch;
extern const char *const lalSimulationVCSTag;
extern const char *const lalSimulationVCSAuthor;
extern const char *const lalSimulationVCSCommitter;
extern const char *const lalSimulationVCSStatus;
/*@}*/

/** \name Identable global variables for LALSimulation VCS information */
/*@{*/
extern const char *const lalSimulationVCSIdentId;
extern const char *const lalSimulationVCSIdentDate;
extern const char *const lalSimulationVCSIdentBranch;
extern const char *const lalSimulationVCSIdentTag;
extern const char *const lalSimulationVCSIdentAuthor;
extern const char *const lalSimulationVCSIdentCommitter;
extern const char *const lalSimulationVCSIdentStatus;
/*@}*/

/** LALSimulation VCS information */
extern const LALVCSInfo lalSimulationVCSInfo;

/** List of VCS information for LALSimulation and its LALSuite dependencies (<tt>NULL</tt>-terminated) */
extern const LALVCSInfo *const lalSimulationVCSInfoList[32];

/** LALSimulation <tt>configure</tt> arguments */
extern const char *const lalSimulationConfigureArgs;

/** LALSimulation <tt>configure</tt> date */
extern const char *const lalSimulationConfigureDate;

/** LALSimulation build date */
extern const char *const lalSimulationBuildDate;

/** Check LALSimulation VCS information for compile-time/run-time version mismatch */
#ifndef SWIG /* exclude from SWIG interface */
int XLALSimulationVCSInfoCheck(void);
#endif /* SWIG */


/*@}*/

#ifdef __cplusplus
}
#endif

#endif /* _LALSIMULATIONVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
