/*
 * LALSimulationVCSInfo.h - LALSimulation VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 */

#ifndef _LALSIMULATIONVCSINFO_H
#define _LALSIMULATIONVCSINFO_H

#include <lal/LALVCSInfo.h>
#include <lal/LALSimulationLibVCSInfo.h>

#ifdef __cplusplus
extern "C" {
#endif

/* vcs information defines */
#define LALSIMULATION_VCS_NAME "LALSimulation"
#define LALSIMULATION_VCS_ID "4ca2fd156ed55d6dcf39c208ed8b9b60f982a349"
#define LALSIMULATION_VCS_DATE "2014-01-07 21:41:50 +0000"
#define LALSIMULATION_VCS_BRANCH "None"
#define LALSIMULATION_VCS_TAG "lalsimulation-v1.1.0"
#define LALSIMULATION_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALSIMULATION_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALSIMULATION_VCS_STATUS "CLEAN: All modifications committed"

/* vcs information defines - identable*/
#define LALSIMULATION_VCS_IDENT_ID "$" "LALSimulationId: 4ca2fd156ed55d6dcf39c208ed8b9b60f982a349 " "$"
#define LALSIMULATION_VCS_IDENT_DATE "$" "LALSimulationDate: 2014-01-07 21:41:50 +0000 " "$"
#define LALSIMULATION_VCS_IDENT_BRANCH "$" "LALSimulationBranch: None " "$"
#define LALSIMULATION_VCS_IDENT_TAG "$" "LALSimulationTag: lalsimulation-v1.1.0 " "$"
#define LALSIMULATION_VCS_IDENT_AUTHOR "$" "LALSimulationAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALSIMULATION_VCS_IDENT_COMMITTER "$" "LALSimulationCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALSIMULATION_VCS_IDENT_STATUS "$" "LALSimulationStatus: CLEAN: All modifications committed " "$"

/* vcs information structures */
static const struct tagLALVCSInfo lalSimulationHeaderVCSInfo = { \
  LALSIMULATION_VCS_NAME, \
  LALSIMULATION_VERSION, \
  LALSIMULATION_VCS_ID, \
  LALSIMULATION_VCS_DATE, \
  LALSIMULATION_VCS_BRANCH, \
  LALSIMULATION_VCS_TAG, \
  LALSIMULATION_VCS_AUTHOR, \
  LALSIMULATION_VCS_COMMITTER, \
  LALSIMULATION_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALSIMULATIONVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
