v4_code="lalpulsar_Makefakedata_v4"
comp_code="compareTS"

# The reference strain 'v2-strain.dat' was created as follows:
# 1. Checkout the last commit when the test 'testMFDv4-HW.sh' existed:
#   $ git checkout 337e29c8d1645b7de420adf9fd2c11ee2382692e
# 2. Cherry-pick a fix to LALPulsarSimulateCoherentGW:
#   $ git cherry-pick 079376cc35af3366dc278d9c9c85b742a34e0b6d
# 3. Perform a clean build of LALSuite:
#   $ git clean -Xdf
#   $ git clean -df
#   $ ./00boot
#   $ ./configure --disable-gcc-flags --disable-swig --disable-all-lal --enable-lalpulsar --enable-lalapps
#   $ make -j3
# 4. Run the test 'testMFDv4-HW.sh' in lalapps/src/pulsar/Injections/
#   $ cd lalapps/src/pulsar/Injections/
#   $ make check NOCLEANUP=1
# 5. Save the reference strain generated by lalapps_makefakedata_v2:
#   $ cd mfd_TEST-HW/
#   $ tar zcf ~/testMakefakedata_v4_hwinjection.tar.gz v2-strain.dat
v2_strain="./v2-strain.dat"

## Strain generated by lalpulsar_Makefakedata_v4, for testing
v4_strain="./v4-strain.dat"

## Error tolerance for v2-v4 strain comparison
tol=1e-4

## Input parameters
Tsft=20
duration=100       ## 100 seconds
nTsft=5            ## duration / Tsft
IFO=H1
fmin=0
Band=8192
startTime=705283213

## S5 pulsar0 parameters: http://blue.ligo-wa.caltech.edu/scirun/S5/HardwareInjection/Details/pulsar/test2_H1/
refTime=751680013       ## pulsar reference time in SSB frame
aPlus=1.6100e-21        ## plus-polarization signal amplitude
aCross=1.5685e-21       ## cross-polarization signal amplitude
psi=0.770087086         ## polarization angle psi
phi0=2.66               ## phase at tRef
Freq=265.5771052        ## GW frequency at tRef
Delta=-0.981180225      ## latitude (delta,declination) in radians
Alpha=1.248816734       ## longitude (alpha, right ascension) in radians
f1dot=-4.15E-12         ## spindown parameters d/dt f0
f2dot=0.0
f3dot=0.0

## Produce In.data-v4 file for makefakedata_v4
v4_cfg=In.data-v4
v4_log=v4.log
v4_CL="@${v4_cfg} --IFO=$IFO --fmin=$fmin --Band=$Band --Tsft=$Tsft --startTime=$startTime --duration=$duration -l $v4_log --generationMode=1 -b"

echo "
## ----- S5 pulsar0 parameters: http://blue.ligo-wa.caltech.edu/scirun/S5/HardwareInjection/Details/pulsar/test2_H1/
refTime         = $refTime              ## pulsar reference time in SSB frame

aPlus           = $aPlus                ## plus-polarization signal amplitude
aCross          = $aCross               ## cross-polarization signal amplitude
psi             = $psi                  ## polarization angle psi
phi0            = $phi0                 ## phase at tRef
Freq            = $Freq                 ## GW frequency at tRef
Delta           = $Delta                ## latitude (delta,declination) in radians
Alpha           = $Alpha                ## longitude (alpha, right ascension) in radians

f1dot           = $f1dot                ## spindown parameters d/dt f0
f2dot           = $f2dot
f3dot           = $f3dot
## --------------------------------------------------
" > $v4_cfg

echo "--------------------------------------------------------------------------------"
echo "Testing binary strain output of pulsar-signal for hardware injections ... "
echo "--------------------------------------------------------------------------------"
echo

echo "1) Running mfd_v4 injection code:"
cmdline="$v4_code $v4_CL > ${v4_strain}"
echo $cmdline
if ! eval $cmdline; then
    echo "Error.. something failed when running '$v4_code' ..."
    exit 1
fi

echo
echo "2) Comparison of resulting binary strains ..."
echo
cmdline="$comp_code -1 ${v2_strain} -2 ${v4_strain} --relErrorMax=$tol"
echo $cmdline
if ! eval $cmdline; then
    echo "Error.. comparison failed using '$comp_code' ..."
    exit 1
else
    echo "OK. Test passed within tolerance of $tol."
    echo
fi

exit 0
