%define nightly %{nil}
%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc
%define release 1

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

Name: lalmetaio
Version: 1.4.0
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
Summary: LSC Algorithm MetaIO Library
License: GPLv2+
Group: LAL
Source: %{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRequires: python2-rpm-macros
BuildRequires: libmetaio-devel
BuildRequires: numpy
BuildRequires: octave-devel
BuildRequires: python-devel
BuildRequires: swig >= 3.0.7
BuildRequires: lal-devel >= 6.19.0
BuildRequires: lal-octave >= 6.19.0
BuildRequires: python2-lal >= 6.19.0
Requires: libmetaio
Requires: lal >= 6.19.0
Prefix: %{_prefix}

%description
The LSC Algorithm MetaIO Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL MetaIO library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL MetaIO
Group: LAL
Requires: %{name} = %{version}
Requires: libmetaio-devel
Requires: lal-devel >= 6.19.0
%description devel
The LSC Algorithm MetaIO Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL MetaIO
library.

%package -n python2-%{name}
Summary: Python %{python2_version} Bindings for LALMetaIO
Group: LAL
Requires: %{name} = %{version}
Requires: numpy
Requires: python
Requires: python2-lal >= 6.19.0
Obsoletes: %{name}-python
Provides: %{name}-python
%description -n python2-%{name}
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python %{python2_version} bindings for LALMetaIO.

%package octave
Summary: Octave Bindings for LALMetaIO
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.19.0
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALMetaIO.

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
%configure --disable-gcc-flags --enable-swig
%{__make} %{?_smp_mflags} V=1

%check
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

%files
%defattr(-,root,root)
%license COPYING
%{_bindir}/lalmetaio_version
%{_libdir}/*.so.*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python2-%{name}
%defattr(-,root,root)
%license COPYING
%{python2_sitearch}/*

%files octave
%defattr(-,root,root)
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lalmetaio.oct*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 1.4.0-1
- Pre O3 release

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 1.3.1-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.3.0-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.2.8-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.2.7-1
- Pre O2 packaging test release
