%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalmetaio
Version: 1.3.0
Release: 1%{?dist}
Summary: LSC Algorithm MetaIO Library
License: GPLv2+
Group: LAL
Source: %{name}-%{version}.tar.xz
URL: https://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: libmetaio-devel
BuildRequires: numpy
BuildRequires: octave-devel
BuildRequires: python-devel
BuildRequires: swig
BuildRequires: lal-devel >= 6.17.0
BuildRequires: lal-python >= 6.17.0
BuildRequires: lal-octave >= 6.17.0
Requires: libmetaio
Requires: lal >= 6.17.0
Prefix: %{_prefix}

%description
The LSC Algorithm MetaIO Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL MetaIO library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL MetaIO
Group: LAL
Requires: %{name} = %{version}
Requires: libmetaio-devel
Requires: lal-devel >= 6.17.0
%description devel
The LSC Algorithm MetaIO Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL MetaIO
library.

%package python
Summary: Python Bindings for LALMetaIO
Group: LAL
Requires: %{name} = %{version}
Requires: numpy
Requires: python
Requires: lal-python >= 6.17.0
%description python
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python bindings for LALMetaIO.

%package octave
Summary: Octave Bindings for LALMetaIO
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.17.0
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALMetaIO.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so.*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files python
%defattr(-,root,root)
%{_libdir}/python*

%files octave
%defattr(-,root,root)
%{_prefix}/lib*/octave/*/site/oct/*/lalmetaio.oct*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.3.0-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.2.8-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.2.7-1
- Pre O2 packaging test release
