/*
 * LALMetaIOVCSInfo.h - LALMetaIO VCS Information
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALMETAIOVCSINFO_H
#define _LALMETAIOVCSINFO_H

#include <lal/LALVCSInfoType.h>

#ifdef __cplusplus
extern "C" {
#endif

/* global variables for vcs information */
extern const char *const lalMetaIOVCSVersion;
extern const char *const lalMetaIOVCSId;
extern const char *const lalMetaIOVCSDate;
extern const char *const lalMetaIOVCSBranch;
extern const char *const lalMetaIOVCSTag;
extern const char *const lalMetaIOVCSAuthor;
extern const char *const lalMetaIOVCSCommitter;
extern const char *const lalMetaIOVCSStatus;

/* global variables for vcs information - identable */
extern const char *const lalMetaIOVCSIdentId;
extern const char *const lalMetaIOVCSIdentDate;
extern const char *const lalMetaIOVCSIdentBranch;
extern const char *const lalMetaIOVCSIdentTag;
extern const char *const lalMetaIOVCSIdentAuthor;
extern const char *const lalMetaIOVCSIdentCommitter;
extern const char *const lalMetaIOVCSIdentStatus;

/* library vcs information structure */
extern const struct tagLALVCSInfo lalMetaIOVCSInfo;

/* configure arguments */
extern const char *const lalMetaIOConfigureArgs;

/* configure date */
extern const char *const lalMetaIOConfigureDate;

/* build date */
extern const char *const lalMetaIOBuildDate;

#ifdef __cplusplus
}
#endif

#endif /* _LALMETAIOVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
