/*
 * LALInspiralVCSInfo.h - LALInspiral VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 */

#ifndef _LALINSPIRALVCSINFO_H
#define _LALINSPIRALVCSINFO_H

#include <lal/LALVCSInfo.h>
#include <lal/LALInspiralLibVCSInfo.h>

#ifdef __cplusplus
extern "C" {
#endif

/* vcs information defines */
#define LALINSPIRAL_VCS_NAME "LALInspiral"
#define LALINSPIRAL_VCS_ID "2ec014ce99bd1bb9a1f8c05868a586ab893736ca"
#define LALINSPIRAL_VCS_DATE "2014-02-14 16:52:29 +0000"
#define LALINSPIRAL_VCS_BRANCH "lalsuite_er5_branch"
#define LALINSPIRAL_VCS_TAG "lalinspirl-v1.5.3"
#define LALINSPIRAL_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALINSPIRAL_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALINSPIRAL_VCS_STATUS "CLEAN: All modifications committed"

/* vcs information defines - identable*/
#define LALINSPIRAL_VCS_IDENT_ID "$" "LALInspiralId: 2ec014ce99bd1bb9a1f8c05868a586ab893736ca " "$"
#define LALINSPIRAL_VCS_IDENT_DATE "$" "LALInspiralDate: 2014-02-14 16:52:29 +0000 " "$"
#define LALINSPIRAL_VCS_IDENT_BRANCH "$" "LALInspiralBranch: lalsuite_er5_branch " "$"
#define LALINSPIRAL_VCS_IDENT_TAG "$" "LALInspiralTag: lalinspirl-v1.5.3 " "$"
#define LALINSPIRAL_VCS_IDENT_AUTHOR "$" "LALInspiralAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALINSPIRAL_VCS_IDENT_COMMITTER "$" "LALInspiralCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALINSPIRAL_VCS_IDENT_STATUS "$" "LALInspiralStatus: CLEAN: All modifications committed " "$"

/* vcs information structures */
static const struct tagLALVCSInfo lalInspiralHeaderVCSInfo = { \
  LALINSPIRAL_VCS_NAME, \
  LALINSPIRAL_VERSION, \
  LALINSPIRAL_VCS_ID, \
  LALINSPIRAL_VCS_DATE, \
  LALINSPIRAL_VCS_BRANCH, \
  LALINSPIRAL_VCS_TAG, \
  LALINSPIRAL_VCS_AUTHOR, \
  LALINSPIRAL_VCS_COMMITTER, \
  LALINSPIRAL_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALINSPIRALVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
