%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalinspiral
Version: 1.5.3
Release: 1
Summary: LSC Algorithm Inspiral Library
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.gz
URL: https://www.lsc-group.phys.uwm.edu/daswg/projects/lalsuite.html
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: swig python-devel octave-devel
Requires: gsl libframe libmetaio lal lalframe lalmetaio lalsimulation
Prefix: %{_prefix}

%description
The LSC Algorithm Inspiral Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Inspiral library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Inspiral
Group: LAL
Requires: %{name} = %{version}
Requires: gsl-devel libframe-devel libmetaio-devel lal-devel lalframe-devel lalmetaio-devel lalsimulation-devel
%description devel
The LSC Algorithm Inspiral Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Inspiral
library.

%package python
Summary: Python bindings for LALInspiral
Group: LAL
Requires: %{name} = %{version}
Requires: python numpy lal-python lalframe-python lalmetaio-python lalsimulation-python
%description python
This package provides the Python bindings for LALInspiral.

%package octave
Summary: Octave bindings for LALInspiral
Group: LAL
Requires: %{name} = %{version}
Requires: octave lal-octave lalframe-octave lalmetaio-octave lalsimulation-octave
%description octave
This package provides the Octave bindings for LALInspiral.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig
%{__make} V=1

%install
%makeinstall
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/lal

%files python
%defattr(-,root,root)
%{_libdir}/python*/site-packages/lalinspiral/*.py
%{_libdir}/python*/site-packages/lalinspiral/*.pyc
%{_libdir}/python*/site-packages/lalinspiral/_lalinspiral.so*
%{_libdir}/python*/site-packages/lalinspiral/sbank/*.py
%{_libdir}/python*/site-packages/lalinspiral/sbank/*.pyc
%exclude %{_libdir}/python*/site-packages/lalinspiral/*.pyo
%exclude %{_libdir}/python*/site-packages/lalinspiral/*.la
%exclude %{_libdir}/python*/site-packages/lalinspiral/sbank/*.pyo

%files octave
%defattr(-,root,root)
%{_libexecdir}/octave/*/site/oct/*/lalinspiral.oct*
%exclude %{_libexecdir}/octave/*/site/oct/*/lalinspiral.la
