%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalinference
Version: 1.8.0
Release: 1%{?dist}
Summary: LSC Algorithm Inference Library
License: GPLv2+
Group: LAL
Source: %{name}-%{version}.tar.xz
URL: https://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: chealpix-devel
BuildRequires: gsl-devel
BuildRequires: hdf5-devel
BuildRequires: healpy >= 1.9.1
BuildRequires: python-basemap
BuildRequires: libmetaio-devel
BuildRequires: libxml2-devel
BuildRequires: numpy
BuildRequires: octave-devel
BuildRequires: python-devel
BuildRequires: scipy
BuildRequires: swig
BuildRequires: glue >= 1.49.1
BuildRequires: glue-common >= 1.49.1
BuildRequires: glue-segments >= 1.49.1
BuildRequires: lal-devel >= 6.17.0
BuildRequires: lal-python >= 6.17.0
BuildRequires: lal-octave >= 6.17.0
BuildRequires: lalmetaio-devel >= 1.3.0
BuildRequires: lalmetaio-python >= 1.3.0
BuildRequires: lalmetaio-octave >= 1.3.0
BuildRequires: lalxml-devel >= 1.2.3
BuildRequires: lalxml-python >= 1.2.3
BuildRequires: lalxml-octave >= 1.2.3
BuildRequires: lalsimulation-devel >= 1.6.1
BuildRequires: lalsimulation-python >= 1.6.1
BuildRequires: lalsimulation-octave >= 1.6.1
BuildRequires: lalburst-devel >= 1.4.3
BuildRequires: lalburst-python >= 1.4.3
BuildRequires: lalburst-octave >= 1.4.3
BuildRequires: lalinspiral-devel >= 1.7.6
BuildRequires: lalinspiral-python >= 1.7.6
BuildRequires: lalinspiral-octave >= 1.7.6
BuildRequires: lalpulsar-devel >= 1.15.0
BuildRequires: lalpulsar-python >= 1.15.0
BuildRequires: lalpulsar-octave >= 1.15.0
Requires: chealpix
Requires: gsl >= 1.15
Requires: hdf5
Requires: libmetaio
Requires: libxml2
Requires: lal >= 6.17.0
Requires: lalmetaio >= 1.3.0
Requires: lalxml >= 1.2.3
Requires: lalsimulation >= 1.6.1
Requires: lalburst >= 1.4.3
Requires: lalinspiral >= 1.7.6
Requires: lalpulsar >= 1.15.0
Prefix: %{_prefix}

%description
The LSC Algorithm Inference Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Inference library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Inference
Group: LAL
Requires: %{name} = %{version}
Requires: chealpix-devel
Requires: gsl-devel >= 1.15
Requires: libmetaio-devel
Requires: libxml2-devel
Requires: lal-devel >= 6.17.0
Requires: lalmetaio-devel >= 1.3.0
Requires: lalxml-devel >= 1.2.3
Requires: lalsimulation-devel >= 1.6.1
Requires: lalburst-devel >= 1.4.3
Requires: lalinspiral-devel >= 1.7.6
Requires: lalpulsar-devel >= 1.15.0
%description devel
The LSC Algorithm Inference Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Inference
library.

%package python
Summary: Python Bindings for LALInference
Group: LAL
Requires: %{name} = %{version}
Requires: healpy >= 1.9.1
Requires: python-basemap
Requires: numpy
Requires: python
Requires: scipy
Requires: python-six
Requires: glue >= 1.49.1
Requires: glue-common >= 1.49.1
Requires: glue-segments >= 1.49.1
Requires: lal-python >= 6.17.0
Requires: lalmetaio-python >= 1.3.0
Requires: lalxml-python >= 1.2.3
Requires: lalsimulation-python >= 1.6.1
Requires: lalburst-python >= 1.4.3
Requires: lalinspiral-python >= 1.7.6
Requires: lalpulsar-python >= 1.15.0
%description python
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python bindings for LALInference.

%package octave
Summary: Octave Bindings for LALInference
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.17.0
Requires: lalmetaio-octave >= 1.3.0
Requires: lalxml-octave >= 1.2.3
Requires: lalsimulation-octave >= 1.6.1
Requires: lalburst-octave >= 1.4.3
Requires: lalinspiral-octave >= 1.7.6
Requires: lalpulsar-octave >= 1.15.0
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALInference.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig --enable-openmp
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_bindir}/lalinference_*
%{_datarootdir}/lalinference/*
%{_libdir}/*.so.*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files python
%defattr(-,root,root)
%{_bindir}/bayestar_*
%{_bindir}/imrtgr_*
%{_bindir}/rapidpe_*
%{_libdir}/python*

%files octave
%defattr(-,root,root)
%{_prefix}/lib*/octave/*/site/oct/*/lalinference.oct*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.8.0-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.7.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.6.0-1
- Pre O2 packaging test release
