%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalinference
Version: 1.3.1
Release: 1
Summary: LSC Algorithm Inference Library
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.gz
URL: https://www.lsc-group.phys.uwm.edu/daswg/projects/lalsuite.html
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: swig python-devel octave-devel
Requires: chealpix healpy gsl libmetaio lal lalmetaio lalsimulation lalinspiral lalpulsar
Prefix: %{_prefix}

%description
The LSC Algorithm Inference Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Inference library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Inference
Group: LAL
Requires: %{name} = %{version}
Requires: chealpix-devel gsl-devel libmetaio-devel lal-devel lalmetaio-devel lalsimulation-devel lalinspiral-devel lalpulsar-devel
%description devel
The LSC Algorithm Inference Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Inference
library.

%package python
Summary: Python Bindings for LALInference
Group: LAL
Requires: %{name} = %{version}
Requires: python numpy lal-python lalmetaio-python lalsimulation-python lalinspiral-python lalpulsar-python
%description python
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python bindings for LALInference.

%package octave
Summary: Octave Bindings for LALInference
Group: LAL
Requires: %{name} = %{version}
Requires: octave lal-octave lalmetaio-octave lalsimulation-octave lalinspiral-octave lalpulsar-octave
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALInference.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig --enable-openmp
%{__make} V=1

%install
%makeinstall
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/lal

%files python
%defattr(-,root,root)
%{_bindir}/bayestar_*
%{_libdir}/python*/site-packages/lalinference/*.py
%{_libdir}/python*/site-packages/lalinference/*.pyc
%{_libdir}/python*/site-packages/lalinference/bayestar/*.py
%{_libdir}/python*/site-packages/lalinference/bayestar/*.pyc
%{_libdir}/python*/site-packages/lalinference/bayestar/ne_simplified_coastline.json
%{_libdir}/python*/site-packages/lalinference/bayestar/sky_map.so*
%{_libdir}/python*/site-packages/lalinference/_lalinference.so*
%exclude %{_libdir}/python*/site-packages/lalinference/*.pyo
%exclude %{_libdir}/python*/site-packages/lalinference/bayestar/*.pyo
%exclude %{_libdir}/python*/site-packages/lalinference/*.la
%exclude %{_libdir}/python*/site-packages/lalinference/bayestar/*.la

%files octave
%defattr(-,root,root)
%{_libexecdir}/octave/*/site/oct/*/lalinference.oct*
%exclude %{_libexecdir}/octave/*/site/oct/*/lalinference.la
