/*
 * Copyright (C) 2014, 2016 Karl Wette
 * Copyright (C) 2009-2013 Adam Mercer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * LALFrameVCSInfo.h - LALFrame VCS Information Header
 */

/** \cond DONT_DOXYGEN */

#ifndef _LALFRAMEVCSINFOHEADER_H
#define _LALFRAMEVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALFrameVCSInfo.h>
#include <lal/LALFrameConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* VCS information */
#define LALFRAME_VCS_ID "580aa0589d9493ab7d1b5412937bb6168f53f9d8"
#define LALFRAME_VCS_DATE "2018-09-25 18:21:50 +0000"
#define LALFRAME_VCS_BRANCH "None"
#define LALFRAME_VCS_TAG "lalframe-v1.4.4"
#define LALFRAME_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALFRAME_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALFRAME_VCS_CLEAN "CLEAN"
#define LALFRAME_VCS_STATUS "CLEAN: All modifications committed"

#if LALFRAME_VERSION_DEVEL != 0
/* VCS header/library mismatch link check function */
#define LALFRAME_VCS_LINK_CHECK LALFRAME_CLEAN_580aa0589d9493ab7d1b5412937bb6168f53f9d8_VCS_HEADER_LIBRARY_MISMATCH
void LALFRAME_VCS_LINK_CHECK(void);
#endif

#ifdef __cplusplus
}
#endif

#endif /* _LALFRAMEVCSINFOHEADER_H */

/** \endcond */
