/*
*  Copyright (C) 2007 Duncan Brown, Stephen Fairhurst
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with with program; see the file COPYING. If not, write to the
*  Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
*  MA  02111-1307  USA
*/
#include <lal/LALDatatypes.h>
#include <lal/Calibration.h>
#include <lal/LALCache.h>
#ifndef _FRAMECALIBRATION_H
#define _FRAMECALIBRATION_H

#if defined(__cplusplus)
extern "C" {
#elif 0
}       /* so that editors will match preceding brace */
#endif

/**
 * \defgroup FrameCalibration_h Header FrameCalibration.h
 * \ingroup pkg_framedata
 *
 * \author Brown, D. A.
 *
 * High-level routines for exctracting calibration data from frames
 *
 * ### Synopsis ###
 *
 * \code
 * #include <lal/FrameCalibration.h>
 * \endcode
 *
 * Provides a high level interface for building a transfer or response
 * functions from raw calibration data provided by the calibration team.
 *
 */
/*@{*/

/**
 *
 * ### Error conditions ###
 *
 * These error conditions are generated by the function
 * <tt>ExtractFrameCalibration()</tt> if it encounters an error.
 * If codes 1 through 7 are returned, the no calibration has
 * been generated since there was an error reading the reference
 * calibration. If an error occours once the reference calibration
 * has been read in, then the reference calibration is returned
 * without being updated. This allows the user the option to
 * trap the error and fall back on the reference calibration or
 * to give up completely. This can be done in the case of error
 * code 8, or error code \f$-1\f$, which indicates an error in one
 * of the functions used to update the reference calibration.
 *
 */
/**\name Error Codes */
/*@{*/
#define FRAMECALIBRATIONH_ENULL 1
#define FRAMECALIBRATIONH_ENNUL 2
#define FRAMECALIBRATIONH_EMCHE 3
#define FRAMECALIBRATIONH_ECREF 4
#define FRAMECALIBRATIONH_EOREF 5
#define FRAMECALIBRATIONH_EDCHE 6
#define FRAMECALIBRATIONH_EREFR 7
#define FRAMECALIBRATIONH_ECFAC 8
#define FRAMECALIBRATIONH_EDTMM 9
#define FRAMECALIBRATIONH_EMETH 10

#define FRAMECALIBRATIONH_MSGENULL "No calibration generated: Null pointer"
#define FRAMECALIBRATIONH_MSGENNUL "No calibration generated: Non-null pointer"
#define FRAMECALIBRATIONH_MSGEMCHE "No calibration generated: unable to open calibration cache file"
#define FRAMECALIBRATIONH_MSGECREF "No calibration generated: no reference calibration in cache"
#define FRAMECALIBRATIONH_MSGEOREF "No calibration generated: unable to open reference frame"
#define FRAMECALIBRATIONH_MSGEDCHE "No calibration generated: error reference calibration cache"
#define FRAMECALIBRATIONH_MSGEREFR "No calibration generated: error reading refernce calibration"
#define FRAMECALIBRATIONH_MSGECFAC "Calibration not updated: no update factor frames in cache"
#define FRAMECALIBRATIONH_MSGEDTMM "Calibration not updated: mismatch between sample rate of alpha and alpha*beta"
#define FRAMECALIBRATIONH_MSGEMETH "Calibration cache must either be read from a file or globbed"
/*@}*/

void
LALExtractFrameResponse(LALStatus * status,
    COMPLEX8FrequencySeries * output,
    LALCache * calCache, CalibrationUpdateParams * calfacts);

void
LALCreateCalibFrCache(LALStatus * status,
    LALCache ** output,
    const CHAR * calCacheName,
    const CHAR * dirstr, const CHAR * calGlobPattern);

/*@}*/

#if 0
{       /* so that editors will match succeeding brace */
#elif defined(__cplusplus)
}
#endif

#endif /* _FRAMECALIBRATION_H */
