/*
 * LALDetCharVCSInfo.h - LALDetChar VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALDETCHARVCSINFOHEADER_H
#define _LALDETCHARVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALDetCharVCSInfo.h>
#include <lal/LALDetCharConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* vcs information defines */
#define LALDETCHAR_NAME "LALDetChar"
#define LALDETCHAR_VCS_ID "78798adbe004db4417f7b4ff9114163426c3fcd1"
#define LALDETCHAR_VCS_DATE "2015-08-3 22:14:27 +0000"
#define LALDETCHAR_VCS_BRANCH "None"
#define LALDETCHAR_VCS_TAG "laldetchar-v0.3.1"
#define LALDETCHAR_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALDETCHAR_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALDETCHAR_VCS_STATUS "CLEAN: All modifications committed"

/* vcs information defines - identable*/
#define LALDETCHAR_VCS_IDENT_ID "$" "LALDetCharId: 78798adbe004db4417f7b4ff9114163426c3fcd1 " "$"
#define LALDETCHAR_VCS_IDENT_DATE "$" "LALDetCharDate: 2015-08-3 22:14:27 +0000 " "$"
#define LALDETCHAR_VCS_IDENT_BRANCH "$" "LALDetCharBranch: None " "$"
#define LALDETCHAR_VCS_IDENT_TAG "$" "LALDetCharTag: laldetchar-v0.3.1 " "$"
#define LALDETCHAR_VCS_IDENT_AUTHOR "$" "LALDetCharAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALDETCHAR_VCS_IDENT_COMMITTER "$" "LALDetCharCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALDETCHAR_VCS_IDENT_STATUS "$" "LALDetCharStatus: CLEAN: All modifications committed " "$"

/* header vcs information structure */
static const struct tagLALVCSInfo lalDetCharVCSInfoHeader = { \
  LALDETCHAR_NAME, \
  LALDETCHAR_VERSION, \
  LALDETCHAR_VCS_ID, \
  LALDETCHAR_VCS_DATE, \
  LALDETCHAR_VCS_BRANCH, \
  LALDETCHAR_VCS_TAG, \
  LALDETCHAR_VCS_AUTHOR, \
  LALDETCHAR_VCS_COMMITTER, \
  LALDETCHAR_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALDETCHARVCSINFOHEADER_H */

/*
 * vim: tw=0 ts=2 et
 */
