/*
 * LALBurstVCSInfo.h - LALBurst VCS Information
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALBURSTVCSINFO_H
#define _LALBURSTVCSINFO_H

#include <lal/LALVCSInfoType.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \defgroup LALBurstVCSInfo_h Header LALBurstVCSInfo.h
 * \ingroup lalburst_general
 * \brief VCS information for LALBurst
 */
/*@{*/

/** \name Global variables for LALBurst VCS information */
/*@{*/
extern const char *const lalBurstVCSVersion;
extern const char *const lalBurstVCSId;
extern const char *const lalBurstVCSDate;
extern const char *const lalBurstVCSBranch;
extern const char *const lalBurstVCSTag;
extern const char *const lalBurstVCSAuthor;
extern const char *const lalBurstVCSCommitter;
extern const char *const lalBurstVCSStatus;
/*@}*/

/** \name Identable global variables for LALBurst VCS information */
/*@{*/
extern const char *const lalBurstVCSIdentId;
extern const char *const lalBurstVCSIdentDate;
extern const char *const lalBurstVCSIdentBranch;
extern const char *const lalBurstVCSIdentTag;
extern const char *const lalBurstVCSIdentAuthor;
extern const char *const lalBurstVCSIdentCommitter;
extern const char *const lalBurstVCSIdentStatus;
/*@}*/

/** LALBurst VCS information */
extern const LALVCSInfo lalBurstVCSInfo;

/** List of VCS information for LALBurst and its LALSuite dependencies (<tt>NULL</tt>-terminated) */
extern const LALVCSInfo *const lalBurstVCSInfoList[32];

/** LALBurst <tt>configure</tt> arguments */
extern const char *const lalBurstConfigureArgs;

/** LALBurst <tt>configure</tt> date */
extern const char *const lalBurstConfigureDate;

/** LALBurst build date */
extern const char *const lalBurstBuildDate;

/** Check LALBurst VCS information for compile-time/run-time version mismatch */
#ifndef SWIG /* exclude from SWIG interface */
int XLALBurstVCSInfoCheck(void);
#endif /* SWIG */


/*@}*/

#ifdef __cplusplus
}
#endif

#endif /* _LALBURSTVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
