%define nightly %{nil}
%define release 1
%define _sysconfdir %{_prefix}/etc

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

Name: lalapps
Version: 6.26.0
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
Summary: LSC Algorithm Library Applications
License: GPLv2+
Group: LAL
Source: %{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/Computing/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRequires: bc
BuildRequires: cfitsio-devel
BuildRequires: fftw-devel
BuildRequires: libframel-devel >= 8.39.2
BuildRequires: gcc
BuildRequires: gsl-devel
BuildRequires: help2man
BuildRequires: less
BuildRequires: lal-devel >= 7.0.0
BuildRequires: lalburst-devel >= 1.5.3
BuildRequires: lalframe-devel >= 1.5.0
BuildRequires: lalinference-devel >= 2.0.0
BuildRequires: lalinspiral-devel >= 1.10.0
BuildRequires: lalmetaio-devel >= 1.6.0
BuildRequires: lalpulsar-devel >= 2.0.0
BuildRequires: lalsimulation-devel >= 2.1.0
BuildRequires: make
BuildRequires: pkgconfig >= 0.18.0
BuildRequires: python2-lal >= 7.0.0
BuildRequires: python2-lalframe >= 1.5.0
BuildRequires: python2-lalmetaio >= 1.6.0
BuildRequires: python2-lalsimulation >= 2.1.0
BuildRequires: python2-lalburst >= 1.5.3
BuildRequires: python2-lalinspiral >= 1.10.0
BuildRequires: python2-lalpulsar >= 2.0.0
BuildRequires: python2-lalinference >= 2.0.0
BuildRequires: python2-rpm-macros
Requires: cfitsio
Requires: fftw
Requires: gsl
Requires: lal >= 7.0.0
Requires: lalburst >= 1.5.3
Requires: lalframe >= 1.5.0
Requires: lalinference >= 2.0.0
Requires: lalinspiral >= 1.10.0
Requires: lalmetaio >= 1.6.0
Requires: lalpulsar >= 2.0.0
Requires: lalsimulation >= 2.1.0
Requires: less
Requires: libframel >= 8.39.2
Requires: python
Requires: python2-h5py
Requires: python2-lal >= 7.0.0
Requires: python2-lalframe >= 1.5.0
Requires: python2-lalmetaio >= 1.6.0
Requires: python2-lalsimulation >= 2.1.0
Requires: python2-lalburst >= 1.5.3
Requires: python2-lalinspiral >= 1.10.0
Requires: python2-lalpulsar >= 2.0.0
Requires: python2-lalinference >= 2.0.0
Requires: python2-ligo-lw
Requires: python2-ligo-segments
Requires: python2-matplotlib
Requires: python2-numpy
Requires: python2-scipy
Requires: python2-six
Obsoletes: lalxml < 1.2.5-1
Obsoletes: lalxml-debuginfo < 1.2.5-1
Obsoletes: lalxml-devel < 1.2.5-1
Obsoletes: lalxml-python < 1.2.5-1
Obsoletes: lalxml-python3 < 1.2.5-1
Obsoletes: lalxml-octave < 1.2.5-1
Obsoletes: laldetchar < 0.3.6-1
Obsoletes: laldetchar-debuginfo < 0.3.6-1
Obsoletes: laldetchar-devel < 0.3.6-1
Obsoletes: laldetchar-python < 0.3.6-1
Obsoletes: laldetchar-octave < 0.3.6-1
Obsoletes: lalstochastic < 1.1.21-1
Obsoletes: lalstochastic-debuginfo < 1.1.21-1
Obsoletes: lalstochastic-devel < 1.1.21-1
Obsoletes: lalstochastic-python < 1.1.21-1
Obsoletes: lalstochastic-python3 < 1.1.21-1
Obsoletes: lalstochastic-octave < 1.1.21-1
Provides: lalxml = 1.2.5-1
Provides: lalxml-debuginfo = 1.2.5-1
Provides: lalxml-devel = 1.2.5-1
Provides: lalxml-python = 1.2.5-1
Provides: lalxml-python3 = 1.2.5-1
Provides: lalxml-octave = 1.2.5-1
Provides: laldetchar = 0.3.6-1
Provides: laldetchar-debuginfo = 0.3.6-1
Provides: laldetchar-devel = 0.3.6-1
Provides: laldetchar-python = 0.3.6-1
Provides: laldetchar-octave = 0.3.6-1
Provides: lalstochastic = 1.1.21-1
Provides: lalstochastic-debuginfo = 1.1.21-1
Provides: lalstochastic-devel = 1.1.21-1
Provides: lalstochastic-python = 1.1.21-1
Provides: lalstochastic-python3 = 1.1.21-1
Provides: lalstochastic-octave = 1.1.21-1

Prefix: %{_prefix}

%description
The LSC Algorithm Library Applications for gravitational wave data analysis.
This package contains applications that are built on tools in the LSC
Algorithm Library.

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
# force linking agsinst system libmpi
export OMPI_LIBS="-lmpi -Wl,--disable-new-dtags"
%configure --disable-gcc-flags --enable-cfitsio --enable-openmp
%{__make} %{?_smp_mflags} V=1

%check
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check
# check python import
env PYTHONPATH="%{buildroot}%{python2_sitearch}" \
%{__python2} -c "import %{name}"

%install
%make_install

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

%files
%defattr(-,root,root)
%license COPYING
%{_bindir}/*
%{_datadir}/lalapps/*
%{_mandir}/man1/*
%{_sysconfdir}/lalapps-user-env.*
%{python2_sitearch}

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Jun 08 2020 Adam Mercer <adam.mercer@ligo.org> 6.26.0-1
- Update for 6.26.0

* Mon Jan 13 2020 Adam Mercer <adam.mercer@ligo.org> 6.25.1-1
- MakeSFTs.c: fix incorrect XLAL error checks

* Mon Dec 09 2019 Adam Mercer <adam.mercer@ligo.org> 6.25.0-2
- Packaging updates

* Wed Nov 27 2019 Adam Mercer <adam.mercer@ligo.org> 6.25.0-1
- O3b release

* Thu May 23 2019 Adam Mercer <adam.mercer@ligo.org> 6.24.0-1
- O3 Release

* Mon Feb 25 2019 Adam Mercer <adam.mercer@ligo.org> 6.23.0-1
- ER14 release

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 6.22.0-1
- Pre O3 release

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 6.21.0-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 6.20.0-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 6.19.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 6.18.0-1
- Pre O2 packaging test release
