%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc
%define _pkgpythondir %{_prefix}/lib64/python2.?/site-packages/lalapps
%define _pkgpyexecdir %{_libdir}/python2.?/site-packages/lalapps

Name: lalapps
Version: 6.21.0
Release: 1%{?dist}
Summary: LSC Algorithm Library Applications
License: GPLv2+
Group: LAL
Source: %{name}-%{version}.tar.xz
URL: https://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: cfitsio-devel
BuildRequires: fftw-devel
BuildRequires: gsl-devel
BuildRequires: less
BuildRequires: libframe-devel
BuildRequires: libmetaio-devel
BuildRequires: openmpi-devel
BuildRequires: lal-devel >= 6.18.0
BuildRequires: lal-python >= 6.18.0
BuildRequires: lalframe-devel >= 1.4.3
BuildRequires: lalframe-python >= 1.4.3
BuildRequires: lalmetaio-devel >= 1.3.1
BuildRequires: lalmetaio-python >= 1.3.1
BuildRequires: lalxml-devel >= 1.2.4
BuildRequires: lalxml-python >= 1.2.4
BuildRequires: lalsimulation-devel >= 1.7.0
BuildRequires: lalsimulation-python >= 1.7.0
BuildRequires: lalburst-devel >= 1.4.4
BuildRequires: lalburst-python >= 1.4.4
BuildRequires: lalinspiral-devel >= 1.7.7
BuildRequires: lalinspiral-python >= 1.7.7
BuildRequires: lalstochastic-devel >= 1.1.20
BuildRequires: lalstochastic-python >= 1.1.20
BuildRequires: lalpulsar-devel >= 1.16.0
BuildRequires: lalpulsar-python >= 1.16.0
BuildRequires: lalinference-devel >= 1.9.0
BuildRequires: lalinference-python >= 1.9.0
Requires: cfitsio
Requires: fftw
Requires: gsl
Requires: h5py
Requires: healpy
Requires: less
Requires: libframe
Requires: libmetaio
Requires: openmpi
Requires: python
Requires: lal >= 6.18.0
Requires: lal-python >= 6.18.0
Requires: lalframe >= 1.4.3
Requires: lalframe-python >= 1.4.3
Requires: lalmetaio >= 1.3.1
Requires: lalmetaio-python >= 1.3.1
Requires: lalxml >= 1.2.4
Requires: lalxml-python >= 1.2.4
Requires: lalsimulation  >= 1.7.0
Requires: lalsimulation-python >= 1.7.0
Requires: lalburst >= 1.4.4
Requires: lalburst-python >= 1.4.4
Requires: lalinspiral >= 1.7.7
Requires: lalinspiral-python >= 1.7.7
Requires: lalstochastic >= 1.1.20
Requires: lalstochastic-python >= 1.1.20
Requires: lalpulsar >= 1.16.0
Requires: lalpulsar-python >= 1.16.0
Requires: lalinference >= 1.9.0
Requires: lalinference-python >= 1.9.0
Requires: skyarea
Prefix: %{_prefix}

%description
The LSC Algorithm Library Applications for gravitational wave data analysis.
This package contains applications that are built on tools in the LSC
Algorithm Library.

%prep
%setup -q

%build
nightly_version=
%configure --enable-nightly=${nightly_version:-no} --disable-gcc-flags --enable-cfitsio --enable-openmp --enable-mpi MPICC=/usr/lib64/openmpi/bin/mpicc MPICXX=/usr/lib64/openmpi/bin/mpicxx MPIFC=/usr/lib64/openmpi/bin/mpifc
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_bindir}/*
%{_datadir}/lalapps/*
%{_mandir}/man1/*
%{_pkgpythondir}/*
%{_sysconfdir}/lalapps-user-env.*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 6.21.0-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 6.20.0-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 6.19.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 6.18.0-1
- Pre O2 packaging test release
