/*
 * LALAppsVCSInfo.h - LALApps VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 */

#ifndef _LALAPPSVCSINFO_H
#define _LALAPPSVCSINFO_H

#include <config.h>

#include <lal/LALVCSInfo.h>

#ifdef __cplusplus
extern "C" {
#endif

/* vcs information defines */
#define LALAPPS_VCS_NAME "LALApps"
#define LALAPPS_VCS_ID "acd3d68695ac3c14bcaf69d18729dab2c57f8a0f"
#define LALAPPS_VCS_DATE "2014-01-07 22:58:35 +0000"
#define LALAPPS_VCS_BRANCH "None"
#define LALAPPS_VCS_TAG "lalapps-v6.14.0"
#define LALAPPS_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALAPPS_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALAPPS_VCS_STATUS "CLEAN: All modifications committed"

/* vcs information defines - identable*/
#define LALAPPS_VCS_IDENT_ID "$" "LALAppsId: acd3d68695ac3c14bcaf69d18729dab2c57f8a0f " "$"
#define LALAPPS_VCS_IDENT_DATE "$" "LALAppsDate: 2014-01-07 22:58:35 +0000 " "$"
#define LALAPPS_VCS_IDENT_BRANCH "$" "LALAppsBranch: None " "$"
#define LALAPPS_VCS_IDENT_TAG "$" "LALAppsTag: lalapps-v6.14.0 " "$"
#define LALAPPS_VCS_IDENT_AUTHOR "$" "LALAppsAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALAPPS_VCS_IDENT_COMMITTER "$" "LALAppsCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALAPPS_VCS_IDENT_STATUS "$" "LALAppsStatus: CLEAN: All modifications committed " "$"

/* global variables for vcs information, defined in LALAppsVCSInfo.c */
extern const char *const lalAppsVCSVersion;
extern const char *const lalAppsVCSId;
extern const char *const lalAppsVCSDate;
extern const char *const lalAppsVCSBranch;
extern const char *const lalAppsVCSTag;
extern const char *const lalAppsVCSAuthor;
extern const char *const lalAppsVCSCommitter;
extern const char *const lalAppsVCSStatus;

/* vcs information structure */
extern const struct tagLALVCSInfo lalAppsVCSInfo;

#ifdef __cplusplus
}
#endif

#endif /* _LALAPPSVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
