%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lal
Version: 6.17.0
Release: 1%{?dist}
Summary: LSC Algorithm Library
License: GPLv2+
Group: LAL
Source: %{name}-%{version}.tar.xz
URL: https://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: bc
BuildRequires: fftw-devel
BuildRequires: gsl-devel
BuildRequires: hdf5-devel
BuildRequires: numpy
BuildRequires: octave-devel
BuildRequires: python-devel
BuildRequires: swig
Requires: fftw
Requires: gsl
Requires: hdf5
Prefix: %{_prefix}

%description
The LSC Algorithm Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL
Group: LAL
Requires: %{name} = %{version}
Requires: fftw-devel
Requires: gsl-devel
Requires: hdf5-devel
%description devel
The LSC Algorithm Library for gravitational wave data analysis.
This package contains files needed build applications that use the LAL library
as well as the documentation for the library.

%package python
Summary: Python bindings for LAL
Group: LAL
Requires: %{name} = %{version}
Requires: numpy
Requires: python
%description python
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python bindings.

%package octave
Summary: Octave bindings for LAL
Group: LAL
Requires: %{name} = %{version}
Requires: octave
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_bindir}/lal-simd-detect
%{_bindir}/lal-version
%{_libdir}/*.so.*
%{_sysconfdir}/lal-user-env.*

%files devel
%defattr(-,root,root)
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files python
%defattr(-,root,root)
%{_libdir}/python*

%files octave
%defattr(-,root,root)
%{_prefix}/lib*/octave/*/site/oct/*/lal.oct*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Sep 26 2016 Adam Mercer <adam.mercer@lgio.org> 6.17.0-1
- ER10 Release

* Tue Jun 21 2016 Adam Mercer <adam.mercer@ligo.org> 6.16.1-1
- ER9 Release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 6.16.0-1
- Pre O2 packaging test release
