(* $Id: parser.ml,v 1.1.1.1 2002/02/25 07:49:29 garrigue Exp $ *)
open Str

exception Illegal_format

let prefix_regexp = regexp "^:\([^ \t]+\)[ \t]+\(.+\)$"
and prefix_loc = 1
and rest_loc = 2

let message_regexp = regexp "^\([A-Z]+\)\($\|[ \t]+\(.+\)$\)"
and message_id_loc = 1
and message_arg_loc = 3

let reply_regexp = regexp "^\([0-9][0-9][0-9]\)\($\|[ \t]+\(.+\)$\)"
and reply_id_loc = 1
and reply_arg_loc = 3

type m = 
    MSG of Message.message
  | REP of Reply.reply

let process_one_message s =
  let (prefix, np_s) = 
    if string_match prefix_regexp s 0
    then (Some (Prefix.parse_prefix (matched_group prefix_loc s)),
	  (matched_group rest_loc s))
    else (None, s)
  in
  if string_match message_regexp np_s 0
  then 
    begin
      let
	  id = Message.get_message_id (matched_group message_id_loc np_s)
      in
      MSG (prefix, 
	   id,
	   try Some (IrcArg.process_arg (matched_group message_arg_loc np_s))
	   with Not_found -> None)
    end
  else if string_match reply_regexp np_s 0
  then 
    begin
      let
	  id = int_of_string (matched_group reply_id_loc np_s)
      and arg = 
	try Some (IrcArg.process_arg 
		    (matched_group reply_arg_loc np_s))
	with Not_found -> None
      in
      REP 
      (match Reply.check_reply_type id with
	Reply.Type_connection ->
	  Reply.Connection (prefix, Reply.get_connection_reply id, arg)
      |	Reply.Type_command ->
	  Reply.Command (prefix, Reply.get_command_reply id, arg)
      |	Reply.Type_error ->
	  Reply.Error (prefix, Reply.get_error_reply id, arg))
    end
  else raise Illegal_format
