# regression tests for the sum utilitiy

KEEP "*.dat"

function DATA
{
	typeset f
	integer i
	typeset -i8 n
	for f
	do	test -f $f && continue
		case $f in
		aes.dat)for ((n = 0; n < 1024; n++))
			do	print -n "Rijndael is AES"
			done
			;;
		big.dat)for ((i = 0; i <= 10000; i++))
			do	print $i
			done
			;;
		chars.dat)
			typeset -i8 o
			for ((o = 0; o < 256; o++))
			do	print -f "\\${o#8#}"
			done
			;;
		gettysburg.dat)
			print -n $'Four score and seven years ago our fathers brought forth on this continent, a new nation, conceived in Liberty, and dedicated to the proposition that all men are created equal.  Now we are engaged in a great civil war, testing whether that nation, or any nation so conceived and so dedicated, can long endure. We are met on a great battlefield of that war.  We have come to dedicate a portion of that field, as a final resting place for those who here gave their lives that that nation might live.  It is altogether fitting and proper that we should do this.  But, in a larger sense, we can not dedicate--we can not consecrate--we can not hallow--this ground.  The brave men, living and dead, who struggled here, have consecrated it, far above our poor power to add or detract.  The world will little note, nor long remember what we say here, but it can never forget what they did here.  It is for us the living, rather, to be dedicated here to the unfinished work which they who fought here have thus far so nobly advanced.  It is rather for us to be here dedicated to the great task remaining before us--that from these honored dead we take increased devotion to that cause for which they gave the last full measure of devotion--that we here highly resolve that these dead shall not have died in vain--that this nation, under God, shall have a new birth of freedom--and that government of the people, by the people, for the people, shall not perish from the earth.  -- President Abraham Lincoln, November 19, 1863'
			;;
		qwerty.dat)
			for ((n = 0; n < 65536; n++))
			do	print -n "qwerty"
			done
			;;
		xyz.dat)print x
			print y
			print z
			;;
		zero.dat)
			for ((n = 0; n < 256; n++))
			do	print -f "\\0"
			done
			;;
		zyx.dat)print z
			print y
			print x
			;;
		z320.dat)
			uudecode <<'!'
begin-base64 644 -
F+9iHonPaaLeeKQGHgZZ6ArPxrLSBKkUSTJT4zG+eNLhBoo8XDxY5ctFWfGU
Ufn6AIlikCeDIVPcc0OAqPVG85Eo3AH9FUcAzD6LbT968t+tjE4beYAbbF1R
c+w8ZfMEub1TqU6OzNDo4vsDJOucQqQesOxW9zzNxb39QPkFQdr6bEnW8eh9
rOAAQwyj6Mlxlt9cn0Mfe+gEWRYByH0U0tJhvXevzeBwmvl7kjLC0ta2ETBB
+vbn/qqq3tg/XMYW89ZdvnoHdPpBrwpBdpkv1PpdLZjkuZ31vGjp3+07t59S
q1/VqCIFQql6SvXwCqIf1Tn7MeGgaebaQeQmuiZV5UV5KFdHzgzCjDlxGKLo
NyjUFKBWlBt92Ww7VoXZ7FCTUJe+6QMaPBzFgGUm/zJaaXnF55p7hrOz+OKc
Gxv4+rE=
====
!
			;;
		z447.dat)
			uudecode <<'!'
begin-base64 644 -
TX9HYkuiXIPTclYzZ64BRRhMuYzOUEV0aW6Hsus0KhAzypzlaLOJq4KpJoW7
WOMAHwbygF9hovxHRPBB5XPElZOWu6RbY+mV5DRmSJO3M3T2k0FjkEzZDI9h
SXIYMdlfA1hmAaZPvKbcqMoE45q6MY3ritnjUPh0X9sj0tDAL/lLnYysbiMI
Cr4z58Goez1eezzr4IVIiBkVI11kSxCp/X6lspk3XsXgxtOo3I0JdU0qNh+z
Llk77ZcbJjK+wNohWinHZpJ4hMkbdNPEcgCXQ4AVGW+JGg4B+YfCGXrO1K2J
KsLSHWRpcNagvLPYgHL5r/WU6KUlleoHJmy4wz0noKDxIK6UCVZqzgKeMZPu
HkIHRpYpJ3ZOACRR2TDxwp5a8Gp+6ExELkg7RtyrspOVRs6p98ddZseGVQ+Q
unt7QAze+bBixil1Ue5H1VhrjtbNrQJbzP1iC9IRJVtd4tDHPuyul4lqfpn9
76O5RhLJbDvvM4VochjLciZIaym2/C3z5t2gU7f5Deqrkc9fGRaL4aIPdJBi
7+5iPUAY6+J6iGMqae3aeIHnTvjLXuhxp9ZqiTW31Doo5R4SJyw11ZS0
====
!
			;;
		z640.dat)
			uudecode <<'!'
begin-base64 644 -
dZCieyp0KBCJqjGCkLcpZKcLCUEImBiLI+EDuGTkqeSXCMncPUwyaeY+02bt
AB3wRLQBlTNy8c6XTs/sA1ampCb532t5F0r+ZSe1cwmhWyn7lu0WLHC8i5vd
nSkSVdvy6AKeUaqqxdshn/D/H1G4pkSIzCx+azv3iDkpRC+wcy2vzkPJO0Lb
v3SZ3GGr/YCx9ap4FTh8b4utVFVLVjKndfnJXO3PRACz94OV1OL1nA9vBdty
wEGKlBBZtl/wO44xhgu94MWLf+wMH66HOzIq6UZqP/Q5EfzP6epwhxkq7gdT
vSPfY92DsDbkcU2OX+WRdl8Pth8tukDRq3VZR9geRaPuAN++ZIUj9iZKoef5
4G5niDSTHN1aIR3zTPUUffH4uF7a2VVz0bHSD9xb89Jxaueyc9tKgZmSuYtO
BJsyuOj2xsBz8DUpQq8eUojpmhcqMhd0FwMrU/xV7WBturKs4g69gKIbCHbV
t6q1OPQngdw97+p7vRp/4O1ft8Tvw0fZ20K5kvYD/DDDfAmpDuSdnYBTN57G
9eiml9+NQGQLXGwlzEGDiZgNNJsvUXyiV2B3XNzAF5cp5JYXMCdekNACaemr
+KXUHdtWQJalUS+SF3lEKorkwQWggMUvzoZr0XGwyjwEzPgkImPDwhrbUWi4
GmugGDjOj206W+R9pMy6cQIz5wIm/+1tI5sxvY7EjIQYKO2EJuUeZhU81pNb
RZPC3lR5ggp0DCUWUQCnw5E71Knz5Uh9YHR5wvyV9zeESBwRq1CANpqWijY4
paXg35kyo2VnZr7JBGZ/ckOP1JzVFbCeNbgdZcN4sjiAhyePhseEwMCn0+Yw
YX3bnOOpPhYJSQ==
====
!
			;;
		z1079.dat)	uudecode <<'!'
begin-base64 644 -
fKQY6bI1TmMvA9JVWp4mPcGTl34Gls9IUtaBnFthAxuoyuGUdVuUUqNswNNE
/icx3jkxfJrpDicaCMOho4Xe0hP+etUxgXSuP3AZzN7UPu0CEokEDX0A2eIr
0k2ROf9B1+jN4NcZhSJPDDIXKhXTX3BPFvpRxFwpyHrz0YfcxgAVNcQ6SJ20
TBet9xQ0QBhJT2c2jd4dm/58h1A0ObfsEYuV1IG8b4QRZiqvSQQnP9gzRkW4
tKmbWadgBAuNfw3JdUlC8Vgc6pUn3/O+EvNOzVZ0y7iyXI5ocdHTANTfkSG1
1bf8xRUdKb4qCtRow2Wyg6kVYZNwt9qpu8M8+YPV63y9cCs5KSUGcL9qFkDE
uPNxks3pFteFIsyHrn+cN6TwOm3Ep1xDo9fliGpqwzaYynVI8o40s0LbbsFs
HKUm1cfoYb0fQD2ynsKMdIZ1ZtiqDJuOKO5MsfzGwpyVfv97SjauuqviSXSo
JWNGMstLmcJlCXiXS/XcW8M+8KhIyu2u1kOqODvxP7GaDlXtExHXqH6s9zrK
2JBUaUZrv5buw8ZP4pjUvye5D5NB+U39GOg133VkG1k85/b2C1l/chy3MWO9
JZ2oUPnvYUE/omNRq1xUeqnh8h57HT4jeW/Xd4y4UHFHVIZmFsjKgRAVMhzC
Fykita+oH0Jlqk3OGAc2+uMnyh5HaU9TMzqiG4erT37W3jk/hGzuEOHTLJ0D
4aas8s8h9h6sdZp0VkOrYgQF7xOoHgLAUr5SDbjF6ixSLltY4SxLaDBT3AkJ
oogpQ0tOH9RIYEMcdjqHsjwpR/bTjeHlYlLOB0X/sEVOE/Lsnh4DKcGSChby
cCDqdIkzGVPSUbfnWNqBtJ0CTQRDmfW75I/0mCIKHsYTH3M9lIm9r9VuWe3h
A06GqLoBCKXRiIAbMLoELSwPSM6lryDcgr13ozYW9WJ1WBxqHQV35/uW85jS
VQXv0kOgCvYtA5cRyjiF3urEvjqUE6xxQJyVisyFkKSDEDl0aFclijPGX3gj
mYWBLv6/ibFW8fn4aRxcrguXc/HahL3c6XvOgPK5eG6cthTbKftWvJyPs+KX
uLatwF25qAEZafJECOPNkwnhkQaS1gHBJohBgpjDCLU07UGXxTRXixczPHT+
le+7dqG9Hc9cM42Q7d2o9hrnV8V3gEU1z2Cznql/kPaAZKz+vXQakEVKdcQ1
p4P6WzL3izdaqo7kTrGUTvzBZGVtvLr8InMkRLBb0bp9ihrCc1t2EIOubiWx
iJrYtD+XoodGaPoip6mfAvgTTQCFrSBwfrGFPalr7sIyk41x2bq5vDi4yI/7
BnC3Rmbn42uPZQjAS9kucQ2Al6qXzijLGk/IQ4kmSfpI+CaxlWs/xkgPYwgj
u7qfR96Pva556oNmvrN8y1gDsoS2Qn+Wz6G9P3YEeab/WhTqSI63TKg/Tfw=
====
!
			;;
		z2175.dat)
			uudecode <<'!'
begin-base64 644 -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====
!
			;;
		z16384.dat)
			uudecode <<'!'
begin-base64 644 -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====
!
			;;
		z12271.dat)
			uudecode <<'!'
begin-base64 644 -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====
!
			;;
		esac > $f
	done
}

TEST 01 'old att algorithm'
	DO	DATA big.dat chars.dat xyz.dat zyx.dat zero.dat
	EXEC	--method=att
		OUTPUT - $'0 0'
	EXEC	--method=att /dev/null
		OUTPUT - $'0 0 /dev/null'
	EXEC	--method=att xyz.dat zyx.dat
		OUTPUT - $'393 1 xyz.dat\n393 1 zyx.dat'
	EXEC	--method=att --total xyz.dat zyx.dat
		OUTPUT - $'0 1 2'
	EXEC	--method=att --total xyz.dat chars.dat
		OUTPUT - $'32265 1 2'
	EXEC	--method=att big.dat
		OUTPUT - $'49851 96 big.dat'
	EXEC	--method=att chars.dat
		OUTPUT - $'32640 1 chars.dat'
	EXEC	--method=att zero.dat
		OUTPUT - $'0 1 zero.dat'

TEST 02 'old bsd algorithm'
	DO	DATA big.dat chars.dat xyz.dat zyx.dat zero.dat
	EXEC	--method=bsd
		OUTPUT - $'0 0'
	EXEC	--method=bsd /dev/null
		OUTPUT - $'0 0 /dev/null'
	EXEC	--method=bsd xyz.dat zyx.dat
		OUTPUT - $'93 1 xyz.dat\n4188 1 zyx.dat'
	EXEC	--method=bsd --total xyz.dat zyx.dat
		OUTPUT - $'4097 1 2'
	EXEC	--method=bsd --total xyz.dat chars.dat
		OUTPUT - $'605 1 2'
	EXEC	--method=bsd big.dat
		OUTPUT - $'50647 48 big.dat'
	EXEC	--method=bsd chars.dat
		OUTPUT - $'512 1 chars.dat'
	EXEC	--method=bsd zero.dat
		OUTPUT - $'0 1 zero.dat'

TEST 03 'ast memsum algorithm'
	DO	DATA big.dat chars.dat xyz.dat zyx.dat zero.dat
	EXEC	--method=ast
		OUTPUT - $'0 0'
	EXEC	--method=ast /dev/null
		OUTPUT - $'0 0 /dev/null'
	EXEC	--method=ast xyz.dat zyx.dat
		OUTPUT - $'333665879 6 xyz.dat\n844468759 6 zyx.dat'
	EXEC	--method=ast --total xyz.dat zyx.dat
		OUTPUT - $'565625920 12 2'
	EXEC	--method=ast big.dat
		OUTPUT - $'2944469051 48896 big.dat'
	EXEC	--method=ast chars.dat
		OUTPUT - $'2634217600 256 chars.dat'
	EXEC	--method=ast zero.dat
		OUTPUT - $'2971255040 256 zero.dat'

TEST 04 'zip crc algorithm'
	DO	DATA big.dat chars.dat xyz.dat zyx.dat zero.dat
	EXEC	--method=zip
		OUTPUT - $'0 0'
	EXEC	--method=zip /dev/null
		OUTPUT - $'0 0 /dev/null'
	EXEC	--method=zip xyz.dat zyx.dat
		OUTPUT - $'849749004 6 xyz.dat\n1297672069 6 zyx.dat'
	EXEC	--method=zip --total xyz.dat zyx.dat
		OUTPUT - $'2147402633 12 2'
	EXEC	--method=zip big.dat
		OUTPUT - $'3652343079 48896 big.dat'
	EXEC	--method=zip chars.dat
		OUTPUT - $'688229491 256 chars.dat'
	EXEC	--method=zip zero.dat
		OUTPUT - $'227968344 256 zero.dat'

TEST 05 'posix cksum algorithm'
	DO	DATA big.dat chars.dat xyz.dat zyx.dat zero.dat
	EXEC	--method=cksum
		OUTPUT - $'4294967295 0'
	EXEC	--method=cksum /dev/null
		OUTPUT - $'4294967295 0 /dev/null'
	EXEC	--method=cksum xyz.dat zyx.dat
		OUTPUT - $'2140995855 6 xyz.dat\n3800205347 6 zyx.dat'
	EXEC	--method=cksum --total xyz.dat zyx.dat
		OUTPUT - $'2636089644 12 2'
	EXEC	--method=cksum big.dat
		OUTPUT - $'528457989 48896 big.dat'
	EXEC	--method=cksum chars.dat
		OUTPUT - $'1313719201 256 chars.dat'
	EXEC	--method=cksum zero.dat
		OUTPUT - $'4215202376 256 zero.dat'

TEST 06 'md5 message digest algorithm'
	DO	DATA big.dat chars.dat xyz.dat zyx.dat zero.dat
	EXEC	--method=md5
		INPUT -
		OUTPUT - $'d41d8cd98f00b204e9800998ecf8427e'
	EXEC	--method=md5 /dev/null
		OUTPUT - $'d41d8cd98f00b204e9800998ecf8427e */dev/null'
	EXEC	--method=md5 xyz.dat zyx.dat
		OUTPUT - $'5c37d4d5cc8d74de8ed81fc394a56c0e *xyz.dat\n30c4d234a30ae1665d3e63cbfac9ade9 *zyx.dat'
	EXEC	--method=md5 --total xyz.dat zyx.dat
		OUTPUT - $'6cf306e16f8795b8d3e67c086e6cc1e7'
	EXEC	--method=md5 big.dat
		OUTPUT - $'4633277f9842941660fbd0a681b1e656 *big.dat'
	EXEC	--method=md5 chars.dat
		OUTPUT - $'e2c865db4162bed963bfaa9ef6ac18f0 *chars.dat'
	EXEC	--method=md5 zero.dat
		OUTPUT - $'348a9791dc41b89796ec3808b5b5262f *zero.dat'

TEST 07 'text vs binary mode'
	EXEC	--method=posix
		INPUT -n - $'\r'
		OUTPUT - $'3863691631 1'
	EXEC	--method=posix --text
	EXEC	--method=posix
		INPUT -n - $'\n'
		OUTPUT - $'3515105045 1'
	EXEC	--method=posix --text
	EXEC	--method=posix --text
		INPUT -n - $'\r\n'
	EXEC	--method=posix
		OUTPUT - $'3568853871 2'
	EXEC	--method=posix
		INPUT -n - $'\r\r\n'
		OUTPUT - $'2299211872 3'
	EXEC	--method=posix --text
		OUTPUT - $'3568853871 2'
	EXEC	--method=posix
		INPUT -n - $'\n\n'
		OUTPUT - $'3518178554 2'
	EXEC	--method=posix --text
		INPUT -n - $'\r\n\r\n'

TEST 08 'SHA-1 secure hash algorithm 1'
	DO	DATA big.dat chars.dat xyz.dat zyx.dat zero.dat
	EXEC	--method=sha1
		INPUT -
		OUTPUT - $'da39a3ee5e6b4b0d3255bfef95601890afd80709'
	EXEC	--method=sha1 /dev/null
		OUTPUT - $'da39a3ee5e6b4b0d3255bfef95601890afd80709 */dev/null'
	EXEC	--method=sha1 xyz.dat zyx.dat
		OUTPUT - $'83305e292107a8d1955ac0c0047912ff62c5d6dc *xyz.dat\nf1bac0f6f8e8d09b07cbc04c2e70b1b606fb9dd5 *zyx.dat'
	EXEC	--method=sha1 --total xyz.dat zyx.dat
		OUTPUT - $'728a9edfd9ef784a9291008c2a09a349643e4b09'
	EXEC	--method=sha1 big.dat
		OUTPUT - $'d3e7a9584187f017342dd759bc8f3061b74c5faf *big.dat'
	EXEC	--method=sha1 chars.dat
		OUTPUT - $'4916d6bdb7f78e6803698cab32d1586ea457dfc8 *chars.dat'
	EXEC	--method=sha1 zero.dat
		OUTPUT - $'b376885ac8452b6cbf9ced81b1080bfd570d9b91 *zero.dat'
	EXEC	--method=sha1
		INPUT -n - $'abc'
		OUTPUT - $'a9993e364706816aba3e25717850c26c9cd0d89d'
	EXEC	--method=sha1
		INPUT -n - $'abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq'
		OUTPUT - $'84983e441c3bd26ebaae4aa1f95129e5e54670f1'

TEST 09 'SHA-256 secure hash algorithm'
	DO	DATA aes.dat big.dat chars.dat gettysburg.dat qwerty.dat r1.dat r2.dat xyz.dat zyx.dat zero.dat z320.dat z447.dat z640.dat z1079.dat z2175.dat z12271.dat z16384.dat

	EXEC	--method=SHA-256
		INPUT -
		OUTPUT - $'e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855'
	EXEC	--method=SHA-256 /dev/null
		OUTPUT - $'e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855 */dev/null'
	EXEC	--method=SHA-256 xyz.dat zyx.dat
		OUTPUT - $'81884b5f2cb68edc6286363dcc4699a913a2d5ba05818d0fdc43ba68bb990bd8 *xyz.dat\n9c49771c064bd4fd1e0118f38fcf88c519c38370bcddcf7444fe6593f74005de *zyx.dat'
	EXEC	--method=SHA-256 --total xyz.dat zyx.dat
		OUTPUT - $'1dc13c432afd5a217c872ece4389116c0a6156cab95c427b98bddffb4cd90e06'
	EXEC	--method=SHA-256 big.dat
		OUTPUT - $'6cdce0d273f964e529fc3f90db732abb5c70b63a3a43151a2498bb41a23f2dff *big.dat'
	EXEC	--method=SHA-256 chars.dat
		OUTPUT - $'40aff2e9d2d8922e47afd4648e6967497158785fbd1da870e7110266bf944880 *chars.dat'
	EXEC	--method=SHA-256 zero.dat
		OUTPUT - $'5341e6b2646979a70e57653007a1f310169421ec9bdd9f1a5648f75ade005af1 *zero.dat'
	EXEC	--method=SHA-256
		INPUT -n - $'abc'
		OUTPUT - $'ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad'
	EXEC	--method=SHA-256
		INPUT -n - $'abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq'
		OUTPUT - $'248d6a61d20638b8e5c026930c3e6039a33ce45964ff2167f6ecedd419db06c1'
	EXEC	--method=SHA-256
		INPUT -n - $'abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu'
		OUTPUT - $'cf5b16a778af8380036ce59e7b0492370b249b11e8f07a51afac45037afee9d1'
	EXEC	--method=SHA-256 gettysburg.dat
		OUTPUT - $'4d25fccf8752ce470a58cd21d90939b7eb25f3fa418dd2da4c38288ea561e600 *gettysburg.dat'
	EXEC	--method=SHA-256
		INPUT -n - $'This is exactly 64 bytes long, not counting the terminating byte'
		OUTPUT - $'ab64eff7e88e2e46165e29f2bce41826bd4c7b3552f6b382a9e7d3af47c245f8'
	EXEC	--method=SHA-256
		INPUT -n - $'For this sample, this 63-byte string will be used as input data'
		OUTPUT - $'f08a78cbbaee082b052ae0708f32fa1e50c5c421aa772ba5dbb406a2ea6be342'
	EXEC	--method=SHA-256
		INPUT -n - $'And this textual data, astonishing as it may appear, is exactly 128 bytes in length, as are both SHA-384 and SHA-512 block sizes'
		OUTPUT - $'0ab803344830f92089494fb635ad00d76164ad6e57012b237722df0d7ad26896'
	EXEC	--method=SHA-256
		INPUT -n - $'By hashing data that is one byte less than a multiple of a hash block length (like this 127-byte string), bugs may be revealed.'
		OUTPUT - $'e4326d0459653d7d3514674d713e74dc3df11ed4d30b4013fd327fdb9e394c26'
	EXEC	--method=SHA-256 z320.dat
		OUTPUT - $'a7f001d996dd25af402d03b5f61aef950565949c1a6ad5004efa730328d2dbf3 *z320.dat'
	EXEC	--method=SHA-256 z447.dat
		OUTPUT - $'6dcd63a07b0922cc3a9b3315b158478681cc32543b0a4180abe58a73c5e14cc2 *z447.dat'
	EXEC	--method=SHA-256 z640.dat
		OUTPUT - $'af6ebfde7d93d5badb6cde6287ecc2061c1cafc5b1c1217cd984fbcdb9c61aaa *z640.dat'
	EXEC	--method=SHA-256 z2175.dat
		OUTPUT - $'8ff59c6d33c5a991088bc44dd38f037eb5ad5630c91071a221ad6943e872ac29 *z2175.dat'
	EXEC	--method=SHA-256 z16384.dat
		OUTPUT - $'1818e87564e0c50974ecaabbb2eb4ca2f6cc820234b51861e2590be625f1f703 *z16384.dat'
	EXEC	--method=SHA-256 qwerty.dat
		OUTPUT - $'5e3dfe0cc98fd1c2de2a9d2fd893446da43d290f2512200c515416313cdf3192 *qwerty.dat'
	EXEC	--method=SHA-256 aes.dat
		OUTPUT - $'80fced5a97176a5009207cd119551b42c5b51ceb445230d02ecc2663bbfb483a *aes.dat'
	EXEC	--method=SHA-256 z12271.dat
		OUTPUT - $'88ee6ada861083094f4c64b373657e178d88ef0a4674fce6e4e1d84e3b176afb *z12271.dat'
	EXEC	--method=SHA-256 z1079.dat
		OUTPUT - $'5a2e925a7f8399fa63a20a1524ae83a7e3c48452f9af4df493c8c51311b04520 *z1079.dat'

TEST 10 'SHA-384 secure hash algorithm'
	DO	DATA aes.dat big.dat chars.dat gettysburg.dat qwerty.dat r1.dat r2.dat xyz.dat zyx.dat zero.dat z320.dat z447.dat z640.dat z1079.dat z2175.dat z12271.dat z16384.dat

	EXEC	--method=SHA-384
		INPUT -
		OUTPUT - $'38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e1da274edebfe76f65fbd51ad2f14898b95b'
	EXEC	--method=SHA-384 /dev/null
		OUTPUT - $'38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e1da274edebfe76f65fbd51ad2f14898b95b */dev/null'
	EXEC	--method=SHA-384 xyz.dat zyx.dat
		OUTPUT - $'69ee1ce2ab4336efe6ef44c42b88d54978b0d8e15f5745a3e4c2a636c51b2e7cd27f14c9a99a56a695c63f05b01f8807 *xyz.dat\n2a2a803235971c4bd86019e2370c77a16a7461ab44cef3fa374bc5720836ba46834192dc1e9557f926dee3d70f9f39fb *zyx.dat'
	EXEC	--method=SHA-384 --total xyz.dat zyx.dat
		OUTPUT - $'43c49cd09ed42aa43e8f5d261c84a2e812c4b94a1b99b659d3896344cd2d943a513e8615b70f015fb318dcd2bf80b1fc'
	EXEC	--method=SHA-384 big.dat
		OUTPUT - $'0a5aa14305020b93c982af350fba28dfbbe9ffe1e8691a179de30d899a24a9314fbe50eeb527ec379aaadc94c8f5bff6 *big.dat'
	EXEC	--method=SHA-384 chars.dat
		OUTPUT - $'ffdaebff65ed05cf400f0221c4ccfb4b2104fb6a51f87e40be6c4309386bfdec2892e9179b34632331a59592737db5c5 *chars.dat'
	EXEC	--method=SHA-384 zero.dat
		OUTPUT - $'983980373213482dd5c9a5a424db89418e3344c459fa31a356e42eaa28544ca01b9839f6593c9e5d79fd439b5da6ebef *zero.dat'
	EXEC	--method=SHA-384
		INPUT -n - $'abc'
		OUTPUT - $'cb00753f45a35e8bb5a03d699ac65007272c32ab0eded1631a8b605a43ff5bed8086072ba1e7cc2358baeca134c825a7'
	EXEC	--method=SHA-384
		INPUT -n - $'abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq'
		OUTPUT - $'3391fdddfc8dc7393707a65b1b4709397cf8b1d162af05abfe8f450de5f36bc6b0455a8520bc4e6f5fe95b1fe3c8452b'
	EXEC	--method=SHA-384
		INPUT -n - $'abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu'
		OUTPUT - $'09330c33f71147e83d192fc782cd1b4753111b173b3b05d22fa08086e3b0f712fcc7c71a557e2db966c3e9fa91746039'
	EXEC	--method=SHA-384 gettysburg.dat
		OUTPUT - $'69cc75b95280bdd9e154e743903e37b1205aa382e92e051b1f48a6db9d0203f8a17c1762d46887037275606932d3381e *gettysburg.dat'
	EXEC	--method=SHA-384
		INPUT -n - $'This is exactly 64 bytes long, not counting the terminating byte'
		OUTPUT - $'e28e35e25a1874908bf0958bb088b69f3d742a753c86993e9f4b1c4c21988f958bd1fe0315b195aca7b061213ac2a9bd'
	EXEC	--method=SHA-384
		INPUT -n - $'For this sample, this 63-byte string will be used as input data'
		OUTPUT - $'37b49ef3d08de53e9bd018b0630067bd43d09c427d06b05812f48531bce7d2a698ee2d1ed1ffed46fd4c3b9f38a8a557'
	EXEC	--method=SHA-384
		INPUT -n - $'And this textual data, astonishing as it may appear, is exactly 128 bytes in length, as are both SHA-384 and SHA-512 block sizes'
		OUTPUT - $'e3e3602f4d90c935321d788f722071a8809f4f09366f2825cd85da97ccd2955eb6b8245974402aa64789ed45293e94ba'
	EXEC	--method=SHA-384
		INPUT -n - $'By hashing data that is one byte less than a multiple of a hash block length (like this 127-byte string), bugs may be revealed.'
		OUTPUT - $'1ca650f38480fa9dfb5729636bec4a935ebc1cd4c0055ee50cad2aa627e066871044fd8e6fdb80edf10b85df15ba7aab'
	EXEC	--method=SHA-384 z320.dat
		OUTPUT - $'b8261ddcd7df7b3969a516b72550de6fbf0e394a4a7bb2bbc60ec603c2ceff643c5bf62bc6dcbfa5beb54b62d750b969 *z320.dat'
	EXEC	--method=SHA-384 z447.dat
		OUTPUT - $'548e4e9a1ff57f469ed47b023bf5279dfb4d4ca08c65051e3a5c41fab84479a205496276906008b4b3c5b0970b2f5446 *z447.dat'
	EXEC	--method=SHA-384 z640.dat
		OUTPUT - $'c6fec3a3278dd6b5afc8c0971d32d38faf5802f1a21527c32563b32a1ac340656b433b44fe2648aa2232206f4301193a *z640.dat'
	EXEC	--method=SHA-384 z2175.dat
		OUTPUT - $'92dca5655229b3c34796a227ff1809e273499adc2830149481224e0f54ff4483bd49834d4865e508ef53d4cd22b703ce *z2175.dat'
	EXEC	--method=SHA-384 z16384.dat
		OUTPUT - $'310fbb2027bdb7042f0e09e7b092e9ada506649510a7aa029825c8e8019e9c30749d723f2de1bd8c043d8d89d3748c2f *z16384.dat'
	EXEC	--method=SHA-384 qwerty.dat
		OUTPUT - $'0d5e45317bc7997cb9c8a23bad9bac9170d5bc81789b51af6bcd74ace379fd649a2b48cb56c4cb4ec1477e6933329e0e *qwerty.dat'
	EXEC	--method=SHA-384 aes.dat
		OUTPUT - $'aa1e77c094e5ce6db81a1add4c095201d020b7f8885a4333218da3b799b9fc42f00d60cd438a1724ae03bd7b515b739b *aes.dat'
	EXEC	--method=SHA-384 z12271.dat
		OUTPUT - $'78cc6402a29eb984b8f8f888ab0102cabe7c06f0b9570e3d8d744c969db14397f58ecd14e70f324bf12d8dd4cd1ad3b2 *z12271.dat'
	EXEC	--method=SHA-384 z1079.dat
		OUTPUT - $'72ec26cc742bc5fb1ef82541c9cadcf01a15c8104650d305f24ec8b006d7428e8ebe2bb320a465dbdd5c6326bbd8c9ad *z1079.dat'

TEST 11 'SHA-512 secure hash algorithm'
	DO	DATA aes.dat big.dat chars.dat gettysburg.dat qwerty.dat r1.dat r2.dat xyz.dat zyx.dat zero.dat z320.dat z447.dat z640.dat z1079.dat z2175.dat z12271.dat z16384.dat

	EXEC	--method=SHA-512
		INPUT -
		OUTPUT - $'cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'
	EXEC	--method=SHA-512 /dev/null
		OUTPUT - $'cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e */dev/null'
	EXEC	--method=SHA-512 xyz.dat zyx.dat
		OUTPUT - $'bd4f98333e7adec90b6e3e292f7a6386a509b443dbb374fb705b9354552b4d438fc31023b5b853f0a88e670c89392b05044f4b9b4dea3593fc871c82afe65891 *xyz.dat\n25bd08f694f4ac12441f2e526e017556ca6f22ddf38cbe0519f24381697ebcaa9a44002fe759677d7271a24342359329a9a626444d7cfed9128e76bfbea95782 *zyx.dat'
	EXEC	--method=SHA-512 --total xyz.dat zyx.dat
		OUTPUT - $'98f290c5aa8e72db4f71107b417b16d06f66969e283fcafe69a9d0d53c55f1e91587100c52e1348ddaffc54fcb0cb82cade96ddf0096cb4aee096a3d114f0f13'
	EXEC	--method=SHA-512 big.dat
		OUTPUT - $'8dad61d786372cb82cdc1440a8e52062f2ce322d865eb6aca388a90c327e16297b5c041d8316cee2b36123c4b6c7eb0a7d8c483ddc92fcb1c7bfc5093630198f *big.dat'
	EXEC	--method=SHA-512 chars.dat
		OUTPUT - $'1e7b80bc8edc552c8feeb2780e111477e5bc70465fac1a77b29b35980c3f0ce4a036a6c9462036824bd56801e62af7e9feba5c22ed8a5af877bf7de117dcac6d *chars.dat'
	EXEC	--method=SHA-512 zero.dat
		OUTPUT - $'693f95d58383a6162d2aab49eb60395dcc4bb22295120caf3f21e3039003230b287c566a03c7a0ca5accaed2133c700b1cb3f82edf8adcbddc92b4f9fb9910c6 *zero.dat'
	EXEC	--method=SHA-512
		INPUT -n - $'abc'
		OUTPUT - $'ddaf35a193617abacc417349ae20413112e6fa4e89a97ea20a9eeee64b55d39a2192992a274fc1a836ba3c23a3feebbd454d4423643ce80e2a9ac94fa54ca49f'
	EXEC	--method=SHA-512
		INPUT -n - $'abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq'
		OUTPUT - $'204a8fc6dda82f0a0ced7beb8e08a41657c16ef468b228a8279be331a703c33596fd15c13b1b07f9aa1d3bea57789ca031ad85c7a71dd70354ec631238ca3445'
	EXEC	--method=SHA-512
		INPUT -n - $'abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu'
		OUTPUT - $'8e959b75dae313da8cf4f72814fc143f8f7779c6eb9f7fa17299aeadb6889018501d289e4900f7e4331b99dec4b5433ac7d329eeb6dd26545e96e55b874be909'
	EXEC	--method=SHA-512 gettysburg.dat
		OUTPUT - $'23450737795d2f6a13aa61adcca0df5eef6df8d8db2b42cd2ca8f783734217a73e9cabc3c9b8a8602f8aeaeb34562b6b1286846060f9809b90286b3555751f09 *gettysburg.dat'
	EXEC	--method=SHA-512
		INPUT -n - $'This is exactly 64 bytes long, not counting the terminating byte'
		OUTPUT - $'70aefeaa0e7ac4f8fe17532d7185a289bee3b428d950c14fa8b713ca09814a387d245870e007a80ad97c369d193e41701aa07f3221d15f0e65a1ff970cedf030'
	EXEC	--method=SHA-512
		INPUT -n - $'For this sample, this 63-byte string will be used as input data'
		OUTPUT - $'b3de4afbc516d2478fe9b518d063bda6c8dd65fc38402dd81d1eb7364e72fb6e6663cf6d2771c8f5a6da09601712fb3d2a36c6ffea3e28b0818b05b0a8660766'
	EXEC	--method=SHA-512
		INPUT -n - $'And this textual data, astonishing as it may appear, is exactly 128 bytes in length, as are both SHA-512 and SHA-512 block sizes'
		OUTPUT - $'faf543e1b3082b2ec9a5233510bfc2a88ca227a326d0b91ff7a333b5b731db51e8f147bb8fbde237706b26d838d8cf683896000363a7c94decad8484cacfa0a5'
	EXEC	--method=SHA-512
		INPUT -n - $'By hashing data that is one byte less than a multiple of a hash block length (like this 127-byte string), bugs may be revealed.'
		OUTPUT - $'d399507bbf5f2d0da51db1ff1fc51c1c9ff1de0937e00d01693b240e84fcc3400601429f45c297acc6e8fcf1e4e4abe9ff21a54a0d3d88888f298971bd206cd5'
	EXEC	--method=SHA-512 z320.dat
		OUTPUT - $'caf970d3638e21053173a638c4b94d6d1ff87bc47b58f8ee928fbe9e245c23abf81019e45bf017ecc8610e5e0b95e3b025ccd611a772ca4fb3dfba26f0859725 *z320.dat'
	EXEC	--method=SHA-512 z447.dat
		OUTPUT - $'ee5d07460183b130687c977e9f8d43110989b0864b18fe6ee00a53dec5eda111f3aaa3bac7ab8dae26ed545a4de33ed45190f18fa0c327c44642ab9424265330 *z447.dat'
	EXEC	--method=SHA-512 z640.dat
		OUTPUT - $'73ffeb67716c3495fbc33f2d62fe08e2616706a5599881c7e67e9ef2b68f4988ea8b3b604ba87e50b07962692705c420fa31a00be41d6aaa9f3b11eafe9cf49b *z640.dat'
	EXEC	--method=SHA-512 z2175.dat
		OUTPUT - $'0e928db6207282bfb498ee871202f2337f4074f3a1f5055a24f08e912ac118f8101832cdb9c2f702976e629183db9bacfdd7b086c800687c3599f15de7f7b9dd *z2175.dat'
	EXEC	--method=SHA-512 z16384.dat
		OUTPUT - $'a001636f3ff1ce34f432f8e8f7785b78be84318beb8485a406650a8b243c419f7db6435cf6bf3000c6524adb5b52bad01afb76b3ceff701331e18b85b0e4cbd3 *z16384.dat'
	EXEC	--method=SHA-512 qwerty.dat
		OUTPUT - $'735bd6bebfe6f8070d70069105bc761f35ed1ac3742f2e372fdc14d2a51898e6153ccaff9073324130abdc451c730dc5dab5a0452487b1171c4dd97f92e267b7 *qwerty.dat'
	EXEC	--method=SHA-512 aes.dat
		OUTPUT - $'fae25ec70bcb3bbdef9698b9d579da49db68318dbdf18c021d1f76aaceff962838873235597e7cce0c68aabc610e0deb79b13a01c302abc108e459ddfbe9bee8 *aes.dat'
	EXEC	--method=SHA-512 z12271.dat
		OUTPUT - $'211bec83fbca249c53668802b857a9889428dc5120f34b3eac1603f13d1b47965c387b39ef6af15b3a44c5e7b6bbb6c1096a677dc98fc8f472737540a332f378 *z12271.dat'
	EXEC	--method=SHA-512 z1079.dat
		OUTPUT - $'ebad464e6d9f1df7e8aadff69f52db40a001b253fbf65a018f29974dcc7fbf8e58b69e247975fbadb4153d7289357c9b6212752d0ab67dd3d9bbc0bb908aa98c *z1079.dat'

TEST 12 'tw 32x4 memsum algorithm'
	DO	DATA big.dat chars.dat xyz.dat zyx.dat zero.dat
	EXEC	--method=tw
		OUTPUT - $'000000000000000000000000'
	EXEC	--method=tw /dev/null
		OUTPUT - $'000000000000000000000000 /dev/null'
	EXEC	--method=tw xyz.dat zyx.dat
		OUTPUT - $'0jURpn1vP@As2kmq0L2YHh5b xyz.dat\n0Olp8n1@3o7s08fz3L1QPghH zyx.dat'
	EXEC	--method=tw --total xyz.dat zyx.dat
		OUTPUT - $'0jURpn1vP@As2kmq0L2YHh5b'
	EXEC	--method=tw big.dat
		OUTPUT - $'2LwgwX1jngxw3f8M@X3jys8b big.dat'
	EXEC	--method=tw chars.dat
		OUTPUT - $'2t0Ly00mL@E01UvwO01fOoO0 chars.dat'
	EXEC	--method=tw zero.dat
		OUTPUT - $'2N6s402zI@800vNTk01gUZQ0 zero.dat'

TEST 13 'solaris -r algorithm'
	DO	DATA big.dat chars.dat xyz.dat zyx.dat zero.dat
	EXEC	-r
		OUTPUT - $'00000      0'
	EXEC	-r /dev/null
		OUTPUT - $'00000      0 /dev/null'
	EXEC	-r xyz.dat zyx.dat
		OUTPUT - $'00093      1 xyz.dat\n04188      1 zyx.dat'
	EXEC	-r --total xyz.dat zyx.dat
		OUTPUT - $'04097      1      2'
	EXEC	-r big.dat
		OUTPUT - $'50647     96 big.dat'
	EXEC	-r chars.dat
		OUTPUT - $'00512      1 chars.dat'
	EXEC	-r zero.dat
		OUTPUT - $'00000      1 zero.dat'
