/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.PartialFunction;
import io.vavr.collection.Traversable;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Seq<T>
extends PartialFunction<Integer, T>,
Traversable<T>,
Serializable {
    public static final long serialVersionUID = 1L;

    public Seq<T> append(T var1);

    public Seq<T> appendAll(Iterable<? extends T> var1);

    @Override
    @Deprecated
    default public T apply(Integer index) {
        return this.get(index);
    }

    public T get(int var1);

    default public int indexOf(T element) {
        return this.indexOf(element, 0);
    }

    public int indexOf(T var1, int var2);

    public Seq<T> insert(int var1, T var2);

    public Seq<T> insertAll(int var1, Iterable<? extends T> var2);

    default public int lastIndexOf(T element) {
        return this.lastIndexOf(element, Integer.MAX_VALUE);
    }

    public int lastIndexOf(T var1, int var2);

    public Seq<T> remove(T var1);

    public Seq<T> removeAll(Iterable<? extends T> var1);

    public Seq<T> removeAt(int var1);

    public Seq<T> reverse();

    public Seq<T> sorted(Comparator<? super T> var1);

    public Seq<T> subSequence(int var1, int var2);

    public Seq<T> update(int var1, T var2);

    @Override
    public Seq<T> filter(Predicate<? super T> var1);

    default public <U> U foldRight(U zero, BiFunction<? super T, ? super U, ? extends U> f2) {
        Objects.requireNonNull(f2, "f is null");
        return (U)this.reverse().foldLeft(zero, (xs, x2) -> f2.apply(x2, xs));
    }

    public <U> Seq<U> map(Function<? super T, ? extends U> var1);

    public Seq<T> retainAll(Iterable<? extends T> var1);

    @Override
    public Seq<T> tail();

    public Seq<T> take(int var1);

    @Override
    default public boolean isSequential() {
        return true;
    }
}

