/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.parser.sourcemaps.JSONKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonSyntaxException;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapGroup;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSegment;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSourceReplacementException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0002\u0010\u001cR\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap;", "", "sourceContentResolver", "Lkotlin/Function1;", "", "Ljava/io/Reader;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getSourceContentResolver", "()Lkotlin/jvm/functions/Function1;", "groups", "", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapGroup;", "getGroups", "()Ljava/util/List;", "debugToString", "debug", "", "writer", "Ljava/io/PrintStream;", "debugVerbose", "generatedJsFile", "Ljava/io/File;", "segmentForGeneratedLocation", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapSegment;", "lineNumber", "", "columnNumber", "(ILjava/lang/Integer;)Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapSegment;", "Companion", "js.parser"})
@SourceDebugExtension(value={"SMAP\nSourceMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMap.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1#2:133\n37#3:134\n36#3,3:135\n1563#4:138\n1634#4,3:139\n360#4,7:142\n*S KotlinDebug\n*F\n+ 1 SourceMap.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap\n*L\n40#1:134\n40#1:135,3\n44#1:138\n44#1:139,3\n61#1:142,7\n*E\n"})
public final class SourceMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, Reader> sourceContentResolver;
    @NotNull
    private final List<SourceMapGroup> groups;

    public SourceMap(@NotNull Function1<? super String, ? extends Reader> sourceContentResolver) {
        Intrinsics.checkNotNullParameter(sourceContentResolver, "sourceContentResolver");
        this.sourceContentResolver = sourceContentResolver;
        this.groups = new ArrayList();
    }

    @NotNull
    public final Function1<String, Reader> getSourceContentResolver() {
        return this.sourceContentResolver;
    }

    @NotNull
    public final List<SourceMapGroup> getGroups() {
        return this.groups;
    }

    @NotNull
    public final String debugToString() {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream it = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        this.debug(new PrintStream(it));
        String string2 = byteArrayOutputStream.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    public final void debug(@NotNull PrintStream writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        Iterator iterator2 = ((Iterable)this.groups).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            SourceMapGroup group = (SourceMapGroup)iterator2.next();
            writer.print("" + (index + 1) + ':');
            for (SourceMapSegment segment : group.getSegments()) {
                String nameIfPresent = segment.getName() != null ? '(' + segment.getName() + ')' : "";
                writer.print("" + ' ' + (segment.getGeneratedColumnNumber() + 1) + ':' + (segment.getSourceLineNumber() + 1) + ',' + (segment.getSourceColumnNumber() + 1) + nameIfPresent);
            }
            writer.println();
        }
    }

    public static /* synthetic */ void debug$default(SourceMap sourceMap, PrintStream printStream, int n, Object object) {
        if ((n & 1) != 0) {
            printStream = System.out;
        }
        sourceMap.debug(printStream);
    }

    /*
     * WARNING - void declaration
     */
    public final void debugVerbose(@NotNull PrintStream writer, @NotNull File generatedJsFile) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        Intrinsics.checkNotNullParameter(generatedJsFile, "generatedJsFile");
        boolean bl = generatedJsFile.exists();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-SourceMap$debugVerbose$22 = false;
            String $i$a$-assert-SourceMap$debugVerbose$22 = generatedJsFile + " does not exist!";
            throw new AssertionError((Object)$i$a$-assert-SourceMap$debugVerbose$22);
        }
        Collection $this$toTypedArray$iv = FilesKt.readLines$default(generatedJsFile, null, 1, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] generatedLines = thisCollection$iv.toArray(new String[0]);
        Iterator iterator2 = ((Iterable)this.groups).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            int index = n++;
            SourceMapGroup group = (SourceMapGroup)iterator2.next();
            writer.print("" + (index + 1) + ':');
            String generatedLine = generatedLines[index];
            Iterable $this$map$iv = group.getSegments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SourceMapSegment sourceMapSegment = (SourceMapSegment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(TuplesKt.to(it.getGeneratedColumnNumber(), it));
            }
            Map segmentsByColumn = MapsKt.toMap((List)destination$iv$iv);
            int n2 = ((CharSequence)generatedLine).length();
            for (int i = 0; i < n2; ++i) {
                if ((SourceMapSegment)segmentsByColumn.get(i) != null) {
                    SourceMapSegment sourceMapSegment;
                    boolean bl3 = false;
                    String sourceFile = sourceMapSegment.component2();
                    int sourceLine = sourceMapSegment.component3();
                    int sourceColumn = sourceMapSegment.component4();
                    String name2 = sourceMapSegment.component5();
                    String nameIfPresent = name2 != null ? '(' + name2 + ')' : "";
                    writer.print('<' + sourceFile + ':' + (sourceLine + 1) + ':' + (sourceColumn + 1) + nameIfPresent + '>');
                }
                writer.print(generatedLine.charAt(i));
            }
            writer.println();
        }
    }

    @Nullable
    public final SourceMapSegment segmentForGeneratedLocation(int lineNumber, @Nullable Integer columnNumber) {
        SourceMapSegment sourceMapSegment;
        SourceMapGroup sourceMapGroup;
        block10: {
            block9: {
                SourceMapGroup sourceMapGroup2;
                sourceMapGroup = CollectionsKt.getOrNull(this.groups, lineNumber);
                if (sourceMapGroup == null) break block9;
                SourceMapGroup it = sourceMapGroup2 = sourceMapGroup;
                boolean bl = false;
                sourceMapGroup = !((Collection)it.getSegments()).isEmpty() ? sourceMapGroup2 : null;
                if (sourceMapGroup != null) break block10;
            }
            return null;
        }
        SourceMapGroup group = sourceMapGroup;
        if (columnNumber == null || columnNumber <= group.getSegments().get(0).getGeneratedColumnNumber()) {
            sourceMapSegment = group.getSegments().get(0);
        } else {
            int candidateIndex;
            block8: {
                int n;
                List<SourceMapSegment> $this$indexOfFirst$iv = group.getSegments();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<SourceMapSegment> iterator2 = $this$indexOfFirst$iv.iterator();
                while (iterator2.hasNext()) {
                    SourceMapSegment item$iv;
                    SourceMapSegment it = item$iv = iterator2.next();
                    boolean bl = false;
                    if (columnNumber <= it.getGeneratedColumnNumber()) {
                        n = index$iv;
                        break block8;
                    }
                    ++index$iv;
                }
                n = candidateIndex = -1;
            }
            sourceMapSegment = candidateIndex < 0 ? null : (candidateIndex == 0 || group.getSegments().get(candidateIndex).getGeneratedColumnNumber() == columnNumber.intValue() ? group.getSegments().get(candidateIndex) : group.getSegments().get(candidateIndex - 1));
        }
        return sourceMapSegment;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tJ*\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap$Companion;", "", "<init>", "()V", "replaceSources", "", "sourceMapFile", "Ljava/io/File;", "mapping", "Lkotlin/Function1;", "", "mapSources", "content", "output", "Ljava/io/Writer;", "js.parser"})
    @SourceDebugExtension(value={"SMAP\nSourceMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMap.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1634#2,3:133\n*S KotlinDebug\n*F\n+ 1 SourceMap.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap$Companion\n*L\n95#1:133,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean replaceSources(@NotNull File sourceMapFile, @NotNull Function1<? super String, String> mapping) throws IOException, SourceMapSourceReplacementException {
            boolean bl;
            Intrinsics.checkNotNullParameter(sourceMapFile, "sourceMapFile");
            Intrinsics.checkNotNullParameter(mapping, "mapping");
            String content = FilesKt.readText$default(sourceMapFile, null, 1, null);
            Object object = sourceMapFile;
            Charset charset = Charsets.UTF_8;
            object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), charset);
            int n = 8192;
            object = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
            Throwable throwable = null;
            try {
                BufferedWriter it = (BufferedWriter)object;
                boolean bl2 = false;
                bl = Companion.mapSources(content, it, mapping);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean mapSources(@NotNull String content, @NotNull Writer output, @NotNull Function1<? super String, String> mapping) throws IOException, SourceMapSourceReplacementException {
            JsonNode jsonNode;
            Intrinsics.checkNotNullParameter(content, "content");
            Intrinsics.checkNotNullParameter(output, "output");
            Intrinsics.checkNotNullParameter(mapping, "mapping");
            try {
                jsonNode = JSONKt.parseJson(content);
            }
            catch (JsonSyntaxException e) {
                throw new SourceMapSourceReplacementException(null, (Throwable)e, 1, null);
            }
            JsonNode json = jsonNode;
            JsonObject jsonObject = json instanceof JsonObject ? (JsonObject)json : null;
            if (jsonObject == null) {
                throw new SourceMapSourceReplacementException("Top-level object expected", null, 2, null);
            }
            JsonObject jsonObject2 = jsonObject;
            JsonNode sources = jsonObject2.getProperties().get("sources");
            if (sources != null) {
                void destination$iv;
                void $this$mapTo$iv;
                JsonArray jsonArray = sources instanceof JsonArray ? (JsonArray)sources : null;
                if (jsonArray == null) {
                    throw new SourceMapSourceReplacementException("'sources' property is not of array type", null, 2, null);
                }
                JsonArray sourcesArray = jsonArray;
                boolean changed = false;
                Iterable iterable = sourcesArray.getElements();
                Collection collection = new ArrayList();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    JsonString sourcePath;
                    void it;
                    JsonNode jsonNode2 = (JsonNode)item$iv;
                    void var19_19 = destination$iv;
                    boolean bl = false;
                    if ((it instanceof JsonString ? (JsonString)it : null) == null) {
                        throw new SourceMapSourceReplacementException("'sources' array must contain strings", null, 2, null);
                    }
                    sourcePath = sourcePath;
                    String replacedPath = mapping.invoke(sourcePath.getValue());
                    if (!changed && !Intrinsics.areEqual(replacedPath, sourcePath.getValue())) {
                        changed = true;
                    }
                    var19_19.add(new JsonString(replacedPath));
                }
                List fixedSources = (List)destination$iv;
                if (!changed) {
                    return false;
                }
                jsonObject2.getProperties().put("sources", new JsonArray(fixedSources));
            }
            jsonObject2.write(output);
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

