/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.preprocessor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.preprocessor.IrInterpreterPreprocessor;
import org.jetbrains.kotlin.ir.interpreter.preprocessor.IrInterpreterPreprocessorData;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterKCallableNamePreprocessor;", "Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterPreprocessor;", "<init>", "()V", "visitCall", "Lorg/jetbrains/kotlin/ir/IrElement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterPreprocessorData;", "Companion", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIrInterpreterKCallableNamePreprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInterpreterKCallableNamePreprocessor.kt\norg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterKCallableNamePreprocessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,82:1\n1563#2:83\n1634#2,3:84\n1634#2,3:87\n827#2:107\n855#2,2:108\n1#3:90\n37#4:91\n36#4,3:92\n350#5,12:95\n*S KotlinDebug\n*F\n+ 1 IrInterpreterKCallableNamePreprocessor.kt\norg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterKCallableNamePreprocessor\n*L\n32#1:83\n32#1:84,3\n38#1:87,3\n50#1:107\n50#1:108,2\n41#1:91\n41#1:92,3\n45#1:95,12\n*E\n"})
public final class IrInterpreterKCallableNamePreprocessor
extends IrInterpreterPreprocessor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrInterpreterPreprocessorData data) {
        void $this$filterNotTo$iv$iv;
        void $this$single$iv;
        Object kFunction;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data, "data");
        if (!Companion.isKCallableNameCall(expression2, data.getIrBuiltIns())) {
            return super.visitCall(expression2, data);
        }
        IrExpression irExpression = expression2.getDispatchReceiver();
        IrCallableReference irCallableReference = irExpression instanceof IrCallableReference ? (IrCallableReference)irExpression : null;
        if (irCallableReference == null) {
            return super.visitCall(expression2, data);
        }
        IrCallableReference callableReference = irCallableReference;
        List boundArgs = CollectionsKt.filterNotNull(callableReference.getArguments());
        IrType irType = callableReference.getType();
        Intrinsics.checkNotNull(irType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        Iterable $this$map$iv = ((IrSimpleType)irType).getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            IrType irType2 = IrTypesKt.getTypeOrNull(irTypeArgument);
            Intrinsics.checkNotNull(irType2);
            object.add(irType2);
        }
        List typeArguments = (List)destination$iv$iv;
        if (!((Collection)boundArgs).isEmpty() && IrTypeUtilsKt.isKFunction(callableReference.getType())) {
            void destination$iv;
            IrType[] $this$mapTo$iv;
            kFunction = data.getIrBuiltIns().kFunctionN(typeArguments.size());
            Iterator typeArgIterator = typeArguments.iterator();
            destination$iv$iv = callableReference.getArguments();
            Collection $i$f$mapTo22 = new ArrayList();
            boolean $i$f$mapTo3 = false;
            for (Object e : $this$mapTo$iv) {
                void it;
                IrExpression bl = (IrExpression)e;
                object = destination$iv;
                boolean bl2 = false;
                IrType irType3 = it;
                if (irType3 == null || (irType3 = ((IrExpression)((Object)irType3)).getType()) == null) {
                    irType3 = (IrType)typeArgIterator.next();
                }
                object.add(irType3);
            }
            $this$mapTo$iv = destination$iv;
            List it = (List)$this$mapTo$iv;
            boolean bl = false;
            it.add(typeArgIterator.next());
            List newTypeArgs = (List)$this$mapTo$iv;
            Collection $this$toTypedArray$iv = newTypeArgs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$mapTo$iv = thisCollection$iv.toArray(new IrType[0]);
            callableReference.setType(IrTypesKt.typeWith((IrClass)kFunction, Arrays.copyOf($this$mapTo$iv, $this$mapTo$iv.length)));
        }
        kFunction = IrUtilsKt.getProperties((IrDeclarationContainer)data.getIrBuiltIns().getKCallableClass().getOwner());
        object = expression2;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv232 = false;
        for (Object element$iv : $this$single$iv) {
            IrProperty it = (IrProperty)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getName().asString(), "name")) continue;
            if (found$iv232) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv232 = true;
        }
        if (!found$iv232) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction irSimpleFunction = ((IrProperty)single$iv).getGetter();
        Intrinsics.checkNotNull(irSimpleFunction);
        ((IrCall)object).setSymbol(irSimpleFunction.getSymbol());
        Collections.fill(callableReference.getArguments(), null);
        Iterable $this$filterNot$iv = boundArgs;
        boolean $i$f$filterNot = false;
        Iterable found$iv232 = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object t : $this$filterNotTo$iv$iv) {
            IrExpression it = (IrExpression)t;
            boolean bl = false;
            if (it instanceof IrGetValue && Intrinsics.areEqual(((IrGetValue)it).getSymbol().getOwner().getName(), SpecialNames.THIS)) continue;
            destination$iv$iv2.add(t);
        }
        List boundArgsWithoutThis = (List)destination$iv$iv2;
        if (boundArgsWithoutThis.isEmpty()) {
            return expression2;
        }
        return new IrCompositeImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), null, CollectionsKt.plus((Collection)boundArgsWithoutThis, (Iterable)CollectionsKt.listOf(expression2)));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\n\u0010\t\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterKCallableNamePreprocessor$Companion;", "", "<init>", "()V", "isKCallableNameCall", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "isEnumName", "ir.interpreter"})
    @SourceDebugExtension(value={"SMAP\nIrInterpreterKCallableNamePreprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInterpreterKCallableNamePreprocessor.kt\norg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterKCallableNamePreprocessor$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isKCallableNameCall(@NotNull IrCall $this$isKCallableNameCall, @NotNull IrBuiltIns irBuiltIns) {
            Name name2;
            Intrinsics.checkNotNullParameter($this$isKCallableNameCall, "<this>");
            Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
            if (!($this$isKCallableNameCall.getDispatchReceiver() instanceof IrCallableReference)) {
                return false;
            }
            IrSimpleFunction it = (IrSimpleFunction)$this$isKCallableNameCall.getSymbol().getOwner();
            boolean bl = false;
            IrProperty irProperty = UtilsKt.getProperty(it);
            IrOverridableMember directMember = (IrOverridableMember)(irProperty != null ? (IrElement)irProperty : (IrElement)it);
            IrElement irElement = directMember.getParent();
            IrClass irClass = irElement instanceof IrClass ? (IrClass)irElement : null;
            if (irClass == null) {
                return false;
            }
            IrClass irClass2 = irClass;
            if (!IrUtilsKt.isSubclassOf(irClass2, (IrClass)irBuiltIns.getKCallableClass().getOwner())) {
                return false;
            }
            irElement = directMember;
            if (irElement instanceof IrSimpleFunction) {
                name2 = directMember.getName();
            } else if (irElement instanceof IrProperty) {
                name2 = directMember.getName();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Name name3 = name2;
            return Intrinsics.areEqual(name3.asString(), "name");
        }

        public final boolean isEnumName(@NotNull IrCall $this$isEnumName) {
            Intrinsics.checkNotNullParameter($this$isEnumName, "<this>");
            IrSimpleFunction owner = (IrSimpleFunction)$this$isEnumName.getSymbol().getOwner();
            if (!IrUtilsKt.hasShape$default(owner, true, false, 0, 0, null, 22, null)) {
                return false;
            }
            IrProperty irProperty = UtilsKt.getProperty(owner);
            if (irProperty == null) {
                return false;
            }
            IrProperty property2 = irProperty;
            return $this$isEnumName.getDispatchReceiver() instanceof IrGetEnumValue && Intrinsics.areEqual(property2.getName().asString(), "name");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

