/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.ArrayConstructor;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.ArrayOf;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.ArrayOfNulls;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.AssertIntrinsic;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.DataClassArrayToString;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EmptyArray;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EnumIntrinsics;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EnumValueOf;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EnumValues;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.Indent;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.JsPrimitives;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.SourceLocation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicEvaluator;", "", "<init>", "()V", "fqNameToHandler", "", "", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "unwindInstructions", "", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIntrinsicEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntrinsicEvaluator.kt\norg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicEvaluator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,28:1\n1869#2,2:29\n*S KotlinDebug\n*F\n+ 1 IntrinsicEvaluator.kt\norg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicEvaluator\n*L\n18#1:29,2\n*E\n"})
public final class IntrinsicEvaluator {
    @NotNull
    public static final IntrinsicEvaluator INSTANCE;
    @NotNull
    private static final Map<String, IntrinsicBase> fqNameToHandler;

    private IntrinsicEvaluator() {
    }

    @Nullable
    public final List<Instruction> unwindInstructions(@NotNull IrFunction irFunction, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        Intrinsics.checkNotNullParameter(environment, "environment");
        String fqName = UtilsKt.getFqName(irFunction);
        Object object = fqNameToHandler.get(fqName);
        if (object == null || (object = ((IntrinsicBase)object).unwind(irFunction, environment)) == null) {
            object = EnumIntrinsics.INSTANCE.canHandleFunctionWithName(fqName, irFunction.getOrigin()) ? EnumIntrinsics.INSTANCE.unwind(irFunction, environment) : null;
        }
        return object;
    }

    static {
        Map<String, IntrinsicBase> map;
        INSTANCE = new IntrinsicEvaluator();
        Map<String, IntrinsicBase> $this$fqNameToHandler_u24lambda_u242 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        IntrinsicBase[] intrinsicBaseArray = new IntrinsicBase[]{EmptyArray.INSTANCE, ArrayOf.INSTANCE, ArrayOfNulls.INSTANCE, ArrayConstructor.INSTANCE, EnumValues.INSTANCE, EnumValueOf.INSTANCE, JsPrimitives.INSTANCE, SourceLocation.INSTANCE, AssertIntrinsic.INSTANCE, DataClassArrayToString.INSTANCE, Indent.INSTANCE};
        Iterable $this$forEach$iv = CollectionsKt.listOf(intrinsicBaseArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IntrinsicBase intrinsic = (IntrinsicBase)element$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = intrinsic.getListOfAcceptableFunctions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl3 = false;
                $this$fqNameToHandler_u24lambda_u242.put(it, intrinsic);
            }
        }
        fqNameToHandler = MapsKt.build(map);
    }
}

