/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.metadata.MetadataSerializer;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.FirMetadataSource;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmSerializerExtension;
import org.jetbrains.kotlin.fir.backend.jvm.FirMetadataSerializerKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.fir.serialization.FirElementSerializer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable;
import org.jetbrains.kotlin.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.types.AbstractTypeApproximator;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001e\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J$\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirMetadataSerializer;", "Lorg/jetbrains/kotlin/backend/jvm/metadata/MetadataSerializer;", "globalSerializationBindings", "Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings;", "serializationBindings", "approximator", "Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "serializer", "Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;", "actualizedExpectDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings;Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings;Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;Ljava/util/Set;)V", "getSerializer$jvm_backend", "()Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;", "serialize", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/protobuf/MessageLite;", "Lorg/jetbrains/kotlin/metadata/jvm/serialization/JvmStringTable;", "metadata", "Lorg/jetbrains/kotlin/ir/declarations/MetadataSource;", "bindPropertyMetadata", "", "Lorg/jetbrains/kotlin/ir/declarations/MetadataSource$Property;", "signature", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "bindMethodMetadata", "Lorg/jetbrains/kotlin/ir/declarations/MetadataSource$Function;", "bindFieldMetadata", "Lorg/jetbrains/org/objectweb/asm/Type;", "", "jvm-backend"})
public final class FirMetadataSerializer
implements MetadataSerializer {
    @NotNull
    private final JvmSerializationBindings globalSerializationBindings;
    @NotNull
    private final JvmSerializationBindings serializationBindings;
    @NotNull
    private final AbstractTypeApproximator approximator;
    @Nullable
    private final FirElementSerializer serializer;
    @Nullable
    private final Set<FirDeclaration> actualizedExpectDeclarations;

    public FirMetadataSerializer(@NotNull JvmSerializationBindings globalSerializationBindings, @NotNull JvmSerializationBindings serializationBindings, @NotNull AbstractTypeApproximator approximator, @Nullable FirElementSerializer serializer, @Nullable Set<? extends FirDeclaration> actualizedExpectDeclarations) {
        Intrinsics.checkNotNullParameter(globalSerializationBindings, "globalSerializationBindings");
        Intrinsics.checkNotNullParameter(serializationBindings, "serializationBindings");
        Intrinsics.checkNotNullParameter(approximator, "approximator");
        this.globalSerializationBindings = globalSerializationBindings;
        this.serializationBindings = serializationBindings;
        this.approximator = approximator;
        this.serializer = serializer;
        this.actualizedExpectDeclarations = actualizedExpectDeclarations;
    }

    @Nullable
    public final FirElementSerializer getSerializer$jvm_backend() {
        return this.serializer;
    }

    @Override
    @Nullable
    public Pair<MessageLite, JvmStringTable> serialize(@NotNull MetadataSource metadata) {
        GeneratedMessageLite.ExtendableMessage extendableMessage;
        Intrinsics.checkNotNullParameter(metadata, "metadata");
        MetadataSource metadataSource = metadata;
        if (metadataSource instanceof FirMetadataSource.Class) {
            FirElementSerializer firElementSerializer = this.serializer;
            Intrinsics.checkNotNull(firElementSerializer);
            extendableMessage = firElementSerializer.classProto(((FirMetadataSource.Class)metadata).getFir()).build();
        } else if (metadataSource instanceof FirMetadataSource.File) {
            FirElementSerializer firElementSerializer = this.serializer;
            Intrinsics.checkNotNull(firElementSerializer);
            extendableMessage = firElementSerializer.packagePartProto(((FirMetadataSource.File)metadata).getFir(), this.actualizedExpectDeclarations).build();
        } else if (metadataSource instanceof FirMetadataSource.Function) {
            FirAnonymousFunction withTypeParameters = FirMetadataSerializerKt.access$copyToFreeAnonymousFunction(((FirMetadataSource.Function)metadata).getFir(), this.approximator);
            Method method = this.serializationBindings.get(FirJvmSerializerExtension.Companion.getMETHOD_FOR_FIR_FUNCTION(), ((FirMetadataSource.Function)metadata).getFir());
            if (method != null) {
                Method it = method;
                boolean bl = false;
                this.serializationBindings.put(FirJvmSerializerExtension.Companion.getMETHOD_FOR_FIR_FUNCTION(), withTypeParameters, it);
            }
            FirElementSerializer firElementSerializer = this.serializer;
            Intrinsics.checkNotNull(firElementSerializer);
            ProtoBuf.Function.Builder builder = firElementSerializer.functionProto(withTypeParameters);
            extendableMessage = builder != null ? builder.build() : null;
        } else if (metadataSource instanceof FirMetadataSource.Script) {
            FirElementSerializer firElementSerializer = this.serializer;
            Intrinsics.checkNotNull(firElementSerializer);
            extendableMessage = firElementSerializer.scriptProto(((FirMetadataSource.Script)metadata).getFir()).build();
        } else {
            extendableMessage = null;
        }
        if (extendableMessage == null) {
            return null;
        }
        GeneratedMessageLite.ExtendableMessage message = extendableMessage;
        FirElementSerializer firElementSerializer = this.serializer;
        Intrinsics.checkNotNull(firElementSerializer);
        FirElementAwareStringTable firElementAwareStringTable = firElementSerializer.getStringTable();
        Intrinsics.checkNotNull(firElementAwareStringTable, "null cannot be cast to non-null type org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable");
        return TuplesKt.to(message, (JvmStringTable)((Object)firElementAwareStringTable));
    }

    @Override
    public void bindPropertyMetadata(@NotNull MetadataSource.Property metadata, @NotNull Method signature, @NotNull IrDeclarationOrigin origin) {
        JvmSerializationBindings.SerializationMappingSlice<FirVariable, Method> serializationMappingSlice;
        Intrinsics.checkNotNullParameter(metadata, "metadata");
        Intrinsics.checkNotNullParameter(signature, "signature");
        Intrinsics.checkNotNullParameter(origin, "origin");
        FirProperty fir = ((FirMetadataSource.Property)metadata).getFir();
        IrDeclarationOrigin irDeclarationOrigin = origin;
        if (Intrinsics.areEqual(irDeclarationOrigin, JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_METHOD_FOR_PROPERTY_OR_TYPEALIAS_ANNOTATIONS())) {
            serializationMappingSlice = FirJvmSerializerExtension.Companion.getSYNTHETIC_METHOD_FOR_FIR_VARIABLE();
        } else if (Intrinsics.areEqual(irDeclarationOrigin, IrDeclarationOrigin.Companion.getPROPERTY_DELEGATE())) {
            serializationMappingSlice = FirJvmSerializerExtension.Companion.getDELEGATE_METHOD_FOR_FIR_VARIABLE();
        } else {
            throw new IllegalStateException("invalid origin " + origin + " for property-related method " + signature);
        }
        JvmSerializationBindings.SerializationMappingSlice<FirVariable, Method> slice = serializationMappingSlice;
        this.globalSerializationBindings.put(slice, fir, signature);
    }

    @Override
    public void bindMethodMetadata(@NotNull MetadataSource.Function metadata, @NotNull Method signature) {
        Intrinsics.checkNotNullParameter(metadata, "metadata");
        Intrinsics.checkNotNullParameter(signature, "signature");
        FirFunction fir = ((FirMetadataSource.Function)metadata).getFir();
        this.serializationBindings.put(FirJvmSerializerExtension.Companion.getMETHOD_FOR_FIR_FUNCTION(), fir, signature);
    }

    @Override
    public void bindFieldMetadata(@NotNull MetadataSource.Property metadata, @NotNull Pair<Type, String> signature) {
        Intrinsics.checkNotNullParameter(metadata, "metadata");
        Intrinsics.checkNotNullParameter(signature, "signature");
        MetadataSource.Property property2 = metadata;
        if (property2 instanceof FirMetadataSource.Property) {
            this.globalSerializationBindings.put(FirJvmSerializerExtension.Companion.getFIELD_FOR_PROPERTY(), ((FirMetadataSource.Property)metadata).getFir(), signature);
        } else if (property2 instanceof FirMetadataSource.Field) {
            FirField $this$bindFieldMetadata_u24lambda_u242 = ((FirMetadataSource.Field)metadata).getFir();
            boolean bl = false;
            KtSourceElement ktSourceElement = $this$bindFieldMetadata_u24lambda_u242.getSource();
            if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.ClassDelegationField.INSTANCE)) {
                boolean bl2 = false;
                KtSourceElement ktSourceElement2 = $this$bindFieldMetadata_u24lambda_u242.getSource();
                String string2 = "Expected delegate field, got " + UtilsKt.render($this$bindFieldMetadata_u24lambda_u242) + " with source kind " + (ktSourceElement2 != null ? ktSourceElement2.getKind() : null);
                throw new IllegalArgumentException(string2.toString());
            }
        } else {
            throw new IllegalStateException(("Unexpected metadata: " + metadata).toString());
        }
    }
}

