/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.InternalCoroutinesApi;
import kotlinx.coroutines.internal.ThreadSafeHeapNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u0000\n\u0002\u0018\u0002\b\u0017\u0018\u0000*\u0012\b\u0000\u0010\u0003*\u00020\u0001*\b\u0012\u0004\u0012\u00028\u00000\u00022\u000605j\u0002`6B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00028\u0000H\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\n\u0010\tJ.\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00028\u00002\u0014\u0010\r\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00020\f0\u000bH\u0086\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0005J2\u0010\u0015\u001a\u0004\u0018\u00018\u00002!\u0010\u0014\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0011\u0010\u0017\u001a\u0004\u0018\u00018\u0000H\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u0017\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u001aH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00028\u00002\u0006\u0010 \u001a\u00020\u001fH\u0001\u00a2\u0006\u0004\b!\u0010\"J&\u0010#\u001a\u0004\u0018\u00018\u00002\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u000bH\u0086\b\u00a2\u0006\u0004\b#\u0010\u0016J\u000f\u0010$\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b$\u0010\u0018J\u0018\u0010&\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u001fH\u0082\u0010\u00a2\u0006\u0004\b&\u0010'J\u0018\u0010(\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u001fH\u0082\u0010\u00a2\u0006\u0004\b(\u0010'J\u001f\u0010*\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b*\u0010+R \u0010,\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R$\u00103\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u001f8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b0\u00101\"\u0004\b2\u0010'\u00a8\u00064"}, d2={"Lkotlinx/coroutines/internal/ThreadSafeHeap;", "Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "", "T", "<init>", "()V", "node", "", "addImpl", "(Lkotlinx/coroutines/internal/ThreadSafeHeapNode;)V", "addLast", "Lkotlin/Function1;", "", "cond", "addLastIf", "(Lkotlinx/coroutines/internal/ThreadSafeHeapNode;Lkotlin/jvm/functions/Function1;)Z", "clear", "Lkotlin/ParameterName;", "name", "value", "predicate", "find", "(Lkotlin/jvm/functions/Function1;)Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "firstImpl", "()Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "peek", "", "realloc", "()[Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "remove", "(Lkotlinx/coroutines/internal/ThreadSafeHeapNode;)Z", "", "index", "removeAtImpl", "(I)Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "removeFirstIf", "removeFirstOrNull", "i", "siftDownFrom", "(I)V", "siftUpFrom", "j", "swap", "(II)V", "a", "[Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "isEmpty", "()Z", "getSize", "()I", "setSize", "size", "kotlinx-coroutines-core", "", "Lkotlinx/coroutines/internal/SynchronizedObject;"})
@InternalCoroutinesApi
public class ThreadSafeHeap<T extends ThreadSafeHeapNode & Comparable<? super T>> {
    @Nullable
    private T[] a;
    @NotNull
    private volatile /* synthetic */ int _size;

    public ThreadSafeHeap() {
        this._size = 0;
    }

    public final int getSize() {
        return this._size;
    }

    private final void setSize(int value) {
        this._size = value;
    }

    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        boolean $i$f$synchronized = false;
        ThreadSafeHeap threadSafeHeap = this;
        synchronized (threadSafeHeap) {
            boolean bl = false;
            if (this.a != null) {
                ArraysKt.fill$default((Object[])this.a, null, (int)0, (int)0, (int)6, null);
            }
            this._size = 0;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final T find(@NotNull Function1<? super T, Boolean> predicate) {
        T t;
        boolean $i$f$synchronized = false;
        ThreadSafeHeap threadSafeHeap = this;
        synchronized (threadSafeHeap) {
            T t2;
            block4: {
                boolean bl = false;
                int n = this.getSize();
                for (int i = 0; i < n; ++i) {
                    T value;
                    Intrinsics.checkNotNull(this.a != null ? this.a[i] : null);
                    value = value;
                    if (!((Boolean)predicate.invoke(value)).booleanValue()) continue;
                    t2 = value;
                    break block4;
                }
                t2 = null;
            }
            t = t2;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final T peek() {
        T t;
        boolean $i$f$synchronized = false;
        ThreadSafeHeap threadSafeHeap = this;
        synchronized (threadSafeHeap) {
            boolean bl = false;
            t = this.firstImpl();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final T removeFirstOrNull() {
        ThreadSafeHeapNode threadSafeHeapNode;
        boolean $i$f$synchronized = false;
        ThreadSafeHeap threadSafeHeap = this;
        synchronized (threadSafeHeap) {
            boolean bl = false;
            threadSafeHeapNode = this.getSize() > 0 ? this.removeAtImpl(0) : (ThreadSafeHeapNode)null;
        }
        return (T)threadSafeHeapNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Nullable
    public final T removeFirstIf(@NotNull Function1<? super T, Boolean> predicate) {
        block5: {
            boolean $i$f$removeFirstIf = false;
            boolean $i$f$synchronized = false;
            ThreadSafeHeap threadSafeHeap = this;
            // MONITORENTER : threadSafeHeap
            boolean bl = false;
            if (this.firstImpl() != null) break block5;
            T t = null;
            InlineMarker.finallyStart((int)2);
            // MONITOREXIT : threadSafeHeap
            InlineMarker.finallyEnd((int)2);
            return t;
        }
        try {
            T t;
            T first2 = t;
            ThreadSafeHeapNode threadSafeHeapNode = ((Boolean)predicate.invoke(first2)).booleanValue() ? this.removeAtImpl(0) : (ThreadSafeHeapNode)null;
            return (T)threadSafeHeapNode;
        }
        finally {
            InlineMarker.finallyStart((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addLast(@NotNull T node) {
        boolean $i$f$synchronized = false;
        ThreadSafeHeap threadSafeHeap = this;
        synchronized (threadSafeHeap) {
            boolean bl = false;
            this.addImpl(node);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addLastIf(@NotNull T node, @NotNull Function1<? super T, Boolean> cond) {
        boolean $i$f$addLastIf = false;
        boolean $i$f$synchronized = false;
        ThreadSafeHeap threadSafeHeap = this;
        synchronized (threadSafeHeap) {
            boolean bl;
            try {
                boolean bl2;
                boolean bl3 = false;
                if (((Boolean)cond.invoke(this.firstImpl())).booleanValue()) {
                    this.addImpl(node);
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                bl = bl2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl18 : MonitorExitStatement: MONITOREXIT : var5_5
                InlineMarker.finallyEnd((int)1);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(@NotNull T node) {
        boolean $i$f$synchronized = false;
        ThreadSafeHeap threadSafeHeap = this;
        synchronized (threadSafeHeap) {
            boolean bl;
            boolean bl2 = false;
            if (node.getHeap() == null) {
                bl = false;
            } else {
                int index = node.getIndex();
                if (DebugKt.getASSERTIONS_ENABLED()) {
                    boolean bl3 = false;
                    if (!(index >= 0)) {
                        throw new AssertionError();
                    }
                }
                this.removeAtImpl(index);
                bl = true;
            }
            boolean bl4 = bl;
            return bl4;
        }
    }

    @PublishedApi
    @Nullable
    public final T firstImpl() {
        return (T)(this.a != null ? this.a[0] : null);
    }

    /*
     * Unable to fully structure code
     */
    @PublishedApi
    @NotNull
    public final T removeAtImpl(int index) {
        block6: {
            if (DebugKt.getASSERTIONS_ENABLED()) {
                $i$a$-assert-ThreadSafeHeap$removeAtImpl$1 = false;
                if (!(this.getSize() > 0)) {
                    throw new AssertionError();
                }
            }
            Intrinsics.checkNotNull(this.a);
            a = this.a;
            var3_4 = this.getSize();
            this.setSize(var3_4 + -1);
            if (index >= this.getSize()) break block6;
            this.swap(index, this.getSize());
            j = (index - 1) / 2;
            if (index <= 0) ** GOTO lbl-1000
            v0 = a[index];
            Intrinsics.checkNotNull(v0);
            v1 = (Comparable)v0;
            v2 = a[j];
            Intrinsics.checkNotNull(v2);
            if (v1.compareTo(v2) < 0) {
                this.swap(index, j);
                this.siftUpFrom(j);
            } else lbl-1000:
            // 2 sources

            {
                this.siftDownFrom(index);
            }
        }
        v3 = a[this.getSize()];
        Intrinsics.checkNotNull(v3);
        result = v3;
        if (DebugKt.getASSERTIONS_ENABLED()) {
            $i$a$-assert-ThreadSafeHeap$removeAtImpl$2 = false;
            if (!(result.getHeap() == this)) {
                throw new AssertionError();
            }
        }
        result.setHeap(null);
        result.setIndex(-1);
        a[this.getSize()] = null;
        return result;
    }

    @PublishedApi
    public final void addImpl(@NotNull T node) {
        if (DebugKt.getASSERTIONS_ENABLED()) {
            boolean bl = false;
            if (!(node.getHeap() == null)) {
                throw new AssertionError();
            }
        }
        node.setHeap(this);
        ThreadSafeHeapNode[] a = this.realloc();
        int n = this.getSize();
        this.setSize(n + 1);
        int i = n;
        a[i] = node;
        node.setIndex(i);
        this.siftUpFrom(i);
    }

    private final void siftUpFrom(int i) {
        ThreadSafeHeap threadSafeHeap = this;
        int n = i;
        while (true) {
            ThreadSafeHeap threadSafeHeap2 = threadSafeHeap;
            int n2 = n;
            if (n2 <= 0) {
                return;
            }
            Intrinsics.checkNotNull(threadSafeHeap2.a);
            T[] a = threadSafeHeap2.a;
            int j = (n2 - 1) / 2;
            T t = a[j];
            Intrinsics.checkNotNull(t);
            Comparable comparable = (Comparable)t;
            T t2 = a[n2];
            Intrinsics.checkNotNull(t2);
            if (comparable.compareTo(t2) <= 0) {
                return;
            }
            threadSafeHeap2.swap(n2, j);
            threadSafeHeap = threadSafeHeap2;
            n = j;
        }
    }

    private final void siftDownFrom(int i) {
        ThreadSafeHeap threadSafeHeap = this;
        int n = i;
        ThreadSafeHeap threadSafeHeap2;
        int n2;
        int j;
        while ((j = 2 * (n2 = n) + 1) < (threadSafeHeap2 = threadSafeHeap).getSize()) {
            Intrinsics.checkNotNull(threadSafeHeap2.a);
            T[] a = threadSafeHeap2.a;
            if (j + 1 < threadSafeHeap2.getSize()) {
                T t = a[j + 1];
                Intrinsics.checkNotNull(t);
                Comparable comparable = (Comparable)t;
                T t2 = a[j];
                Intrinsics.checkNotNull(t2);
                if (comparable.compareTo(t2) < 0) {
                    ++j;
                }
            }
            T t = a[n2];
            Intrinsics.checkNotNull(t);
            Comparable comparable = (Comparable)t;
            T t3 = a[j];
            Intrinsics.checkNotNull(t3);
            if (comparable.compareTo(t3) <= 0) {
                return;
            }
            threadSafeHeap2.swap(n2, j);
            int n3 = j;
            threadSafeHeap = threadSafeHeap2;
            n = n3;
        }
        return;
    }

    private final T[] realloc() {
        Object[] objectArray;
        T[] a = this.a;
        if (a == null) {
            ThreadSafeHeapNode[] threadSafeHeapNodeArray;
            ThreadSafeHeapNode[] it = threadSafeHeapNodeArray = new ThreadSafeHeapNode[4];
            boolean bl = false;
            this.a = it;
            objectArray = threadSafeHeapNodeArray;
        } else if (this.getSize() >= a.length) {
            T[] TArray = Arrays.copyOf(a, this.getSize() * 2);
            Intrinsics.checkNotNullExpressionValue(TArray, (String)"copyOf(this, newSize)");
            T[] TArray2 = TArray;
            ThreadSafeHeapNode[] it = (ThreadSafeHeapNode[])TArray2;
            boolean bl = false;
            this.a = it;
            objectArray = (ThreadSafeHeapNode[])TArray2;
        } else {
            objectArray = a;
        }
        return objectArray;
    }

    private final void swap(int i, int j) {
        Intrinsics.checkNotNull(this.a);
        T[] a = this.a;
        T t = a[j];
        Intrinsics.checkNotNull(t);
        T ni = t;
        T t2 = a[i];
        Intrinsics.checkNotNull(t2);
        T nj = t2;
        a[i] = ni;
        a[j] = nj;
        ni.setIndex(i);
        nj.setIndex(j);
    }
}

