/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.parcel;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.android.parcel.IgnoredOnParcel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.parcel.ParcelableCodegenExtensionKt;
import org.jetbrains.kotlin.android.parcel.ParcelableDeclarationCheckerKt;
import org.jetbrains.kotlin.android.parcel.ParcelableResolveExtensionKt;
import org.jetbrains.kotlin.android.parcel.serializers.ParcelSerializer;
import org.jetbrains.kotlin.android.parcel.serializers.ParcelSerializerKt;
import org.jetbrains.kotlin.android.synthetic.diagnostic.ErrorsAndroid;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J0\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\f\u0010!\u001a\u00020\"*\u00020\fH\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/android/parcel/ParcelableDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkParcelableClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkParcelableClassMethod", "method", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "containingClass", "Lorg/jetbrains/kotlin/psi/KtFunction;", "checkParcelableClassProperty", "property", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "containerClass", "typeMapper", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "hasCustomParceler", "", "Companion", "android-extensions-compiler"})
@SourceDebugExtension(value={"SMAP\nParcelableDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParcelableDeclarationChecker.kt\norg/jetbrains/kotlin/android/parcel/ParcelableDeclarationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1#2:252\n2624#3,3:253\n1747#3,3:256\n1747#3,3:259\n*S KotlinDebug\n*F\n+ 1 ParcelableDeclarationChecker.kt\norg/jetbrains/kotlin/android/parcel/ParcelableDeclarationChecker\n*L\n164#1:253,3\n248#1:256,3\n91#1:259,3\n*E\n"})
public final class ParcelableDeclarationChecker
implements DeclarationChecker {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final FqName IGNORED_ON_PARCEL_FQNAME = new FqName(IgnoredOnParcel.class.getCanonicalName());

    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        BindingTrace trace = context2.getTrace();
        DeclarationDescriptor declarationDescriptor = descriptor;
        if (declarationDescriptor instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
            DiagnosticSink diagnosticSink = (DiagnosticSink)trace;
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            this.checkParcelableClass(classDescriptor, declaration, diagnosticSink, bindingContext, context2.getLanguageVersionSettings());
        } else if (declarationDescriptor instanceof SimpleFunctionDescriptor) {
            KtFunction ktFunction;
            DeclarationDescriptor declarationDescriptor2 = ((SimpleFunctionDescriptor)descriptor).getContainingDeclaration();
            ClassDescriptor containingClass = declarationDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor2 : null;
            KtFunction ktFunction2 = ktFunction = declaration instanceof KtFunction ? (KtFunction)declaration : null;
            if (containingClass != null && ktFunction != null) {
                this.checkParcelableClassMethod((SimpleFunctionDescriptor)descriptor, containingClass, ktFunction, (DiagnosticSink)trace);
            }
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            KtProperty ktProperty;
            DeclarationDescriptor ktFunction = ((PropertyDescriptor)descriptor).getContainingDeclaration();
            ClassDescriptor containingClass = ktFunction instanceof ClassDescriptor ? (ClassDescriptor)ktFunction : null;
            KtProperty ktProperty2 = ktProperty = declaration instanceof KtProperty ? (KtProperty)declaration : null;
            if (containingClass != null && ktProperty != null) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
                DiagnosticSink diagnosticSink = (DiagnosticSink)trace;
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                this.checkParcelableClassProperty(propertyDescriptor, containingClass, ktProperty, diagnosticSink, bindingContext);
            }
        }
    }

    private final void checkParcelableClassMethod(SimpleFunctionDescriptor method, ClassDescriptor containingClass, KtFunction declaration, DiagnosticSink diagnosticHolder) {
        if (!ParcelableResolveExtensionKt.isParcelize(containingClass)) {
            return;
        }
        if (ParcelableResolveExtensionKt.isWriteToParcel(method) && declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            KtModifierList ktModifierList = declaration.getModifierList();
            if ((ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.OVERRIDE_KEYWORD)) == null) && (ktModifierList = declaration.getNameIdentifier()) == null) {
                ktModifierList = (PsiElement)declaration;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierList, (String)"declaration.modifierList\u2026Identifier ?: declaration");
            KtModifierList reportElement = ktModifierList;
            diagnosticHolder.report((Diagnostic)ErrorsAndroid.OVERRIDING_WRITE_TO_PARCEL_IS_NOT_ALLOWED.on((PsiElement)reportElement));
        }
    }

    private final void checkParcelableClassProperty(PropertyDescriptor property2, ClassDescriptor containingClass, KtProperty declaration, DiagnosticSink diagnosticHolder, BindingContext bindingContext) {
        if (ParcelableResolveExtensionKt.isParcelize(containingClass) && (declaration.hasDelegate() || Intrinsics.areEqual((Object)bindingContext.get((ReadOnlySlice)BindingContext.BACKING_FIELD_REQUIRED, (Object)property2), (Object)true)) && !ParcelableDeclarationChecker.checkParcelableClassProperty$hasIgnoredOnParcel$1(property2)) {
            PsiElement psiElement = declaration.getNameIdentifier();
            if (psiElement == null) {
                psiElement = (PsiElement)declaration;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"declaration.nameIdentifier ?: declaration");
            PsiElement reportElement = psiElement;
            diagnosticHolder.report((Diagnostic)ErrorsAndroid.PROPERTY_WONT_BE_SERIALIZED.on(reportElement));
        }
        if (Intrinsics.areEqual((Object)property2.getName().asString(), (Object)"CREATOR") && JvmAnnotationUtilKt.findJvmFieldAnnotation((DeclarationDescriptor)((DeclarationDescriptor)property2)) != null && containingClass.isCompanionObject()) {
            ClassDescriptor outerClass;
            DeclarationDescriptor declarationDescriptor = containingClass.getContainingDeclaration();
            ClassDescriptor classDescriptor = outerClass = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (outerClass != null && ParcelableResolveExtensionKt.isParcelize(outerClass)) {
                PsiElement psiElement = declaration.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = (PsiElement)declaration;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"declaration.nameIdentifier ?: declaration");
                PsiElement reportElement = psiElement;
                diagnosticHolder.report((Diagnostic)ErrorsAndroid.CREATOR_DEFINITION_IS_NOT_ALLOWED.on(reportElement));
            }
        }
    }

    private final void checkParcelableClass(ClassDescriptor descriptor, KtDeclaration declaration, DiagnosticSink diagnosticHolder, BindingContext bindingContext, LanguageVersionSettings languageVersionSettings) {
        boolean bl;
        Object reportElement;
        block30: {
            PsiElement reportElement2;
            PsiElement sealedOrAbstract;
            PsiElement psiElement;
            if (!ParcelableResolveExtensionKt.isParcelize(descriptor)) {
                return;
            }
            if (!(declaration instanceof KtClassOrObject)) {
                diagnosticHolder.report((Diagnostic)ErrorsAndroid.PARCELABLE_SHOULD_BE_CLASS.on((PsiElement)declaration));
                return;
            }
            if (declaration instanceof KtClass && (((KtClassOrObject)declaration).isAnnotation() || ((KtClass)declaration).isInterface())) {
                PsiElement psiElement2 = ((KtClass)declaration).getNameIdentifier();
                if (psiElement2 == null) {
                    psiElement2 = (PsiElement)declaration;
                }
                PsiElement reportElement3 = psiElement2;
                diagnosticHolder.report((Diagnostic)ErrorsAndroid.PARCELABLE_SHOULD_BE_CLASS.on(reportElement3));
                return;
            }
            for (KtObjectDeclaration companion : ((KtClassOrObject)declaration).getCompanionObjects()) {
                if (!Intrinsics.areEqual((Object)companion.getName(), (Object)"CREATOR")) continue;
                PsiElement psiElement3 = companion.getNameIdentifier();
                if (psiElement3 == null) {
                    psiElement3 = (PsiElement)companion;
                }
                reportElement = psiElement3;
                diagnosticHolder.report((Diagnostic)ErrorsAndroid.CREATOR_DEFINITION_IS_NOT_ALLOWED.on((PsiElement)reportElement));
            }
            KtModifierList ktModifierList = ((KtClassOrObject)declaration).getModifierList();
            if (ktModifierList != null) {
                KtModifierList it = ktModifierList;
                boolean bl2 = false;
                psiElement = it.getModifier(KtTokens.ABSTRACT_KEYWORD);
                if (psiElement == null) {
                    psiElement = it.getModifier(KtTokens.SEALED_KEYWORD);
                }
            } else {
                psiElement = sealedOrAbstract = null;
            }
            if (sealedOrAbstract != null) {
                diagnosticHolder.report((Diagnostic)ErrorsAndroid.PARCELABLE_SHOULD_BE_INSTANTIABLE.on(sealedOrAbstract));
            }
            if (declaration instanceof KtClass && ((KtClass)declaration).isInner()) {
                KtModifierList ktModifierList2 = ((KtClass)declaration).getModifierList();
                if ((ktModifierList2 == null || (ktModifierList2 = ktModifierList2.getModifier(KtTokens.INNER_KEYWORD)) == null) && (ktModifierList2 = ((KtClass)declaration).getNameIdentifier()) == null) {
                    ktModifierList2 = (PsiElement)declaration;
                }
                reportElement2 = ktModifierList2;
                diagnosticHolder.report((Diagnostic)ErrorsAndroid.PARCELABLE_CANT_BE_INNER_CLASS.on(reportElement2));
            }
            if (((KtClassOrObject)declaration).isLocal()) {
                PsiElement psiElement4 = ((KtClassOrObject)declaration).getNameIdentifier();
                if (psiElement4 == null) {
                    psiElement4 = (PsiElement)declaration;
                }
                reportElement2 = psiElement4;
                diagnosticHolder.report((Diagnostic)ErrorsAndroid.PARCELABLE_CANT_BE_LOCAL_CLASS.on(reportElement2));
            }
            Set set = TypeUtils.getAllSupertypes((KotlinType)((KotlinType)descriptor.getDefaultType()));
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllSupertypes(descriptor.defaultType)");
            Set superTypes = set;
            Iterable $this$none$iv = superTypes;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FqName fqName;
                    ClassifierDescriptor classifierDescriptor;
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl3 = false;
                    ClassifierDescriptor classifierDescriptor2 = classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                    if (classifierDescriptor2 != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptor2, (String)"declarationDescriptor");
                        fqName = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor));
                    } else {
                        fqName = null;
                    }
                    if (!Intrinsics.areEqual(fqName, (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCELABLE_CLASS_FQNAME())) continue;
                    bl = false;
                    break block30;
                }
                bl = true;
            }
        }
        if (bl) {
            PsiElement psiElement = ((KtClassOrObject)declaration).getNameIdentifier();
            if (psiElement == null) {
                psiElement = (PsiElement)declaration;
            }
            reportElement = psiElement;
            diagnosticHolder.report((Diagnostic)ErrorsAndroid.NO_PARCELABLE_SUPERTYPE.on((PsiElement)reportElement));
        }
        for (KtSuperTypeListEntry supertypeEntry : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
            KotlinType type;
            if ((supertypeEntry instanceof KtDelegatedSuperTypeEntry ? (KtDelegatedSuperTypeEntry)supertypeEntry : null) == null || ((KtDelegatedSuperTypeEntry)supertypeEntry).getDelegateExpression() == null || (KotlinType)bindingContext.get((ReadOnlySlice)BindingContext.TYPE, (Object)((KtDelegatedSuperTypeEntry)supertypeEntry).getTypeReference()) == null || !ParcelSerializerKt.isParcelable(type)) continue;
            ASTNode aSTNode = ((KtDelegatedSuperTypeEntry)supertypeEntry).getByKeywordNode();
            Object object = aSTNode != null ? aSTNode.getPsi() : null;
            if (object == null) {
                KtExpression delegateExpression;
                object = (PsiElement)delegateExpression;
            }
            PsiElement reportElement4 = object;
            diagnosticHolder.report((Diagnostic)ErrorsAndroid.PARCELABLE_DELEGATE_IS_NOT_ALLOWED.on(reportElement4));
        }
        KtPrimaryConstructor primaryConstructor = ((KtClassOrObject)declaration).getPrimaryConstructor();
        if (primaryConstructor == null && !((Collection)((KtClassOrObject)declaration).getSecondaryConstructors()).isEmpty()) {
            PsiElement psiElement = ((KtClassOrObject)declaration).getNameIdentifier();
            if (psiElement == null) {
                psiElement = (PsiElement)declaration;
            }
            PsiElement reportElement5 = psiElement;
            diagnosticHolder.report((Diagnostic)ErrorsAndroid.PARCELABLE_SHOULD_HAVE_PRIMARY_CONSTRUCTOR.on(reportElement5));
        } else if (primaryConstructor != null && primaryConstructor.getValueParameters().isEmpty()) {
            PsiElement psiElement = ((KtClassOrObject)declaration).getNameIdentifier();
            if (psiElement == null) {
                psiElement = (PsiElement)declaration;
            }
            PsiElement reportElement6 = psiElement;
            diagnosticHolder.report((Diagnostic)ErrorsAndroid.PARCELABLE_PRIMARY_CONSTRUCTOR_IS_EMPTY.on(reportElement6));
        }
        ClassBuilderMode classBuilderMode = ClassBuilderMode.FULL;
        Intrinsics.checkNotNullExpressionValue((Object)classBuilderMode, (String)"FULL");
        String string = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor)).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.module.name.asString()");
        KotlinTypeMapper typeMapper = new KotlinTypeMapper(bindingContext, classBuilderMode, string, languageVersionSettings, false, null, false, null, null, 480, null);
        KtPrimaryConstructor ktPrimaryConstructor = primaryConstructor;
        List list = ktPrimaryConstructor != null ? ktPrimaryConstructor.getValueParameters() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (KtParameter parameter : list) {
            this.checkParcelableClassProperty(parameter, descriptor, diagnosticHolder, typeMapper);
        }
    }

    private final void checkParcelableClassProperty(KtParameter parameter, ClassDescriptor containerClass, DiagnosticSink diagnosticHolder, KotlinTypeMapper typeMapper) {
        if (!parameter.hasValOrVar()) {
            PsiElement psiElement = parameter.getNameIdentifier();
            if (psiElement == null) {
                psiElement = (PsiElement)parameter;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameter.nameIdentifier ?: parameter");
            PsiElement reportElement = psiElement;
            diagnosticHolder.report((Diagnostic)ErrorsAndroid.PARCELABLE_CONSTRUCTOR_PARAMETER_SHOULD_BE_VAL_OR_VAR.on(reportElement));
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)typeMapper.getBindingContext().get((ReadOnlySlice)BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, (Object)parameter);
        if (propertyDescriptor == null) {
            return;
        }
        PropertyDescriptor descriptor = propertyDescriptor;
        KotlinType kotlinType = descriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
        KotlinType type = kotlinType;
        if (!KotlinTypeKt.isError((KotlinType)type) && !this.hasCustomParceler(containerClass)) {
            Type asmType = KotlinTypeMapper.mapType$default((KotlinTypeMapper)typeMapper, (KotlinType)type, null, null, (int)6, null);
            try {
                List parcelers = CollectionsKt.plus((Collection)ParcelableCodegenExtensionKt.getTypeParcelers(descriptor.getAnnotations()), (Iterable)ParcelableCodegenExtensionKt.getTypeParcelers(containerClass.getAnnotations()));
                SimpleType simpleType = containerClass.getDefaultType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"containerClass.defaultType");
                ParcelSerializer.ParcelSerializerContext context2 = new ParcelSerializer.ParcelSerializerContext(typeMapper, KotlinTypeMapper.mapType$default((KotlinTypeMapper)typeMapper, (KotlinType)((KotlinType)simpleType), null, null, (int)6, null), parcelers, new FrameMap());
                ParcelSerializer.Companion.get$default(ParcelSerializer.Companion, type, asmType, context2, false, true, 8, null);
            }
            catch (IllegalArgumentException e) {
                PsiElement psiElement;
                KtTypeReference ktTypeReference = parameter.getTypeReference();
                if (ktTypeReference != null) {
                    psiElement = (PsiElement)ktTypeReference;
                } else {
                    psiElement = parameter.getNameIdentifier();
                    if (psiElement == null) {
                        psiElement = (PsiElement)parameter;
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameter.typeReference \u2026meIdentifier ?: parameter");
                PsiElement reportElement = psiElement;
                diagnosticHolder.report((Diagnostic)ErrorsAndroid.PARCELABLE_TYPE_NOT_SUPPORTED.on(reportElement));
            }
        }
    }

    private final boolean hasCustomParceler(ClassDescriptor $this$hasCustomParceler) {
        boolean bl;
        block7: {
            ClassDescriptor it;
            Object object;
            block9: {
                block8: {
                    object = $this$hasCustomParceler.getCompanionObjectDescriptor();
                    if (object == null) break block8;
                    it = object;
                    boolean bl2 = false;
                    Set set = TypeUtils.getAllSupertypes((KotlinType)((KotlinType)it.getDefaultType()));
                    object = set;
                    if (set != null) break block9;
                }
                return false;
            }
            Object companionObjectSuperTypes = object;
            Iterable $this$any$iv = (Iterable)companionObjectSuperTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (KotlinType)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!ParcelableResolveExtensionKt.isParceler((KotlinType)it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean checkParcelableClassProperty$hasIgnoredOnParcel$1$hasIgnoredOnParcel(Annotations $this$checkParcelableClassProperty_u24hasIgnoredOnParcel_u241_u24hasIgnoredOnParcel) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)$this$checkParcelableClassProperty_u24hasIgnoredOnParcel_u241_u24hasIgnoredOnParcel;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)IGNORED_ON_PARCEL_FQNAME)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean checkParcelableClassProperty$hasIgnoredOnParcel$1(PropertyDescriptor $property) {
        PropertyGetterDescriptor propertyGetterDescriptor;
        return ParcelableDeclarationChecker.checkParcelableClassProperty$hasIgnoredOnParcel$1$hasIgnoredOnParcel($property.getAnnotations()) || ((propertyGetterDescriptor = $property.getGetter()) != null && (propertyGetterDescriptor = propertyGetterDescriptor.getAnnotations()) != null ? ParcelableDeclarationChecker.checkParcelableClassProperty$hasIgnoredOnParcel$1$hasIgnoredOnParcel((Annotations)propertyGetterDescriptor) : false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/android/parcel/ParcelableDeclarationChecker$Companion;", "", "()V", "IGNORED_ON_PARCEL_FQNAME", "Lorg/jetbrains/kotlin/name/FqName;", "android-extensions-compiler"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

