/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.repl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.lazy.FileScopeFactory;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProviderKt;
import org.jetbrains.kotlin.resolve.lazy.FileScopes;
import org.jetbrains.kotlin.resolve.lazy.FileScopesCustomizer;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0016\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/repl/ReplState;", "", "()V", "lines", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo;", "Lkotlin/collections/HashMap;", "successfulLines", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "Lkotlin/collections/ArrayList;", "successfulLinesCount", "", "getSuccessfulLinesCount", "()I", "computeFileScopes", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopes;", "lineInfo", "fileScopeFactory", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeFactory;", "lineFailure", "", "ktFile", "lineSuccess", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "submitLine", "LineInfo", "frontend"})
@SourceDebugExtension(value={"SMAP\nReplState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplState.kt\norg/jetbrains/kotlin/resolve/repl/ReplState\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,85:1\n30#2,2:86\n*S KotlinDebug\n*F\n+ 1 ReplState.kt\norg/jetbrains/kotlin/resolve/repl/ReplState\n*L\n79#1:86,2\n*E\n"})
public final class ReplState {
    @NotNull
    private final HashMap<KtFile, LineInfo> lines = new HashMap();
    @NotNull
    private final ArrayList<LineInfo.SuccessfulLine> successfulLines = new ArrayList();

    public final int getSuccessfulLinesCount() {
        return this.successfulLines.size();
    }

    public final void submitLine(@NotNull KtFile ktFile) {
        Intrinsics.checkNotNullParameter(ktFile, "ktFile");
        LineInfo.SubmittedLine line = new LineInfo.SubmittedLine(ktFile, (LineInfo.SuccessfulLine)CollectionsKt.lastOrNull((List)this.successfulLines));
        ((Map)this.lines).put(ktFile, line);
        FileScopeProviderKt.setFileScopesCustomizer(ktFile, new FileScopesCustomizer(this, ktFile){
            final /* synthetic */ ReplState this$0;
            final /* synthetic */ KtFile $ktFile;
            {
                this.this$0 = $receiver;
                this.$ktFile = $ktFile;
            }

            @NotNull
            public FileScopes createFileScopes(@NotNull FileScopeFactory fileScopeFactory) {
                Object object;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter(fileScopeFactory, "fileScopeFactory");
                        object = ReplState.access$lineInfo(this.this$0, this.$ktFile);
                        if (object == null) break block2;
                        LineInfo lineInfo = object;
                        ReplState replState = this.this$0;
                        LineInfo it = lineInfo;
                        boolean bl = false;
                        FileScopes fileScopes = ReplState.access$computeFileScopes(replState, it, fileScopeFactory);
                        object = fileScopes;
                        if (fileScopes != null) break block3;
                    }
                    object = FileScopeFactory.createScopesForFile$default(fileScopeFactory, this.$ktFile, null, false, 6, null);
                }
                return object;
            }
        });
    }

    public final void lineSuccess(@NotNull KtFile ktFile, @NotNull ScriptDescriptor scriptDescriptor) {
        Intrinsics.checkNotNullParameter(ktFile, "ktFile");
        Intrinsics.checkNotNullParameter(scriptDescriptor, "scriptDescriptor");
        LineInfo.SuccessfulLine successfulLine = new LineInfo.SuccessfulLine(ktFile, (LineInfo.SuccessfulLine)CollectionsKt.lastOrNull((List)this.successfulLines), scriptDescriptor);
        ((Map)this.lines).put(ktFile, successfulLine);
        this.successfulLines.add(successfulLine);
    }

    public final void lineFailure(@NotNull KtFile ktFile) {
        Intrinsics.checkNotNullParameter(ktFile, "ktFile");
        ((Map)this.lines).put(ktFile, new LineInfo.FailedLine(ktFile, (LineInfo.SuccessfulLine)CollectionsKt.lastOrNull((List)this.successfulLines)));
    }

    private final LineInfo lineInfo(KtFile ktFile) {
        return this.lines.get(ktFile);
    }

    private final FileScopes computeFileScopes(LineInfo lineInfo, FileScopeFactory fileScopeFactory) {
        HierarchicalScope element$iv;
        Object lexicalScopeAfterLastLine;
        block2: {
            LineInfo.SuccessfulLine successfulLine = lineInfo.getParentLine();
            ScriptDescriptor scriptDescriptor = successfulLine != null ? successfulLine.getLineDescriptor() : null;
            Object object = scriptDescriptor instanceof ClassDescriptorWithResolutionScopes ? (ClassDescriptorWithResolutionScopes)((Object)scriptDescriptor) : null;
            if (object == null || (object = object.getScopeForInitializerResolution()) == null) {
                return null;
            }
            lexicalScopeAfterLastLine = object;
            Sequence<HierarchicalScope> $this$firstIsInstance$iv = ScopeUtilsKt.getParentsWithSelf((HierarchicalScope)lexicalScopeAfterLastLine);
            boolean $i$f$firstIsInstance = false;
            Iterator<HierarchicalScope> iterator2 = $this$firstIsInstance$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                if (!(element$iv instanceof ImportingScope)) continue;
                break block2;
            }
            throw new NoSuchElementException("No element of given type found");
        }
        ImportingScope lastLineImports = (ImportingScope)element$iv;
        FileScopes scopesForThisLine = FileScopeFactory.createScopesForFile$default(fileScopeFactory, lineInfo.getLinePsi(), lastLineImports, false, 4, null);
        LexicalScope combinedLexicalScopes = ScopeUtilsKt.replaceImportingScopes((LexicalScope)lexicalScopeAfterLastLine, scopesForThisLine.getImportingScope());
        return new FileScopes(combinedLexicalScopes, scopesForThisLine.getImportingScope(), scopesForThisLine.getImportForceResolver());
    }

    public static final /* synthetic */ LineInfo access$lineInfo(ReplState $this, KtFile ktFile) {
        return $this.lineInfo(ktFile);
    }

    public static final /* synthetic */ FileScopes access$computeFileScopes(ReplState $this, LineInfo lineInfo, FileScopeFactory fileScopeFactory) {
        return $this.computeFileScopes(lineInfo, fileScopeFactory);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0003\u000e\u000f\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo;", "", "()V", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "getParentLine", "()Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "FailedLine", "SubmittedLine", "SuccessfulLine", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$FailedLine;", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SubmittedLine;", "frontend"})
    private static abstract class LineInfo {
        private LineInfo() {
        }

        @NotNull
        public abstract KtFile getLinePsi();

        @Nullable
        public abstract SuccessfulLine getParentLine();

        public /* synthetic */ LineInfo(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "lineDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;)V", "getLineDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getParentLine", "()Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "frontend"})
        public static final class SuccessfulLine
        extends LineInfo {
            @NotNull
            private final KtFile linePsi;
            @Nullable
            private final SuccessfulLine parentLine;
            @NotNull
            private final ScriptDescriptor lineDescriptor;

            public SuccessfulLine(@NotNull KtFile linePsi, @Nullable SuccessfulLine parentLine, @NotNull ScriptDescriptor lineDescriptor) {
                Intrinsics.checkNotNullParameter(linePsi, "linePsi");
                Intrinsics.checkNotNullParameter(lineDescriptor, "lineDescriptor");
                super(null);
                this.linePsi = linePsi;
                this.parentLine = parentLine;
                this.lineDescriptor = lineDescriptor;
            }

            @Override
            @NotNull
            public KtFile getLinePsi() {
                return this.linePsi;
            }

            @Override
            @Nullable
            public SuccessfulLine getParentLine() {
                return this.parentLine;
            }

            @NotNull
            public final ScriptDescriptor getLineDescriptor() {
                return this.lineDescriptor;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SubmittedLine;", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;)V", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getParentLine", "()Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "frontend"})
        public static final class SubmittedLine
        extends LineInfo {
            @NotNull
            private final KtFile linePsi;
            @Nullable
            private final SuccessfulLine parentLine;

            public SubmittedLine(@NotNull KtFile linePsi, @Nullable SuccessfulLine parentLine) {
                Intrinsics.checkNotNullParameter(linePsi, "linePsi");
                super(null);
                this.linePsi = linePsi;
                this.parentLine = parentLine;
            }

            @Override
            @NotNull
            public KtFile getLinePsi() {
                return this.linePsi;
            }

            @Override
            @Nullable
            public SuccessfulLine getParentLine() {
                return this.parentLine;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$FailedLine;", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;)V", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getParentLine", "()Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "frontend"})
        public static final class FailedLine
        extends LineInfo {
            @NotNull
            private final KtFile linePsi;
            @Nullable
            private final SuccessfulLine parentLine;

            public FailedLine(@NotNull KtFile linePsi, @Nullable SuccessfulLine parentLine) {
                Intrinsics.checkNotNullParameter(linePsi, "linePsi");
                super(null);
                this.linePsi = linePsi;
                this.parentLine = parentLine;
            }

            @Override
            @NotNull
            public KtFile getLinePsi() {
                return this.linePsi;
            }

            @Override
            @Nullable
            public SuccessfulLine getParentLine() {
                return this.parentLine;
            }
        }
    }
}

