/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;", "", "()V", "declarationsWithResolvedAnnotations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "filesWithResolvedImports", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "annotationsAreResolved", "", "declaration", "importsAreResolved", "file", "recordThatAnnotationsAreResolved", "", "recordThatImportsAreResolved", "resolve"})
public final class CompilerRequiredAnnotationsComputationSession {
    @NotNull
    private final Set<FirFile> filesWithResolvedImports = new LinkedHashSet();
    @NotNull
    private final Set<FirDeclaration> declarationsWithResolvedAnnotations = new LinkedHashSet();

    public final boolean importsAreResolved(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return this.filesWithResolvedImports.contains(file2);
    }

    public final void recordThatImportsAreResolved(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        if (!this.filesWithResolvedImports.add(file2)) {
            throw new IllegalStateException("Imports are resolved twice".toString());
        }
    }

    public final boolean annotationsAreResolved(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (declaration instanceof FirFile) {
            return false;
        }
        if (!Intrinsics.areEqual(declaration.getOrigin(), FirDeclarationOrigin.Source.INSTANCE)) {
            return true;
        }
        return this.declarationsWithResolvedAnnotations.contains(declaration);
    }

    public final void recordThatAnnotationsAreResolved(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!this.declarationsWithResolvedAnnotations.add(declaration)) {
            throw new IllegalStateException("Annotations are resolved twice".toString());
        }
    }
}

