/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlatformUtils {
    private static final Set<String> COMMERCIAL_EDITIONS = new HashSet<String>(Arrays.asList("idea", "AppCode", "CLion", "MobileIDE", "Python", "Ruby", "PhpStorm", "WebStorm", "DataGrip", "Rider", "GoLand"));

    @NotNull
    public static String getPlatformPrefix() {
        String string2 = PlatformUtils.getPlatformPrefix("idea");
        if (string2 == null) {
            PlatformUtils.$$$reportNull$$$0(0);
        }
        return string2;
    }

    public static String getPlatformPrefix(@Nullable String defaultPrefix) {
        return System.getProperty("idea.platform.prefix", defaultPrefix);
    }

    public static boolean isIntelliJ() {
        return PlatformUtils.isIdeaUltimate() || PlatformUtils.isIdeaCommunity() || PlatformUtils.isIdeaEducational();
    }

    public static boolean isIdeaUltimate() {
        return PlatformUtils.is("idea");
    }

    public static boolean isIdeaCommunity() {
        return PlatformUtils.is("Idea");
    }

    public static boolean isIdeaEducational() {
        return PlatformUtils.is("IdeaEdu");
    }

    private static boolean is(@NotNull String idePrefix) {
        if (idePrefix == null) {
            PlatformUtils.$$$reportNull$$$0(1);
        }
        return idePrefix.equals(PlatformUtils.getPlatformPrefix());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/PlatformUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformPrefix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/PlatformUtils";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

