/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializerKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoBufUtilKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirConstDeserializer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "constantCache", "", "Lorg/jetbrains/kotlin/name/CallableId;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getConstantCache", "()Ljava/util/Map;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "loadConstant", "propertyProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "callableId", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "fir-deserialization"})
public class FirConstDeserializer {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Map<CallableId, FirExpression> constantCache;

    public FirConstDeserializer(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        this.session = session2;
        this.constantCache = new LinkedHashMap();
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    protected final Map<CallableId, FirExpression> getConstantCache() {
        return this.constantCache;
    }

    @Nullable
    public FirExpression loadConstant(@NotNull ProtoBuf.Property propertyProto, @NotNull CallableId callableId, @NotNull NameResolver nameResolver2) {
        FirExpression firExpression2;
        Intrinsics.checkNotNullParameter(propertyProto, "propertyProto");
        Intrinsics.checkNotNullParameter(callableId, "callableId");
        Intrinsics.checkNotNullParameter(nameResolver2, "nameResolver");
        if (!Flags.HAS_CONSTANT.get(propertyProto.getFlags()).booleanValue()) {
            return null;
        }
        FirExpression firExpression3 = this.constantCache.get(callableId);
        if (firExpression3 != null) {
            FirExpression it = firExpression3;
            boolean bl = false;
            return it;
        }
        ProtoBuf.Annotation.Argument.Value value2 = ProtoBufUtilKt.getExtensionOrNull(propertyProto, BuiltInSerializerProtocol.INSTANCE.getCompileTimeValue());
        if (value2 == null) {
            return null;
        }
        ProtoBuf.Annotation.Argument.Value value3 = value2;
        FirExpression firExpression4 = FirConstDeserializerKt.buildFirConstant(value3, null, value3.getType().name(), nameResolver2);
        if (firExpression4 != null) {
            FirExpression firExpression5;
            FirExpression it = firExpression5 = firExpression4;
            boolean bl = false;
            this.constantCache.put(callableId, it);
            firExpression2 = firExpression5;
        } else {
            firExpression2 = null;
        }
        return firExpression2;
    }
}

