/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphBuilderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.JvmNames;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirOverloadsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirOverloadsChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirOverloadsChecker INSTANCE = new FirOverloadsChecker();

    private FirOverloadsChecker() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        FirAnnotation annotation2;
        block19: {
            FirDeclaration it;
            FirClassLikeSymbol<?> containingDeclaration;
            block22: {
                block21: {
                    boolean bl2;
                    block18: {
                        block20: {
                            Intrinsics.checkNotNullParameter(declaration, "declaration");
                            Intrinsics.checkNotNullParameter(context, "context");
                            Intrinsics.checkNotNullParameter(reporter, "reporter");
                            FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JvmNames.INSTANCE.getJVM_OVERLOADS_CLASS_ID());
                            if (firAnnotation == null) {
                                return;
                            }
                            annotation2 = firAnnotation;
                            FirMemberDeclaration $this$isActual$iv = declaration;
                            boolean $i$f$isActual = false;
                            if ($this$isActual$iv.getStatus().isActual()) {
                                return;
                            }
                            containingDeclaration = FirHelpersKt.getContainingClassSymbol(declaration, context.getSession());
                            FirClassLikeSymbol<?> firClassLikeSymbol = containingDeclaration;
                            if ((firClassLikeSymbol != null ? FirHelpersKt.getClassKind(firClassLikeSymbol) : null) == ClassKind.INTERFACE) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_INTERFACE(), (DiagnosticContext)context, null, 8, null);
                                return;
                            }
                            FirMemberDeclaration $this$isAbstract$iv = declaration;
                            boolean $i$f$isAbstract = false;
                            if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_ABSTRACT(), (DiagnosticContext)context, null, 8, null);
                                return;
                            }
                            if (!(declaration instanceof FirSimpleFunction)) break block20;
                            FirSimpleFunction $this$isLocal$iv = (FirSimpleFunction)declaration;
                            boolean $i$f$isLocal = false;
                            if (Intrinsics.areEqual($this$isLocal$iv.getStatus().getVisibility(), Visibilities.Local.INSTANCE)) break block21;
                        }
                        Iterable $this$any$iv = context.getContainingDeclarations();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (FirDeclaration)element$iv;
                                boolean bl3 = false;
                                if (!ControlFlowGraphBuilderKt.isLocalClassOrAnonymousObject(it)) continue;
                                bl2 = true;
                                break block18;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) break block22;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_LOCAL(), (DiagnosticContext)context, null, 8, null);
                return;
            }
            if (declaration instanceof FirConstructor) {
                FirClassLikeSymbol<?> firClassLikeSymbol = containingDeclaration;
                if ((firClassLikeSymbol != null ? FirHelpersKt.getClassKind(firClassLikeSymbol) : null) == ClassKind.ANNOTATION_CLASS) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_ANNOTATION_CLASS_CONSTRUCTOR(), (DiagnosticContext)context, null, 8, null);
                    return;
                }
            }
            FirMemberDeclaration $this$visibility$iv = declaration;
            boolean $i$f$getVisibility = false;
            if (!$this$visibility$iv.getStatus().getVisibility().isPublicAPI()) {
                $this$visibility$iv = declaration;
                $i$f$getVisibility = false;
                if (!Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Internal.INSTANCE)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_PRIVATE(), (DiagnosticContext)context, null, 8, null);
                    return;
                }
            }
            Iterable $this$none$iv = declaration.getValueParameters();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (FirValueParameter)element$iv;
                    boolean bl4 = false;
                    if (!(((FirValueParameter)it).getDefaultValue() != null)) continue;
                    bl = false;
                    break block19;
                }
                bl = true;
            }
        }
        if (!bl) return;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirJvmErrors.INSTANCE.getOVERLOADS_WITHOUT_DEFAULT_ARGUMENTS(), (DiagnosticContext)context, null, 8, null);
    }
}

