/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.BasicReplStageHistory;
import org.jetbrains.kotlin.cli.common.repl.ILineId;
import org.jetbrains.kotlin.cli.common.repl.IReplStageHistory;
import org.jetbrains.kotlin.cli.common.repl.ReplHistoryRecord;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\u000f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004H\u0016J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0004R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/cli/common/repl/BasicReplStageHistory;", "T", "Lorg/jetbrains/kotlin/cli/common/repl/IReplStageHistory;", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplHistoryRecord;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "(Ljava/util/concurrent/locks/ReentrantReadWriteLock;)V", "currentGeneration", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCurrentGeneration", "()Ljava/util/concurrent/atomic/AtomicInteger;", "currentLineNumber", "getCurrentLineNumber", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "pop", "push", "", "id", "Lorg/jetbrains/kotlin/cli/common/repl/ILineId;", "item", "(Lorg/jetbrains/kotlin/cli/common/repl/ILineId;Ljava/lang/Object;)V", "reset", "", "resetTo", "tryResetTo", "", "cli-common"})
public class BasicReplStageHistory<T>
extends ArrayList<ReplHistoryRecord<? extends T>>
implements IReplStageHistory<T> {
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final AtomicInteger currentLineNumber;
    @NotNull
    private final AtomicInteger currentGeneration;

    public BasicReplStageHistory(@NotNull ReentrantReadWriteLock lock) {
        Intrinsics.checkNotNullParameter(lock, "lock");
        this.lock = lock;
        this.currentLineNumber = new AtomicInteger(0);
        this.currentGeneration = new AtomicInteger(1);
    }

    public /* synthetic */ BasicReplStageHistory(ReentrantReadWriteLock reentrantReadWriteLock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            reentrantReadWriteLock = new ReentrantReadWriteLock();
        }
        this(reentrantReadWriteLock);
    }

    @Override
    @NotNull
    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    @NotNull
    public final AtomicInteger getCurrentLineNumber() {
        return this.currentLineNumber;
    }

    @NotNull
    public final AtomicInteger getCurrentGeneration() {
        return this.currentGeneration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(@NotNull ILineId id, T item) {
        Intrinsics.checkNotNullParameter(id, "id");
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.add(new ReplHistoryRecord<T>(id, item));
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ReplHistoryRecord<T> pop() {
        ReplHistoryRecord replHistoryRecord;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            replHistoryRecord = this.isEmpty() ? null : (ReplHistoryRecord)this.remove(CollectionsKt.getLastIndex(this));
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return replHistoryRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<ILineId> reset() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ReplHistoryRecord replHistoryRecord = (ReplHistoryRecord)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getId());
            }
            List removed2 = (List)destination$iv$iv;
            this.clear();
            this.currentGeneration.incrementAndGet();
            this.currentLineNumber.set(0);
            Iterable iterable2 = removed2;
            return iterable2;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Iterable<ILineId> resetTo(@NotNull ILineId id) {
        Intrinsics.checkNotNullParameter(id, "id");
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            List<ILineId> list2 = this.tryResetTo(id);
            if (list2 == null) {
                throw new NoSuchElementException("Cannot reset to non-existent line " + id.getNo());
            }
            Iterable iterable = list2;
            return iterable;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final List<ILineId> tryResetTo(@NotNull ILineId id) {
        List<ILineId> list2;
        int idx;
        block6: {
            int n;
            Intrinsics.checkNotNullParameter(id, "id");
            List $this$indexOfFirst$iv = this;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                ReplHistoryRecord it = (ReplHistoryRecord)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual(it.getId(), id)) {
                    n = index$iv;
                    break block6;
                }
                ++index$iv;
            }
            n = idx = -1;
        }
        if (idx < 0) {
            return null;
        }
        if (idx < CollectionsKt.getLastIndex(this)) {
            void var3_2;
            List removed2 = SequencesKt.toList(SequencesKt.map(SequencesKt.drop(CollectionsKt.asSequence(this), idx + 1), tryResetTo.removed.1.INSTANCE));
            this.removeRange(idx + 1, this.size());
            this.currentGeneration.incrementAndGet();
            ILineId iLineId = (ILineId)CollectionsKt.lastOrNull(removed2);
            if (iLineId != null) {
                int it = iLineId.getNo();
                boolean bl = false;
                this.currentLineNumber.set(it);
            }
            list2 = var3_2;
        } else {
            this.currentGeneration.incrementAndGet();
            this.currentLineNumber.set(id.getNo() + 1);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public BasicReplStageHistory() {
        this(null, 1, null);
    }
}

