/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticMarker;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "E", "Lcom/intellij/psi/PsiElement;", "", "()V", "isValid", "", "element", "(Lcom/intellij/psi/PsiElement;)Z", "mark", "", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "markDiagnostic", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticMarker;", "frontend.common-psi"})
public class PositioningStrategy<E extends PsiElement> {
    @NotNull
    public List<TextRange> markDiagnostic(@NotNull DiagnosticMarker diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        PsiElement psiElement = diagnostic.getPsiElement();
        Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type E of org.jetbrains.kotlin.diagnostics.PositioningStrategy");
        return this.mark(psiElement);
    }

    @NotNull
    public List<TextRange> mark(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return PositioningStrategyKt.markElement(element);
    }

    public boolean isValid(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return !PositioningStrategyKt.hasSyntaxErrors(element);
    }
}

