/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.java;

import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.Key;
import com.intellij.util.lang.JavaVersion;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LanguageLevel {
    JDK_1_3(JavaPsiBundle.messagePointer("jdk.1.3.language.level.description", new Object[0]), 3),
    JDK_1_4(JavaPsiBundle.messagePointer("jdk.1.4.language.level.description", new Object[0]), 4),
    JDK_1_5(JavaPsiBundle.messagePointer("jdk.1.5.language.level.description", new Object[0]), 5),
    JDK_1_6(JavaPsiBundle.messagePointer("jdk.1.6.language.level.description", new Object[0]), 6),
    JDK_1_7(JavaPsiBundle.messagePointer("jdk.1.7.language.level.description", new Object[0]), 7),
    JDK_1_8(JavaPsiBundle.messagePointer("jdk.1.8.language.level.description", new Object[0]), 8),
    JDK_1_9(JavaPsiBundle.messagePointer("jdk.1.9.language.level.description", new Object[0]), 9),
    JDK_10(JavaPsiBundle.messagePointer("jdk.10.language.level.description", new Object[0]), 10),
    JDK_11(JavaPsiBundle.messagePointer("jdk.11.language.level.description", new Object[0]), 11),
    JDK_12(JavaPsiBundle.messagePointer("jdk.12.language.level.description", new Object[0]), 12),
    JDK_13(JavaPsiBundle.messagePointer("jdk.13.language.level.description", new Object[0]), 13),
    JDK_14(JavaPsiBundle.messagePointer("jdk.14.language.level.description", new Object[0]), 14),
    JDK_14_PREVIEW(JavaPsiBundle.messagePointer("jdk.14.preview.language.level.description", new Object[0]), 14),
    JDK_15(JavaPsiBundle.messagePointer("jdk.15.language.level.description", new Object[0]), 15),
    JDK_15_PREVIEW(JavaPsiBundle.messagePointer("jdk.15.preview.language.level.description", new Object[0]), 15),
    JDK_X(JavaPsiBundle.messagePointer("jdk.X.language.level.description", new Object[0]), 16);

    public static final LanguageLevel HIGHEST;
    public static final Key<LanguageLevel> KEY;
    private final Supplier<@Nls String> myPresentableText;
    private final JavaVersion myVersion;
    private final boolean myPreview;

    private LanguageLevel(Supplier<String> presentableTextSupplier, int major) {
        this.myPresentableText = presentableTextSupplier;
        this.myVersion = JavaVersion.compose(major);
        this.myPreview = this.name().endsWith("_PREVIEW");
    }

    public boolean isPreview() {
        return this.myPreview;
    }

    @Nullable
    public LanguageLevel getPreviewLevel() {
        if (this.myPreview) {
            return this;
        }
        try {
            return LanguageLevel.valueOf(this.name() + "_PREVIEW");
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean isAtLeast(@NotNull LanguageLevel level) {
        if (level == null) {
            LanguageLevel.$$$reportNull$$$0(1);
        }
        return this.compareTo(level) >= 0;
    }

    @NotNull
    public JavaVersion toJavaVersion() {
        JavaVersion javaVersion = this.myVersion;
        if (javaVersion == null) {
            LanguageLevel.$$$reportNull$$$0(3);
        }
        return javaVersion;
    }

    @Nullable
    public static LanguageLevel parse(@Nullable String compilerComplianceOption) {
        JavaSdkVersion sdkVersion;
        if (compilerComplianceOption != null && (sdkVersion = JavaSdkVersion.fromVersionString(compilerComplianceOption)) != null) {
            return sdkVersion.getMaxLanguageLevel();
        }
        return null;
    }

    static {
        HIGHEST = JDK_15;
        KEY = Key.create("LANGUAGE_LEVEL");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/pom/java/LanguageLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/pom/java/LanguageLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toJavaVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isLessThan";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

