/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\f\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0002\u001a\u001b\u0010\u000f\u001a\u00020\u0010*\u00020\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\u001a\n\u0010\u0011\u001a\u00020\u0010*\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0010*\u00020\u0002\u001a\u001a\u0010\u0013\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015\u001a\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u00f2\u0001\u0004\n\u00020\u0004\u00a8\u0006\u0019"}, d2={"containingPackage", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findContinuationClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "lookupLocation", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "findContinuationClassDescriptorOrNull", "getContinuationOfTypeOrAny", "Lorg/jetbrains/kotlin/types/SimpleType;", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getTopLevelContainingClassifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "isSealed", "", "isSupportedForCallableReference", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isTopLevelInPackage", "name", "", "packageName", "resolveClassByFqName", "fqName", "descriptors"})
public final class DescriptorUtilKt {
    @Nullable
    public static final ClassDescriptor resolveClassByFqName(@NotNull ModuleDescriptor $this$resolveClassByFqName, @NotNull FqName fqName2, @NotNull LookupLocation lookupLocation) {
        ClassifierDescriptor classifierDescriptor;
        MemberScope memberScope2;
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter($this$resolveClassByFqName, "<this>");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(lookupLocation, "lookupLocation");
        if (fqName2.isRoot()) {
            return null;
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue(fqName3, "fqName.parent()");
        MemberScope memberScope3 = $this$resolveClassByFqName.getPackage(fqName3).getMemberScope();
        Name name = fqName2.shortName();
        Intrinsics.checkNotNullExpressionValue(name, "fqName.shortName()");
        ClassifierDescriptor classifierDescriptor2 = memberScope3.getContributedClassifier(name, lookupLocation);
        ClassDescriptor classDescriptor2 = classDescriptor = classifierDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor2 : null;
        if (classDescriptor != null) {
            ClassDescriptor it = classDescriptor;
            boolean bl = false;
            return it;
        }
        FqName fqName4 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue(fqName4, "fqName.parent()");
        classifierDescriptor2 = DescriptorUtilKt.resolveClassByFqName($this$resolveClassByFqName, fqName4, lookupLocation);
        if (classifierDescriptor2 != null && (memberScope2 = classifierDescriptor2.getUnsubstitutedInnerClassesScope()) != null) {
            Name name2 = fqName2.shortName();
            Intrinsics.checkNotNullExpressionValue(name2, "fqName.shortName()");
            classifierDescriptor = memberScope2.getContributedClassifier(name2, lookupLocation);
        } else {
            classifierDescriptor = null;
        }
        classDescriptor = classifierDescriptor;
        return classDescriptor instanceof ClassDescriptor ? classDescriptor : null;
    }

    @Nullable
    public static final ClassDescriptor findContinuationClassDescriptorOrNull(@NotNull ModuleDescriptor $this$findContinuationClassDescriptorOrNull, @NotNull LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter($this$findContinuationClassDescriptorOrNull, "<this>");
        Intrinsics.checkNotNullParameter(lookupLocation, "lookupLocation");
        return DescriptorUtilKt.resolveClassByFqName($this$findContinuationClassDescriptorOrNull, StandardNames.CONTINUATION_INTERFACE_FQ_NAME, lookupLocation);
    }

    @NotNull
    public static final ClassDescriptor findContinuationClassDescriptor(@NotNull ModuleDescriptor $this$findContinuationClassDescriptor, @NotNull LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter($this$findContinuationClassDescriptor, "<this>");
        Intrinsics.checkNotNullParameter(lookupLocation, "lookupLocation");
        ClassDescriptor $this$sure$iv = DescriptorUtilKt.findContinuationClassDescriptorOrNull($this$findContinuationClassDescriptor, lookupLocation);
        boolean $i$f$sure = false;
        ClassDescriptor classDescriptor = $this$sure$iv;
        if (classDescriptor == null) {
            boolean bl = false;
            String string2 = "Continuation interface is not found";
            throw new AssertionError((Object)string2);
        }
        return classDescriptor;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final SimpleType getContinuationOfTypeOrAny(@NotNull ModuleDescriptor $this$getContinuationOfTypeOrAny, @NotNull KotlinType kotlinType) {
        SimpleType simpleType2;
        SimpleType simpleType3;
        Intrinsics.checkNotNullParameter($this$getContinuationOfTypeOrAny, "<this>");
        Intrinsics.checkNotNullParameter(kotlinType, "kotlinType");
        ClassDescriptor classDescriptor = DescriptorUtilKt.findContinuationClassDescriptorOrNull(DescriptorUtilsKt.getModule($this$getContinuationOfTypeOrAny), NoLookupLocation.FROM_DESERIALIZATION);
        if (classDescriptor != null && (simpleType3 = classDescriptor.getDefaultType()) != null) {
            SimpleType it = simpleType3;
            boolean bl = false;
            SimpleType simpleType4 = KotlinTypeFactory.simpleType$default(it, null, null, CollectionsKt.listOf(TypeUtilsKt.asTypeProjection(kotlinType)), false, 22, null);
            if (simpleType4 != null) {
                simpleType2 = simpleType4;
                return simpleType2;
            }
        }
        SimpleType simpleType5 = DescriptorUtilsKt.getModule($this$getContinuationOfTypeOrAny).getBuiltIns().getNullableAnyType();
        simpleType2 = simpleType5;
        Intrinsics.checkNotNullExpressionValue(simpleType5, "module.builtIns.nullableAnyType");
        return simpleType2;
    }

    public static final boolean isTopLevelInPackage(@NotNull DeclarationDescriptor $this$isTopLevelInPackage, @NotNull String name, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter($this$isTopLevelInPackage, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        if (!Intrinsics.areEqual(name, $this$isTopLevelInPackage.getName().asString())) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = $this$isTopLevelInPackage.getContainingDeclaration();
        PackageFragmentDescriptor packageFragmentDescriptor = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
        if (packageFragmentDescriptor == null) {
            return false;
        }
        PackageFragmentDescriptor containingDeclaration = packageFragmentDescriptor;
        String string2 = containingDeclaration.getFqName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "containingDeclaration.fqName.asString()");
        String packageFqName = string2;
        return Intrinsics.areEqual(packageName, packageFqName);
    }

    public static final boolean isTopLevelInPackage(@NotNull DeclarationDescriptor $this$isTopLevelInPackage) {
        Intrinsics.checkNotNullParameter($this$isTopLevelInPackage, "<this>");
        return $this$isTopLevelInPackage.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    @Nullable
    public static final ClassifierDescriptor getTopLevelContainingClassifier(@NotNull DeclarationDescriptor $this$getTopLevelContainingClassifier) {
        Intrinsics.checkNotNullParameter($this$getTopLevelContainingClassifier, "<this>");
        DeclarationDescriptor containingDeclaration = $this$getTopLevelContainingClassifier.getContainingDeclaration();
        if (containingDeclaration == null || $this$getTopLevelContainingClassifier instanceof PackageFragmentDescriptor) {
            return null;
        }
        return !DescriptorUtilKt.isTopLevelInPackage(containingDeclaration) ? DescriptorUtilKt.getTopLevelContainingClassifier(containingDeclaration) : (containingDeclaration instanceof ClassifierDescriptor ? (ClassifierDescriptor)containingDeclaration : null);
    }

    public static final boolean isSupportedForCallableReference(@NotNull CallableDescriptor $this$isSupportedForCallableReference) {
        Intrinsics.checkNotNullParameter($this$isSupportedForCallableReference, "<this>");
        return $this$isSupportedForCallableReference instanceof PropertyDescriptor || $this$isSupportedForCallableReference instanceof FunctionDescriptor;
    }

    public static final boolean isSealed(@NotNull DeclarationDescriptor $this$isSealed) {
        Intrinsics.checkNotNullParameter($this$isSealed, "<this>");
        return DescriptorUtils.isSealedClass($this$isSealed);
    }

    @Nullable
    public static final FqName containingPackage(@NotNull DeclarationDescriptor $this$containingPackage) {
        DeclarationDescriptor container;
        Intrinsics.checkNotNullParameter($this$containingPackage, "<this>");
        for (container = $this$containingPackage.getContainingDeclaration(); container != null && !(container instanceof PackageFragmentDescriptor); container = container.getContainingDeclaration()) {
        }
        DeclarationDescriptor declarationDescriptor = container;
        if (!(declarationDescriptor == null ? true : declarationDescriptor instanceof PackageFragmentDescriptor)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)container;
        return packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null;
    }
}

