/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.IrTypeMapper;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrPublicSymbolBase;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0003\u0019\u001a\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J\f\u0010\u0017\u001a\u00020\b*\u00020\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isObjectEquals", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "getOperandsIfCallToEQEQOrEquals", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "parseSafeCall", "Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$SafeCallInfo;", "expression", "isJvmPrimitive", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Companion", "SafeCallInfo", "Transformer", "backend.jvm.lower"})
public final class JvmOptimizationLowering
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;

    public JvmOptimizationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    private final boolean isObjectEquals(IrFunction $this$isObjectEquals) {
        return Intrinsics.areEqual($this$isObjectEquals.getName().asString(), "equals") && ((Collection)$this$isObjectEquals.getValueParameters()).size() == 1 && IrTypePredicatesKt.isNullableAny($this$isObjectEquals.getValueParameters().get(0).getType()) && $this$isObjectEquals.getExtensionReceiverParameter() == null && $this$isObjectEquals.getDispatchReceiverParameter() != null;
    }

    private final Pair<IrExpression, IrExpression> getOperandsIfCallToEQEQOrEquals(IrCall call2) {
        Pair<IrExpression, IrExpression> pair;
        if (Intrinsics.areEqual(call2.getSymbol(), this.context.getIrBuiltIns().getEqeqSymbol())) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull(irExpression);
            IrExpression left = irExpression;
            IrExpression irExpression2 = call2.getValueArgument(1);
            Intrinsics.checkNotNull(irExpression2);
            IrExpression right = irExpression2;
            pair = TuplesKt.to(left, right);
        } else if (this.isObjectEquals((IrFunction)call2.getSymbol().getOwner())) {
            IrExpression irExpression = call2.getDispatchReceiver();
            Intrinsics.checkNotNull(irExpression);
            IrExpression left = irExpression;
            IrExpression irExpression3 = call2.getValueArgument(0);
            Intrinsics.checkNotNull(irExpression3);
            IrExpression right = irExpression3;
            pair = TuplesKt.to(left, right);
        } else {
            pair = null;
        }
        return pair;
    }

    private final SafeCallInfo parseSafeCall(IrExpression expression2) {
        IrWhen irWhen;
        IrVariable irVariable2;
        IrBlock irBlock;
        IrBlock irBlock2 = irBlock = expression2 instanceof IrBlock ? (IrBlock)expression2 : null;
        if (irBlock == null) {
            return null;
        }
        IrBlock block = irBlock;
        if (!Intrinsics.areEqual(block.getOrigin(), IrStatementOrigin.SAFE_CALL.INSTANCE)) {
            return null;
        }
        if (block.getStatements().size() != 2) {
            return null;
        }
        IrStatement irStatement = block.getStatements().get(0);
        IrVariable irVariable3 = irVariable2 = irStatement instanceof IrVariable ? (IrVariable)irStatement : null;
        if (irVariable2 == null) {
            return null;
        }
        IrVariable tmpVal = irVariable2;
        IrDeclarationParent irDeclarationParent = tmpVal.getParent();
        IrStatement irStatement2 = irStatement = irDeclarationParent instanceof IrDeclaration ? (IrDeclaration)((Object)irDeclarationParent) : null;
        if (irStatement == null) {
            return null;
        }
        IrStatement scopeOwner = irStatement;
        IrSymbol scopeSymbol = scopeOwner.getSymbol();
        IrStatement irStatement3 = block.getStatements().get(1);
        IrWhen irWhen2 = irWhen = irStatement3 instanceof IrWhen ? (IrWhen)irStatement3 : null;
        if (irWhen == null) {
            return null;
        }
        IrWhen whenExpr = irWhen;
        if (whenExpr.getBranches().size() != 2) {
            return null;
        }
        IrBranch ifNullBranch = whenExpr.getBranches().get(0);
        IrExpression ifNullBranchCondition = ifNullBranch.getCondition();
        if (!(ifNullBranchCondition instanceof IrCall)) {
            return null;
        }
        if (!Intrinsics.areEqual(((IrCall)ifNullBranchCondition).getSymbol(), this.context.getIrBuiltIns().getEqeqSymbol())) {
            return null;
        }
        IrExpression arg0 = ((IrCall)ifNullBranchCondition).getValueArgument(0);
        if (!(arg0 instanceof IrGetValue) || !Intrinsics.areEqual(((IrGetValue)arg0).getSymbol(), tmpVal.getSymbol())) {
            return null;
        }
        IrExpression arg1 = ((IrCall)ifNullBranchCondition).getValueArgument(1);
        if (!(arg1 instanceof IrConst) || ((IrConst)arg1).getValue() != null) {
            return null;
        }
        IrExpression ifNullBranchResult = ifNullBranch.getResult();
        if (!(ifNullBranchResult instanceof IrConst) || ((IrConst)ifNullBranchResult).getValue() != null) {
            return null;
        }
        IrBranch ifNotNullBranch = whenExpr.getBranches().get(1);
        return new SafeCallInfo(scopeSymbol, tmpVal, ifNullBranch, ifNotNullBranch);
    }

    private final boolean isJvmPrimitive(IrType $this$isJvmPrimitive) {
        return AsmUtil.isPrimitive(IrTypeMapper.mapType$default(this.context.getTypeMapper(), $this$isJvmPrimitive, null, null, 6, null));
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        irFile.transformChildren(new Transformer(), null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Companion;", "", "()V", "isNegation", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "backend.jvm.lower"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isNegation(@NotNull IrExpression expression2, @NotNull JvmBackendContext context2) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol;
            IrPublicSymbolBase irPublicSymbolBase;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context2, "context");
            return expression2 instanceof IrCall && Intrinsics.areEqual((irPublicSymbolBase = (irSimpleFunctionSymbol = ((IrCall)expression2).getSymbol()) instanceof IrPublicSymbolBase ? (IrPublicSymbolBase)((Object)irSimpleFunctionSymbol) : null) == null ? null : irPublicSymbolBase.getSignature(), context2.getIrBuiltIns().getBooleanNotSymbol().getSignature());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$SafeCallInfo;", "", "scopeSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "tmpVal", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "ifNullBranch", "Lorg/jetbrains/kotlin/ir/expressions/IrBranch;", "ifNotNullBranch", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;Lorg/jetbrains/kotlin/ir/declarations/IrVariable;Lorg/jetbrains/kotlin/ir/expressions/IrBranch;Lorg/jetbrains/kotlin/ir/expressions/IrBranch;)V", "getIfNotNullBranch", "()Lorg/jetbrains/kotlin/ir/expressions/IrBranch;", "getIfNullBranch", "getScopeSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getTmpVal", "()Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "backend.jvm.lower"})
    private static final class SafeCallInfo {
        @NotNull
        private final IrSymbol scopeSymbol;
        @NotNull
        private final IrVariable tmpVal;
        @NotNull
        private final IrBranch ifNullBranch;
        @NotNull
        private final IrBranch ifNotNullBranch;

        public SafeCallInfo(@NotNull IrSymbol scopeSymbol, @NotNull IrVariable tmpVal, @NotNull IrBranch ifNullBranch, @NotNull IrBranch ifNotNullBranch) {
            Intrinsics.checkNotNullParameter(scopeSymbol, "scopeSymbol");
            Intrinsics.checkNotNullParameter(tmpVal, "tmpVal");
            Intrinsics.checkNotNullParameter(ifNullBranch, "ifNullBranch");
            Intrinsics.checkNotNullParameter(ifNotNullBranch, "ifNotNullBranch");
            this.scopeSymbol = scopeSymbol;
            this.tmpVal = tmpVal;
            this.ifNullBranch = ifNullBranch;
            this.ifNotNullBranch = ifNotNullBranch;
        }

        @NotNull
        public final IrSymbol getScopeSymbol() {
            return this.scopeSymbol;
        }

        @NotNull
        public final IrVariable getTmpVal() {
            return this.tmpVal;
        }

        @NotNull
        public final IrBranch getIfNullBranch() {
            return this.ifNullBranch;
        }

        @NotNull
        public final IrBranch getIfNotNullBranch() {
            return this.ifNotNullBranch;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\"\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u00022\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010%\u001a\u00020\t2\u0006\u0010\r\u001a\u00020&2\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010'\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020(2\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010)\u001a\u00020\t2\u0006\u0010\r\u001a\u00020*2\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010+\u001a\u00020\t2\u0006\u0010\r\u001a\u00020,2\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010-\u001a\u00020\t*\u00020.2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\tH\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering;)V", "dontTouchTemporaryVals", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lkotlin/collections/HashSet;", "getInlineableValueForTemporaryVal", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "statement", "Lorg/jetbrains/kotlin/ir/IrStatement;", "optimizePropertyAccess", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "accessor", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "currentClass", "removeUnnecessaryTemporaryVariables", "", "statements", "", "rewritePrimitiveEqeqSafeCall", "safeCall", "Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$SafeCallInfo;", "eqeqCall", "rewriteSafeCallEqeqPrimitive", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "data", "visitCall", "visitClass", "declaration", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "ifSafe", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "expr", "backend.jvm.lower"})
    public final class Transformer
    implements IrElementTransformer<IrClass> {
        @NotNull
        private final HashSet<IrVariable> dontTouchTemporaryVals;

        public Transformer() {
            Intrinsics.checkNotNullParameter(JvmOptimizationLowering.this, "this$0");
            this.dontTouchTemporaryVals = new HashSet();
        }

        @Override
        @NotNull
        public IrStatement visitClass(@NotNull IrClass declaration2, @Nullable IrClass data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            declaration2.transformChildren(this, declaration2);
            return declaration2;
        }

        @Override
        @NotNull
        public IrStatement visitFunction(@NotNull IrFunction declaration2, @Nullable IrClass data) {
            IrClass irClass2;
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            boolean codeMightBeGeneratedInDifferentClass = AdditionalIrUtilsKt.isSuspend(declaration2) || declaration2.isInline() || Intrinsics.areEqual(declaration2.getOrigin(), JvmLoweredDeclarationOrigin.INLINE_LAMBDA.INSTANCE);
            IrClass irClass3 = irClass2 = data;
            IrElementTransformer irElementTransformer = this;
            IrFunction irFunction2 = declaration2;
            boolean bl = false;
            boolean bl2 = codeMightBeGeneratedInDifferentClass;
            irFunction2.transformChildren(irElementTransformer, !bl2 ? irClass2 : null);
            return declaration2;
        }

        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2, @Nullable IrClass data) {
            Pair pair;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            expression2.transformChildren(this, data);
            if (Intrinsics.areEqual(((IrSimpleFunction)expression2.getSymbol().getOwner()).getOrigin(), IrDeclarationOrigin.DEFAULT_PROPERTY_ACCESSOR.INSTANCE)) {
                IrSimpleFunction irSimpleFunction;
                if (data == null) {
                    return expression2;
                }
                Object object = expression2.getSymbol().getOwner();
                IrSimpleFunction irSimpleFunction2 = irSimpleFunction = object instanceof IrSimpleFunction ? (IrSimpleFunction)object : null;
                if (irSimpleFunction == null) {
                    return expression2;
                }
                IrSimpleFunction simpleFunction = irSimpleFunction;
                object = simpleFunction.getCorrespondingPropertySymbol();
                if (object == null) {
                    return expression2;
                }
                IrProperty property2 = (IrProperty)object.getOwner();
                if (property2.isLateinit()) {
                    return expression2;
                }
                return this.optimizePropertyAccess(expression2, simpleFunction, property2, data);
            }
            if (Companion.isNegation(expression2, JvmOptimizationLowering.this.getContext())) {
                IrExpression irExpression = expression2.getDispatchReceiver();
                Intrinsics.checkNotNull(irExpression);
                if (Companion.isNegation(irExpression, JvmOptimizationLowering.this.getContext())) {
                    IrExpression irExpression2 = expression2.getDispatchReceiver();
                    if (irExpression2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                    }
                    IrExpression irExpression3 = ((IrCall)irExpression2).getDispatchReceiver();
                    Intrinsics.checkNotNull(irExpression3);
                    return irExpression3;
                }
            }
            if ((pair = JvmOptimizationLowering.this.getOperandsIfCallToEQEQOrEquals(expression2)) != null) {
                Pair pair2 = pair;
                JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
                Pair $dstr$left$right = pair2;
                boolean bl = false;
                IrExpression left = (IrExpression)$dstr$left$right.component1();
                IrExpression right = (IrExpression)$dstr$left$right.component2();
                if (IrUtilsKt.isNullConst(left) && IrUtilsKt.isNullConst(right)) {
                    return IrConstImpl.Companion.constTrue(expression2.getStartOffset(), expression2.getEndOffset(), jvmOptimizationLowering.getContext().getIrBuiltIns().getBooleanType());
                }
                if (IrUtilsKt.isNullConst(left) && right instanceof IrConst || IrUtilsKt.isNullConst(right) && left instanceof IrConst) {
                    return IrConstImpl.Companion.constFalse(expression2.getStartOffset(), expression2.getEndOffset(), jvmOptimizationLowering.getContext().getIrBuiltIns().getBooleanType());
                }
                if (Intrinsics.areEqual(expression2.getSymbol(), jvmOptimizationLowering.getContext().getIrBuiltIns().getEqeqSymbol())) {
                    SafeCallInfo safeCallInfo;
                    if (jvmOptimizationLowering.isJvmPrimitive(right.getType()) && (safeCallInfo = jvmOptimizationLowering.parseSafeCall(left)) != null) {
                        SafeCallInfo safeCallInfo2;
                        SafeCallInfo it = safeCallInfo2 = safeCallInfo;
                        boolean bl2 = false;
                        return this.rewriteSafeCallEqeqPrimitive(it, expression2);
                    }
                    if (jvmOptimizationLowering.isJvmPrimitive(left.getType()) && (safeCallInfo = jvmOptimizationLowering.parseSafeCall(right)) != null) {
                        SafeCallInfo safeCallInfo3;
                        SafeCallInfo it = safeCallInfo3 = safeCallInfo;
                        boolean bl3 = false;
                        return this.rewritePrimitiveEqeqSafeCall(it, expression2);
                    }
                }
            }
            return expression2;
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression ifSafe(IrBuilderWithScope $this$ifSafe, SafeCallInfo safeCall, IrExpression expr) {
            void this_$iv$iv;
            void $this$irBlock_u24default$iv;
            IrBuilderWithScope irBuilderWithScope = $this$ifSafe;
            IrStatementOrigin origin$iv = IrStatementOrigin.SAFE_CALL.INSTANCE;
            int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$ifSafe_u24lambda_u2d4 = this_$iv$iv;
            boolean bl = false;
            $this$ifSafe_u24lambda_u2d4.unaryPlus(safeCall.getTmpVal());
            $this$ifSafe_u24lambda_u2d4.unaryPlus(ExpressionHelpersKt.irIfThenElse$default((IrBuilderWithScope)$this$ifSafe_u24lambda_u2d4, expr.getType(), safeCall.getIfNullBranch().getCondition(), ExpressionHelpersKt.irFalse((IrBuilderWithScope)$this$ifSafe_u24lambda_u2d4), expr, null, 16, null));
            return this_$iv$iv.doBuild();
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression rewriteSafeCallEqeqPrimitive(SafeCallInfo safeCall, IrCall eqeqCall) {
            void $this$rewriteSafeCallEqeqPrimitive_u24lambda_u2d6_u24lambda_u2d5;
            IrCall irCall;
            JvmIrBuilder jvmIrBuilder;
            JvmIrBuilder $this$rewriteSafeCallEqeqPrimitive_u24lambda_u2d6 = jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder$default(JvmOptimizationLowering.this.getContext(), safeCall.getScopeSymbol(), 0, 0, 6, null);
            boolean bl = false;
            IrCall irCall2 = irCall = eqeqCall;
            SafeCallInfo safeCallInfo = safeCall;
            IrBuilderWithScope irBuilderWithScope = $this$rewriteSafeCallEqeqPrimitive_u24lambda_u2d6;
            Transformer transformer2 = this;
            boolean bl2 = false;
            $this$rewriteSafeCallEqeqPrimitive_u24lambda_u2d6_u24lambda_u2d5.putValueArgument(0, safeCall.getIfNotNullBranch().getResult());
            Unit unit2 = Unit.INSTANCE;
            return transformer2.ifSafe(irBuilderWithScope, safeCallInfo, irCall);
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression rewritePrimitiveEqeqSafeCall(SafeCallInfo safeCall, IrCall eqeqCall) {
            IrExpression irExpression;
            JvmIrBuilder jvmIrBuilder;
            JvmIrBuilder $this$rewritePrimitiveEqeqSafeCall_u24lambda_u2d10 = jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder$default(JvmOptimizationLowering.this.getContext(), safeCall.getScopeSymbol(), 0, 0, 6, null);
            boolean bl = false;
            IrExpression irExpression2 = eqeqCall.getValueArgument(0);
            Intrinsics.checkNotNull(irExpression2);
            IrExpression primitive = irExpression2;
            if (IrUtilsKt.isTrivial(primitive)) {
                void $this$rewritePrimitiveEqeqSafeCall_u24lambda_u2d10_u24lambda_u2d7;
                IrCall irCall;
                IrCall irCall2 = irCall = eqeqCall;
                SafeCallInfo safeCallInfo = safeCall;
                IrBuilderWithScope irBuilderWithScope = $this$rewritePrimitiveEqeqSafeCall_u24lambda_u2d10;
                Transformer transformer2 = this;
                boolean bl2 = false;
                $this$rewritePrimitiveEqeqSafeCall_u24lambda_u2d10_u24lambda_u2d7.putValueArgument(1, safeCall.getIfNotNullBranch().getResult());
                Unit unit2 = Unit.INSTANCE;
                irExpression = transformer2.ifSafe(irBuilderWithScope, safeCallInfo, irCall);
            } else {
                void $this$rewritePrimitiveEqeqSafeCall_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d8;
                IrCall irCall;
                void this_$iv$iv;
                IrBuilderWithScope $this$irBlock_u24default$iv = $this$rewritePrimitiveEqeqSafeCall_u24lambda_u2d10;
                int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
                IrStatementOrigin origin$iv = null;
                IrType resultType$iv = null;
                boolean $i$f$irBlock = false;
                IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                boolean $i$f$block = false;
                void $this$rewritePrimitiveEqeqSafeCall_u24lambda_u2d10_u24lambda_u2d9 = this_$iv$iv;
                boolean bl3 = false;
                IrCall irCall3 = irCall = eqeqCall;
                SafeCallInfo safeCallInfo = safeCall;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$rewritePrimitiveEqeqSafeCall_u24lambda_u2d10_u24lambda_u2d9;
                Transformer transformer3 = this;
                void var26_29 = $this$rewritePrimitiveEqeqSafeCall_u24lambda_u2d10_u24lambda_u2d9;
                boolean bl4 = false;
                $this$rewritePrimitiveEqeqSafeCall_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d8.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$rewritePrimitiveEqeqSafeCall_u24lambda_u2d10_u24lambda_u2d9, ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$rewritePrimitiveEqeqSafeCall_u24lambda_u2d10_u24lambda_u2d9, primitive, null, null, false, 14, null)));
                $this$rewritePrimitiveEqeqSafeCall_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d8.putValueArgument(1, safeCall.getIfNotNullBranch().getResult());
                Unit unit3 = Unit.INSTANCE;
                var26_29.unaryPlus(transformer3.ifSafe(irBuilderWithScope, safeCallInfo, irCall));
                irExpression = this_$iv$iv.doBuild();
            }
            return irExpression;
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression optimizePropertyAccess(IrCall expression2, IrSimpleFunction accessor, IrProperty property2, IrClass currentClass) {
            IrField irField;
            if (Intrinsics.areEqual(IrUtilsKt.getParentAsClass(accessor), currentClass) && Intrinsics.areEqual((irField = property2.getBackingField()) == null ? null : IrUtilsKt.getParentAsClass(irField), currentClass) && accessor.getModality() == Modality.FINAL && !accessor.isExternal()) {
                void this_$iv$iv$iv;
                void startOffset$iv$iv;
                void $this$irBlock$iv$iv;
                void $this$irBlock_u24default$iv;
                IrField irField2 = property2.getBackingField();
                Intrinsics.checkNotNull(irField2);
                IrField backingField2 = irField2;
                IrExpression receiver = expression2.getDispatchReceiver();
                IrGeneratorWithScope irGeneratorWithScope = LowerUtilsKt.createIrBuilder(JvmOptimizationLowering.this.getContext(), (IrSymbol)expression2.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
                JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
                IrStatementOrigin origin$iv = null;
                IrType resultType$iv = ((IrExpression)expression2).getType();
                boolean $i$f$irBlock = false;
                void var12_12 = $this$irBlock_u24default$iv;
                int n = ((IrExpression)expression2).getStartOffset();
                int endOffset$iv$iv = ((IrExpression)expression2).getEndOffset();
                boolean $i$f$irBlock2 = false;
                IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
                boolean $i$f$block = false;
                void $this$optimizePropertyAccess_u24lambda_u2d13 = this_$iv$iv$iv;
                boolean bl = false;
                if (backingField2.isStatic() && receiver != null && !(receiver instanceof IrGetValue)) {
                    $this$optimizePropertyAccess_u24lambda_u2d13.unaryPlus(IrUtilsKt.coerceToUnit(receiver, $this$optimizePropertyAccess_u24lambda_u2d13.getContext().getIrBuiltIns(), jvmOptimizationLowering.getContext().getTypeSystem()));
                }
                if (!((Collection)accessor.getValueParameters()).isEmpty()) {
                    IrExpression irExpression;
                    IrExpression irExpression2 = irExpression = receiver;
                    IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$optimizePropertyAccess_u24lambda_u2d13;
                    void var23_26 = $this$optimizePropertyAccess_u24lambda_u2d13;
                    boolean bl2 = false;
                    boolean bl3 = backingField2.isStatic();
                    IrExpression irExpression3 = !bl3 ? irExpression : null;
                    IrExpression irExpression4 = expression2.getValueArgument(expression2.getValueArgumentsCount() - 1);
                    Intrinsics.checkNotNull(irExpression4);
                    var23_26.unaryPlus(ExpressionHelpersKt.irSetField(irBuilderWithScope, irExpression3, backingField2, irExpression4));
                } else {
                    IrExpression irExpression;
                    IrExpression it = irExpression = receiver;
                    IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$optimizePropertyAccess_u24lambda_u2d13;
                    void var23_27 = $this$optimizePropertyAccess_u24lambda_u2d13;
                    boolean bl4 = false;
                    boolean bl5 = backingField2.isStatic();
                    var23_27.unaryPlus(ExpressionHelpersKt.irGetField(irBuilderWithScope, !bl5 ? irExpression : null, backingField2));
                }
                return this_$iv$iv$iv.doBuild();
            }
            return expression2;
        }

        @Override
        @NotNull
        public IrExpression visitWhen(@NotNull IrWhen expression2, @Nullable IrClass data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            boolean isCompilerGenerated = expression2.getOrigin() == null;
            expression2.transformChildren(this, data);
            expression2.getBranches().removeIf(arg_0 -> Transformer.visitWhen$lambda-14(isCompilerGenerated, arg_0));
            if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.ANDAND.INSTANCE)) {
                IrCallImpl irCallImpl;
                boolean bl;
                boolean bl2 = bl = IrTypePredicatesKt.isBoolean(expression2.getType()) && expression2.getBranches().size() == 2 && IrUtilsKt.isTrueConst(expression2.getBranches().get(1).getCondition()) && IrUtilsKt.isFalseConst(expression2.getBranches().get(1).getResult());
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$32 = false;
                    String $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$32 = Intrinsics.stringPlus("ANDAND condition should have an 'if true then false' body on its second branch. Failing expression: ", DumpIrTreeKt.dump$default(expression2, false, false, 3, null));
                    throw new AssertionError((Object)$i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$32);
                }
                IrCallImpl $this$visitWhen_u24lambda_u2d16 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getBooleanType(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getAndandSymbol(), 0, 0, null, null, 240, null);
                boolean bl3 = false;
                $this$visitWhen_u24lambda_u2d16.putValueArgument(0, expression2.getBranches().get(0).getCondition());
                $this$visitWhen_u24lambda_u2d16.putValueArgument(1, expression2.getBranches().get(0).getResult());
                return irCallImpl;
            }
            if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.OROR.INSTANCE)) {
                IrCallImpl irCallImpl;
                boolean bl;
                boolean bl4 = bl = IrTypePredicatesKt.isBoolean(expression2.getType()) && expression2.getBranches().size() == 2 && IrUtilsKt.isTrueConst(expression2.getBranches().get(0).getResult()) && IrUtilsKt.isTrueConst(expression2.getBranches().get(1).getCondition());
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$52 = false;
                    String $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$52 = Intrinsics.stringPlus("OROR condition should have an 'if a then true' body on its first branch, and an 'if true then b' body on its second branch. Failing expression: ", DumpIrTreeKt.dump$default(expression2, false, false, 3, null));
                    throw new AssertionError((Object)$i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$52);
                }
                IrCallImpl $this$visitWhen_u24lambda_u2d18 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getBooleanType(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getOrorSymbol(), 0, 0, null, null, 240, null);
                boolean bl5 = false;
                $this$visitWhen_u24lambda_u2d18.putValueArgument(0, expression2.getBranches().get(0).getCondition());
                $this$visitWhen_u24lambda_u2d18.putValueArgument(1, expression2.getBranches().get(1).getResult());
                return irCallImpl;
            }
            if (expression2.getBranches().size() == 0) {
                return new IrBlockImpl(expression2.getStartOffset(), expression2.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
            }
            IrBranch firstBranch = CollectionsKt.first(expression2.getBranches());
            if (IrUtilsKt.isTrueConst(firstBranch.getCondition()) && isCompilerGenerated) {
                return firstBranch.getResult();
            }
            return expression2;
        }

        private final IrExpression getInlineableValueForTemporaryVal(IrStatement statement2) {
            IrVariable irVariable2;
            IrVariable irVariable3 = irVariable2 = statement2 instanceof IrVariable ? (IrVariable)statement2 : null;
            if (irVariable2 == null) {
                return null;
            }
            IrVariable variable2 = irVariable2;
            if (!Intrinsics.areEqual(variable2.getOrigin(), IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE) || variable2.isVar()) {
                return null;
            }
            if (this.dontTouchTemporaryVals.contains(variable2)) {
                return null;
            }
            IrExpression initializer2 = variable2.getInitializer();
            if (initializer2 instanceof IrConst) {
                return initializer2;
            }
            if (initializer2 instanceof IrGetValue) {
                IrValueDeclaration initializerValue2 = ((IrGetValue)initializer2).getSymbol().getOwner();
                if (initializerValue2 instanceof IrVariable) {
                    IrExpression irExpression;
                    IrExpression irExpression2 = ((IrVariable)initializerValue2).isVar() ? null : (Intrinsics.areEqual(initializerValue2.getOrigin(), IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE) ? ((irExpression = this.getInlineableValueForTemporaryVal(initializerValue2)) == null ? initializer2 : irExpression) : initializer2);
                    return irExpression2;
                }
                if (initializerValue2 instanceof IrValueParameter) {
                    return initializerValue2.isAssignable() ? null : initializer2;
                }
            }
            return null;
        }

        private final void removeUnnecessaryTemporaryVariables(List<IrStatement> statements2) {
            statements2.removeIf(arg_0 -> Transformer.removeUnnecessaryTemporaryVariables$lambda-19(this, arg_0));
            if (statements2.size() == 2) {
                IrStatement first = statements2.get(0);
                IrStatement second = statements2.get(1);
                if (first instanceof IrVariable && Intrinsics.areEqual(((IrVariable)first).getOrigin(), IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE) && second instanceof IrGetValue && Intrinsics.areEqual(((IrVariable)first).getSymbol(), ((IrGetValue)second).getSymbol())) {
                    statements2.clear();
                    IrExpression irExpression = ((IrVariable)first).getInitializer();
                    if (irExpression != null) {
                        IrExpression irExpression2;
                        IrExpression it = irExpression2 = irExpression;
                        boolean bl = false;
                        statements2.add(it);
                    }
                }
            }
        }

        @Override
        @NotNull
        public IrBody visitBlockBody(@NotNull IrBlockBody body2, @Nullable IrClass data) {
            Intrinsics.checkNotNullParameter(body2, "body");
            body2.transformChildren(this, data);
            this.removeUnnecessaryTemporaryVariables(body2.getStatements());
            return body2;
        }

        @Override
        @NotNull
        public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable IrClass data) {
            IrStatement subject;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            SafeCallInfo safeCall = JvmOptimizationLowering.this.parseSafeCall(expression2);
            if (safeCall != null) {
                this.dontTouchTemporaryVals.add(safeCall.getTmpVal());
            }
            if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.WHEN.INSTANCE) && (subject = CollectionsKt.firstOrNull(expression2.getStatements())) instanceof IrVariable && ((IrVariable)subject).getInitializer() instanceof IrGetValue) {
                this.dontTouchTemporaryVals.add((IrVariable)subject);
            }
            expression2.transformChildren(this, data);
            this.removeUnnecessaryTemporaryVariables(expression2.getStatements());
            return expression2;
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2, @Nullable IrClass data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrValueDeclaration variable2 = expression2.getSymbol().getOwner();
            IrExpression replacement = this.getInlineableValueForTemporaryVal(variable2);
            return replacement instanceof IrConst ? (IrExpression)((IrConst)replacement).copyWithOffsets(expression2.getStartOffset(), expression2.getEndOffset()) : (replacement instanceof IrGetValue ? (IrExpression)((IrGetValue)replacement).copyWithOffsets(expression2.getStartOffset(), expression2.getEndOffset()) : (IrExpression)expression2);
        }

        @Override
        @NotNull
        public <T> IrExpression visitConst(@NotNull IrConst<T> expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitBlock(@NotNull IrBlock expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        @NotNull
        public IrBody visitBody(@NotNull IrBody body2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitBody(this, body2, data);
        }

        @Override
        @NotNull
        public IrBranch visitBranch(@NotNull IrBranch branch, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        @NotNull
        public IrExpression visitBreak(@NotNull IrBreak jump, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        @NotNull
        public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        @NotNull
        public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrCatch visitCatch(@NotNull IrCatch aCatch, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        @NotNull
        public IrExpression visitClassReference(@NotNull IrClassReference expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitComposite(@NotNull IrComposite expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitConstructor(@NotNull IrConstructor declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitConstructorCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitContinue(@NotNull IrContinue jump, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        @NotNull
        public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitElement(@NotNull IrElement element, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitElement(this, element, data);
        }

        @Override
        @NotNull
        public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        @NotNull
        public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitExpression(@NotNull IrExpression expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data);
        }

        @Override
        @NotNull
        public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrStatement visitField(@NotNull IrField declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitField(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrFile visitFile(@NotNull IrFile declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitFile(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetClass(@NotNull IrGetClass expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitLoop(@NotNull IrLoop loop2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data);
        }

        @Override
        @NotNull
        public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrStatement visitProperty(@NotNull IrProperty declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitProperty(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitReturn(@NotNull IrReturn expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitScript(@NotNull IrScript declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitScript(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSetField(@NotNull IrSetField expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSetValue(@NotNull IrSetValue expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitSetValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        @NotNull
        public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        @NotNull
        public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data);
        }

        @Override
        @NotNull
        public IrExpression visitThrow(@NotNull IrThrow expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitTry(@NotNull IrTry aTry, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        @NotNull
        public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitVararg(@NotNull IrVararg expression2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitVariable(this, declaration2, data);
        }

        @Override
        @NotNull
        public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable IrClass data) {
            return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data);
        }

        private static final boolean visitWhen$lambda-14(boolean $isCompilerGenerated, IrBranch it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return IrUtilsKt.isFalseConst(it.getCondition()) && $isCompilerGenerated;
        }

        private static final boolean removeUnnecessaryTemporaryVariables$lambda-19(Transformer this$0, IrStatement it) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter(it, "it");
            return this$0.getInlineableValueForTemporaryVal(it) != null;
        }
    }
}

