/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.utils;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.utils.AbstractArrayMapOwner;
import org.jetbrains.kotlin.fir.utils.ArrayMap;
import org.jetbrains.kotlin.fir.utils.ArrayMapImpl;
import org.jetbrains.kotlin.fir.utils.EmptyArrayMap;
import org.jetbrains.kotlin.fir.utils.OneElementArrayMap;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ%\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000f2\u0006\u0010\u0010\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000fH\u0004R*\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/utils/AttributeArrayOwner;", "K", "", "T", "Lorg/jetbrains/kotlin/fir/utils/AbstractArrayMapOwner;", "()V", "arrayMap", "Lorg/jetbrains/kotlin/fir/utils/ArrayMap;", "(Lorg/jetbrains/kotlin/fir/utils/ArrayMap;)V", "<set-?>", "getArrayMap", "()Lorg/jetbrains/kotlin/fir/utils/ArrayMap;", "registerComponent", "", "tClass", "Lkotlin/reflect/KClass;", "value", "(Lkotlin/reflect/KClass;Ljava/lang/Object;)V", "removeComponent", "cones"})
public abstract class AttributeArrayOwner<K, T>
extends AbstractArrayMapOwner<K, T> {
    @NotNull
    private ArrayMap<T> arrayMap;

    protected AttributeArrayOwner(@NotNull ArrayMap<T> arrayMap) {
        Intrinsics.checkNotNullParameter(arrayMap, "arrayMap");
        this.arrayMap = arrayMap;
    }

    @Override
    @NotNull
    protected final ArrayMap<T> getArrayMap() {
        return this.arrayMap;
    }

    public AttributeArrayOwner() {
        this(EmptyArrayMap.INSTANCE);
    }

    @Override
    protected final void registerComponent(@NotNull KClass<? extends K> tClass, @NotNull T value2) {
        Intrinsics.checkNotNullParameter(tClass, "tClass");
        Intrinsics.checkNotNullParameter(value2, "value");
        int id = this.getTypeRegistry().getId(tClass);
        int n = this.arrayMap.getSize();
        switch (n) {
            case 0: {
                this.arrayMap = new OneElementArrayMap<T>(value2, id);
                return;
            }
            case 1: {
                OneElementArrayMap map = (OneElementArrayMap)this.arrayMap;
                if (map.getIndex() == id) {
                    this.arrayMap = new OneElementArrayMap<T>(value2, id);
                    return;
                }
                this.arrayMap = new ArrayMapImpl();
                this.arrayMap.set(map.getIndex(), map.getValue());
            }
        }
        this.arrayMap.set(id, value2);
    }

    protected final void removeComponent(@NotNull KClass<? extends K> tClass) {
        Intrinsics.checkNotNullParameter(tClass, "tClass");
        int id = this.getTypeRegistry().getId(tClass);
        if (this.arrayMap.get(id) == null) {
            return;
        }
        int n = this.arrayMap.getSize();
        if (n == 1) {
            this.arrayMap = EmptyArrayMap.INSTANCE;
        } else {
            ArrayMapImpl map = (ArrayMapImpl)this.arrayMap;
            map.remove(id);
            if (map.getSize() == 1) {
                ArrayMapImpl.Entry entry = CollectionsKt.first(map.entries());
                int index2 = entry.component1();
                Object value2 = entry.component2();
                this.arrayMap = new OneElementArrayMap(value2, index2);
            }
        }
    }
}

