/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirLoopTarget;
import org.jetbrains.kotlin.fir.FirSourceElementKind;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001DB\u0005\u00a2\u0006\u0002\u0010\u0003J(\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020.2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002090<H\u0086\b\u00f8\u0001\u0000J\u0006\u0010>\u001a\u000209J\u001c\u0010?\u001a\u0002092\u0006\u0010@\u001a\u00020.2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020C0BR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\rR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\rR\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\rR\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\rR\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0011\u00103\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b4\u00100R\u001a\u00105\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0014\"\u0004\b7\u0010\u0016\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/fir/builder/Context;", "T", "", "()V", "arraySetArgument", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getArraySetArgument", "()Ljava/util/Map;", "calleeNamesForLambda", "", "Lorg/jetbrains/kotlin/name/Name;", "getCalleeNamesForLambda", "()Ljava/util/List;", "capturedTypeParameters", "Lorg/jetbrains/kotlin/fir/builder/Context$StatusFirTypeParameterSymbolList;", "getCapturedTypeParameters", "className", "Lorg/jetbrains/kotlin/name/FqName;", "getClassName", "()Lorg/jetbrains/kotlin/name/FqName;", "setClassName", "(Lorg/jetbrains/kotlin/name/FqName;)V", "currentClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "getCurrentClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "dispatchReceiverTypesStack", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "getDispatchReceiverTypesStack", "firFunctionTargets", "Lorg/jetbrains/kotlin/fir/FirFunctionTarget;", "getFirFunctionTargets", "firLabels", "Lorg/jetbrains/kotlin/fir/FirLabel;", "getFirLabels", "firLoopTargets", "Lorg/jetbrains/kotlin/fir/FirLoopTarget;", "getFirLoopTargets", "forcedElementSourceKind", "Lorg/jetbrains/kotlin/fir/FirSourceElementKind;", "getForcedElementSourceKind", "()Lorg/jetbrains/kotlin/fir/FirSourceElementKind;", "setForcedElementSourceKind", "(Lorg/jetbrains/kotlin/fir/FirSourceElementKind;)V", "forcedLocalContext", "", "getForcedLocalContext", "()Z", "setForcedLocalContext", "(Z)V", "inLocalContext", "getInLocalContext", "packageFqName", "getPackageFqName", "setPackageFqName", "applyToActualCapturedTypeParameters", "", "ignoreLastLevel", "action", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "popFirTypeParameters", "pushFirTypeParameters", "notNested", "parameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "StatusFirTypeParameterSymbolList", "raw-fir.common"})
public final class Context<T> {
    public FqName packageFqName;
    @NotNull
    private FqName className;
    private boolean forcedLocalContext;
    @NotNull
    private final List<FirFunctionTarget> firFunctionTargets;
    @NotNull
    private final List<Name> calleeNamesForLambda;
    @NotNull
    private final List<FirLabel> firLabels;
    @NotNull
    private final List<FirLoopTarget> firLoopTargets;
    @NotNull
    private final List<StatusFirTypeParameterSymbolList> capturedTypeParameters;
    @NotNull
    private final Map<T, FirExpression> arraySetArgument;
    @Nullable
    private FirSourceElementKind forcedElementSourceKind;
    @NotNull
    private final List<ConeClassLikeType> dispatchReceiverTypesStack;

    public Context() {
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkNotNullExpressionValue(fqName2, "ROOT");
        this.className = fqName2;
        boolean bl = false;
        this.firFunctionTargets = new ArrayList();
        bl = false;
        this.calleeNamesForLambda = new ArrayList();
        bl = false;
        this.firLabels = new ArrayList();
        bl = false;
        this.firLoopTargets = new ArrayList();
        bl = false;
        this.capturedTypeParameters = new ArrayList();
        bl = false;
        this.arraySetArgument = new LinkedHashMap();
        bl = false;
        this.dispatchReceiverTypesStack = new ArrayList();
    }

    @NotNull
    public final FqName getPackageFqName() {
        FqName fqName2 = this.packageFqName;
        if (fqName2 != null) {
            return fqName2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("packageFqName");
        return null;
    }

    public final void setPackageFqName(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "<set-?>");
        this.packageFqName = fqName2;
    }

    @NotNull
    public final FqName getClassName() {
        return this.className;
    }

    public final void setClassName(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "<set-?>");
        this.className = fqName2;
    }

    public final boolean getForcedLocalContext() {
        return this.forcedLocalContext;
    }

    public final void setForcedLocalContext(boolean bl) {
        this.forcedLocalContext = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getInLocalContext() {
        if (this.forcedLocalContext) return true;
        Collection collection = this.firFunctionTargets;
        boolean bl = false;
        if (collection.isEmpty()) return false;
        return true;
    }

    @NotNull
    public final ClassId getCurrentClassId() {
        return new ClassId(this.getPackageFqName(), this.className, this.getInLocalContext());
    }

    @NotNull
    public final List<FirFunctionTarget> getFirFunctionTargets() {
        return this.firFunctionTargets;
    }

    @NotNull
    public final List<Name> getCalleeNamesForLambda() {
        return this.calleeNamesForLambda;
    }

    @NotNull
    public final List<FirLabel> getFirLabels() {
        return this.firLabels;
    }

    @NotNull
    public final List<FirLoopTarget> getFirLoopTargets() {
        return this.firLoopTargets;
    }

    @NotNull
    public final List<StatusFirTypeParameterSymbolList> getCapturedTypeParameters() {
        return this.capturedTypeParameters;
    }

    @NotNull
    public final Map<T, FirExpression> getArraySetArgument() {
        return this.arraySetArgument;
    }

    @Nullable
    public final FirSourceElementKind getForcedElementSourceKind() {
        return this.forcedElementSourceKind;
    }

    public final void setForcedElementSourceKind(@Nullable FirSourceElementKind firSourceElementKind) {
        this.forcedElementSourceKind = firSourceElementKind;
    }

    @NotNull
    public final List<ConeClassLikeType> getDispatchReceiverTypesStack() {
        return this.dispatchReceiverTypesStack;
    }

    /*
     * WARNING - void declaration
     */
    public final void pushFirTypeParameters(boolean notNested, @NotNull List<? extends FirTypeParameterRef> parameters2) {
        Collection<FirTypeParameterSymbol> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Iterable iterable = parameters2;
        boolean bl = notNested;
        List<StatusFirTypeParameterSymbolList> list2 = this.capturedTypeParameters;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            FirTypeParameterSymbol firTypeParameterSymbol = it.getSymbol();
            collection.add(firTypeParameterSymbol);
        }
        collection = (List)destination$iv$iv;
        List list3 = collection;
        boolean bl3 = bl;
        list2.add(new StatusFirTypeParameterSymbolList(bl3, list3));
    }

    public final void popFirTypeParameters() {
        List<StatusFirTypeParameterSymbolList> list2 = this.capturedTypeParameters;
        list2.remove(CollectionsKt.getLastIndex(list2));
    }

    public final void applyToActualCapturedTypeParameters(boolean ignoreLastLevel, @NotNull Function1<? super FirTypeParameterSymbol, Unit> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        boolean $i$f$applyToActualCapturedTypeParameters = false;
        int n = CollectionsKt.getLastIndex(this.getCapturedTypeParameters());
        if (0 <= n) {
            StatusFirTypeParameterSymbolList element;
            do {
                int index2 = n--;
                element = this.getCapturedTypeParameters().get(index2);
                if (index2 >= CollectionsKt.getLastIndex(this.getCapturedTypeParameters()) && ignoreLastLevel) continue;
                for (FirTypeParameterSymbol capturedTypeParameter : element.getList()) {
                    action.invoke(capturedTypeParameter);
                }
            } while (element.getNotNested() && 0 <= n);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/builder/Context$StatusFirTypeParameterSymbolList;", "", "notNested", "", "list", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "(ZLjava/util/List;)V", "getList", "()Ljava/util/List;", "getNotNested", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "raw-fir.common"})
    public static final class StatusFirTypeParameterSymbolList {
        private final boolean notNested;
        @NotNull
        private final List<FirTypeParameterSymbol> list;

        public StatusFirTypeParameterSymbolList(boolean notNested, @NotNull List<FirTypeParameterSymbol> list2) {
            Intrinsics.checkNotNullParameter(list2, "list");
            this.notNested = notNested;
            this.list = list2;
        }

        public /* synthetic */ StatusFirTypeParameterSymbolList(boolean bl, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                boolean bl2 = false;
                list2 = CollectionsKt.emptyList();
            }
            this(bl, list2);
        }

        public final boolean getNotNested() {
            return this.notNested;
        }

        @NotNull
        public final List<FirTypeParameterSymbol> getList() {
            return this.list;
        }

        public final boolean component1() {
            return this.notNested;
        }

        @NotNull
        public final List<FirTypeParameterSymbol> component2() {
            return this.list;
        }

        @NotNull
        public final StatusFirTypeParameterSymbolList copy(boolean notNested, @NotNull List<FirTypeParameterSymbol> list2) {
            Intrinsics.checkNotNullParameter(list2, "list");
            return new StatusFirTypeParameterSymbolList(notNested, list2);
        }

        public static /* synthetic */ StatusFirTypeParameterSymbolList copy$default(StatusFirTypeParameterSymbolList statusFirTypeParameterSymbolList, boolean bl, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = statusFirTypeParameterSymbolList.notNested;
            }
            if ((n & 2) != 0) {
                list2 = statusFirTypeParameterSymbolList.list;
            }
            return statusFirTypeParameterSymbolList.copy(bl, list2);
        }

        @NotNull
        public String toString() {
            return "StatusFirTypeParameterSymbolList(notNested=" + this.notNested + ", list=" + this.list + ')';
        }

        public int hashCode() {
            int n = this.notNested ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result2 = n;
            result2 = result2 * 31 + ((Object)this.list).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StatusFirTypeParameterSymbolList)) {
                return false;
            }
            StatusFirTypeParameterSymbolList statusFirTypeParameterSymbolList = (StatusFirTypeParameterSymbolList)other;
            if (this.notNested != statusFirTypeParameterSymbolList.notNested) {
                return false;
            }
            return Intrinsics.areEqual(this.list, statusFirTypeParameterSymbolList.list);
        }
    }
}

