/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnAllowedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "isReturnAllowed", "", "targetSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "checkers"})
public final class FirReturnAllowedChecker
extends FirExpressionChecker<FirReturnExpression> {
    @NotNull
    public static final FirReturnAllowedChecker INSTANCE = new FirReturnAllowedChecker();

    private FirReturnAllowedChecker() {
    }

    @Override
    public void check(@NotNull FirReturnExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirDeclaration containingDeclaration;
        FirSourceElement source;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirSourceElement firSourceElement = source = expression2.getSource();
        if (Intrinsics.areEqual(firSourceElement == null ? null : firSourceElement.getKind(), FirFakeSourceElementKind.ImplicitReturn.INSTANCE)) {
            return;
        }
        FirFunctionSymbol<?> targetSymbol = expression2.getTarget().getLabeledElement().getSymbol();
        if (!this.isReturnAllowed(targetSymbol, context2)) {
            DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getRETURN_NOT_ALLOWED(), context2, null, 8, null);
        }
        if ((containingDeclaration = CollectionsKt.last(context2.getContainingDeclarations())) instanceof FirFunction && ((FirFunction)containingDeclaration).getBody() instanceof FirSingleExpressionBlock) {
            DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getRETURN_IN_FUNCTION_WITH_EXPRESSION_BODY(), context2, null, 8, null);
        }
    }

    private final boolean isReturnAllowed(FirFunctionSymbol<?> targetSymbol, CheckerContext context2) {
        for (FirDeclaration containingDeclaration : CollectionsKt.asReversed(context2.getContainingDeclarations())) {
            FirDeclaration firDeclaration = containingDeclaration;
            if (firDeclaration instanceof FirClass) {
                return false;
            }
            if (firDeclaration instanceof FirFunction) {
                if (Intrinsics.areEqual(((FirFunction)containingDeclaration).getSymbol(), targetSymbol)) {
                    return true;
                }
                if (containingDeclaration instanceof FirAnonymousFunction) {
                    if (((FirAnonymousFunction)containingDeclaration).getInlineStatus().getReturnAllowed()) continue;
                    return false;
                }
                return false;
            }
            if (firDeclaration instanceof FirProperty) {
                if (((FirProperty)containingDeclaration).isLocal()) continue;
                return false;
            }
            if (!(firDeclaration instanceof FirValueParameter)) continue;
            return true;
        }
        return true;
    }
}

