/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinAccessibility;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinValue;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.AnnotationsKt;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0012\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u0002H\u0002\u00a8\u0006\f"}, d2={"checkSinceKotlinVersionAccessibility", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirSinceKotlinAccessibility;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getOwnSinceKotlinVersion", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirSinceKotlinValue;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "loadWasExperimentalMarkerClasses", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "checkers"})
public final class FirSinceKotlinHelpersKt {
    @NotNull
    public static final FirSinceKotlinAccessibility checkSinceKotlinVersionAccessibility(@NotNull FirAnnotatedDeclaration $this$checkSinceKotlinVersionAccessibility, @NotNull CheckerContext context2) {
        FirSinceKotlinValue value2;
        Intrinsics.checkNotNullParameter($this$checkSinceKotlinVersionAccessibility, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        FirSinceKotlinValue firSinceKotlinValue = value2 = FirSinceKotlinHelpersKt.getOwnSinceKotlinVersion($this$checkSinceKotlinVersionAccessibility, context2.getSession());
        ApiVersion version = firSinceKotlinValue == null ? null : firSinceKotlinValue.getApiVersion();
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        if (version == null || version.compareTo(languageVersionSettings.getApiVersion()) <= 0) {
            return FirSinceKotlinAccessibility.Accessible.INSTANCE;
        }
        List<FirRegularClassSymbol> wasExperimentalFqNames = value2.getWasExperimentalMarkerClasses();
        Collection collection = wasExperimentalFqNames;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return new FirSinceKotlinAccessibility.NotAccessibleButWasExperimental(version, wasExperimentalFqNames);
        }
        return new FirSinceKotlinAccessibility.NotAccessible(version);
    }

    private static final FirSinceKotlinValue getOwnSinceKotlinVersion(FirAnnotatedDeclaration $this$getOwnSinceKotlinVersion, FirSession session2) {
        FirClassLikeDeclaration firClassLikeDeclaration;
        FirClassLikeSymbol<?> classSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol;
        ClassId classId;
        Ref.ObjectRef<FirSinceKotlinValue> result2 = new Ref.ObjectRef<FirSinceKotlinValue>();
        FirSinceKotlinHelpersKt.getOwnSinceKotlinVersion$consider($this$getOwnSinceKotlinVersion, result2);
        if ($this$getOwnSinceKotlinVersion instanceof FirConstructor && (classId = ((FirConstructor)$this$getOwnSinceKotlinVersion).getSymbol().getCallableId().getClassId()) != null && (firClassLikeSymbol = (classSymbol = MainSessionComponentsKt.getSymbolProvider(session2).getClassLikeSymbolByFqName(classId))) != null && (firClassLikeDeclaration = (FirClassLikeDeclaration)firClassLikeSymbol.getFir()) != null) {
            FirSinceKotlinHelpersKt.getOwnSinceKotlinVersion$consider(firClassLikeDeclaration, result2);
        }
        if ($this$getOwnSinceKotlinVersion instanceof FirTypeAlias) {
            ConeClassLikeType coneClassLikeType;
            Object object = FirTypeUtilsKt.getConeType(((FirTypeAlias)$this$getOwnSinceKotlinVersion).getExpandedTypeRef());
            ConeClassLikeType coneClassLikeType2 = coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
            if (coneClassLikeType != null && (object = coneClassLikeType.getLookupTag()) != null && (firClassLikeSymbol = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, session2)) != null && (firClassLikeDeclaration = (FirClassLikeDeclaration)firClassLikeSymbol.getFir()) != null) {
                FirSinceKotlinHelpersKt.getOwnSinceKotlinVersion$consider(firClassLikeDeclaration, result2);
            }
        }
        return (FirSinceKotlinValue)result2.element;
    }

    private static final List<FirRegularClassSymbol> loadWasExperimentalMarkerClasses(FirAnnotatedDeclaration $this$loadWasExperimentalMarkerClasses) {
        FirAnnotationCall firAnnotationCall = FirAnnotationHelpersKt.getAnnotationByFqName($this$loadWasExperimentalMarkerClasses, OptInNames.INSTANCE.getWAS_EXPERIMENTAL_FQ_NAME());
        if (firAnnotationCall == null) {
            return CollectionsKt.emptyList();
        }
        FirAnnotationCall wasExperimental = firAnnotationCall;
        FirExpression firExpression2 = FirAnnotationHelpersKt.findArgumentByName(wasExperimental, OptInNames.INSTANCE.getWAS_EXPERIMENTAL_ANNOTATION_CLASS());
        if (firExpression2 == null) {
            return CollectionsKt.emptyList();
        }
        FirExpression annotationClasses = firExpression2;
        return FirAnnotationHelpersKt.extractClassesFromArgument(annotationClasses);
    }

    private static final void getOwnSinceKotlinVersion$consider(FirAnnotatedDeclaration $this$getOwnSinceKotlinVersion_u24consider, Ref.ObjectRef<FirSinceKotlinValue> result2) {
        block7: {
            ApiVersion apiVersion;
            block8: {
                ApiVersion apiVersion2;
                List<FirExpression> list2;
                FirExpression firExpression2;
                FirAnnotationCall firAnnotationCall = FirAnnotationHelpersKt.getAnnotationByFqName($this$getOwnSinceKotlinVersion_u24consider, AnnotationsKt.getSINCE_KOTLIN_FQ_NAME());
                if (firAnnotationCall == null) {
                    firExpression2 = null;
                } else {
                    FirCall $this$arguments$iv = firAnnotationCall;
                    boolean $i$f$getArguments = false;
                    list2 = $this$arguments$iv.getArgumentList().getArguments();
                    firExpression2 = list2 == null ? null : CollectionsKt.singleOrNull(list2);
                }
                FirExpression sinceKotlinSingleArgument = firExpression2;
                Object object = sinceKotlinSingleArgument instanceof FirConstExpression ? (FirConstExpression)sinceKotlinSingleArgument : null;
                List<FirExpression> list3 = object == null ? null : (List<FirExpression>)((FirConstExpression)object).getValue();
                List<FirExpression> list4 = list2 = list3 instanceof String ? (String)((Object)list3) : null;
                if (list2 == null) {
                    apiVersion2 = null;
                } else {
                    list3 = list2;
                    object = ApiVersion.Companion;
                    boolean bl = false;
                    boolean bl2 = false;
                    List<FirExpression> p0 = list3;
                    boolean bl3 = false;
                    apiVersion2 = ((ApiVersion.Companion)object).parse((String)((Object)p0));
                }
                apiVersion = apiVersion2;
                if (apiVersion == null) break block7;
                if (result2.element == null) break block8;
                Object t = result2.element;
                Intrinsics.checkNotNull(t);
                if (apiVersion.compareTo(((FirSinceKotlinValue)t).getApiVersion()) <= 0) break block7;
            }
            result2.element = new FirSinceKotlinValue(apiVersion, FirSinceKotlinHelpersKt.loadWasExperimentalMarkerClasses($this$getOwnSinceKotlinVersion_u24consider));
        }
    }
}

