/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\n\u001a\u00020\u0005*\u00020\u0005\u001a\u001e\u0010\u000b\u001a\u00020\f*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000e\u001a\n\u0010\u000f\u001a\u00020\u0005*\u00020\u0005\u001a\u0012\u0010\u0010\u001a\u00020\f*\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0005\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007*\n\u0010\u0012\"\u00020\u00132\u00020\u0013\u00a8\u0006\u0014"}, d2={"isStarProjection", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "(Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)Z", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getType", "(Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "canBeInt", "Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralType;", "lowerBoundIfFlexible", "mapTypes", "Lorg/jetbrains/kotlin/fir/types/ConeIntersectionType;", "func", "Lkotlin/Function1;", "upperBoundIfFlexible", "withAlternative", "alternativeType", "ConeKotlinErrorType", "Lorg/jetbrains/kotlin/fir/types/ConeClassErrorType;", "cones"})
public final class ConeTypesKt {
    @Nullable
    public static final ConeKotlinType getType(@NotNull ConeTypeProjection $this$type) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter($this$type, "<this>");
        ConeTypeProjection coneTypeProjection = $this$type;
        if (Intrinsics.areEqual(coneTypeProjection, ConeStarProjection.INSTANCE)) {
            coneKotlinType = null;
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjection) {
            coneKotlinType = ((ConeKotlinTypeProjection)$this$type).getType();
        } else if (coneTypeProjection instanceof ConeKotlinType) {
            coneKotlinType = (ConeKotlinType)$this$type;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }

    public static final boolean isStarProjection(@NotNull ConeTypeProjection $this$isStarProjection) {
        Intrinsics.checkNotNullParameter($this$isStarProjection, "<this>");
        return Intrinsics.areEqual($this$isStarProjection, ConeStarProjection.INSTANCE);
    }

    @NotNull
    public static final ConeKotlinType upperBoundIfFlexible(@NotNull ConeKotlinType $this$upperBoundIfFlexible) {
        Intrinsics.checkNotNullParameter($this$upperBoundIfFlexible, "<this>");
        ConeFlexibleType coneFlexibleType = $this$upperBoundIfFlexible instanceof ConeFlexibleType ? (ConeFlexibleType)$this$upperBoundIfFlexible : null;
        return coneFlexibleType == null ? $this$upperBoundIfFlexible : coneFlexibleType.getUpperBound();
    }

    @NotNull
    public static final ConeKotlinType lowerBoundIfFlexible(@NotNull ConeKotlinType $this$lowerBoundIfFlexible) {
        Intrinsics.checkNotNullParameter($this$lowerBoundIfFlexible, "<this>");
        ConeFlexibleType coneFlexibleType = $this$lowerBoundIfFlexible instanceof ConeFlexibleType ? (ConeFlexibleType)$this$lowerBoundIfFlexible : null;
        return coneFlexibleType == null ? $this$lowerBoundIfFlexible : coneFlexibleType.getLowerBound();
    }

    @NotNull
    public static final ConeIntersectionType withAlternative(@NotNull ConeIntersectionType $this$withAlternative, @NotNull ConeKotlinType alternativeType) {
        Intrinsics.checkNotNullParameter($this$withAlternative, "<this>");
        Intrinsics.checkNotNullParameter(alternativeType, "alternativeType");
        return new ConeIntersectionType($this$withAlternative.getIntersectedTypes(), alternativeType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeIntersectionType mapTypes(@NotNull ConeIntersectionType $this$mapTypes, @NotNull Function1<? super ConeKotlinType, ? extends ConeKotlinType> func) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$mapTypes, "<this>");
        Intrinsics.checkNotNullParameter(func, "func");
        Iterable $this$map$iv = $this$mapTypes.getIntersectedTypes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv.add(func.invoke((ConeKotlinType)item$iv$iv));
        }
        List list2 = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        ConeKotlinType coneKotlinType = null;
        Collection collection = list2;
        return new ConeIntersectionType(collection, coneKotlinType, n, defaultConstructorMarker);
    }

    public static final boolean canBeInt(@NotNull ConeIntegerLiteralType $this$canBeInt) {
        Intrinsics.checkNotNullParameter($this$canBeInt, "<this>");
        long l = $this$canBeInt.getValue();
        return Integer.MIN_VALUE <= l ? l <= Integer.MAX_VALUE : false;
    }
}

