/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors.components;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u000e\u0010&\u001a\u00020'*\u0004\u0018\u00010(H\u0002\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent;", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "collector", "Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector;", "(Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector;)V", "reportFirDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "qualifiedAccessSource", "visitErrorExpression", "errorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "data", "visitErrorFunction", "errorFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorFunction;", "visitErrorLoop", "errorLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorLoop;", "visitErrorNamedReference", "errorNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirErrorNamedReference;", "visitErrorResolvedQualifier", "errorResolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorResolvedQualifier;", "visitErrorTypeRef", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "hasUnresolvedNameError", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers"})
public final class ErrorNodeDiagnosticCollectorComponent
extends AbstractDiagnosticCollectorComponent {
    public ErrorNodeDiagnosticCollectorComponent(@NotNull AbstractDiagnosticCollector collector2) {
        Intrinsics.checkNotNullParameter(collector2, "collector");
        super(collector2);
    }

    @Override
    public void visitErrorLoop(@NotNull FirErrorLoop errorLoop, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(errorLoop, "errorLoop");
        Intrinsics.checkNotNullParameter(data, "data");
        FirSourceElement firSourceElement = errorLoop.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorLoop.getDiagnostic(), source, this.getReporter(), data, null, 16, null);
    }

    @Override
    public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(errorTypeRef, "errorTypeRef");
        Intrinsics.checkNotNullParameter(data, "data");
        FirSourceElement firSourceElement = errorTypeRef.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorTypeRef.getDiagnostic(), source, this.getReporter(), data, null, 16, null);
    }

    @Override
    public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull CheckerContext data) {
        ConeClassErrorType coneClassErrorType;
        Intrinsics.checkNotNullParameter(resolvedTypeRef, "resolvedTypeRef");
        Intrinsics.checkNotNullParameter(data, "data");
        Object object = resolvedTypeRef.getType();
        ConeClassErrorType coneClassErrorType2 = coneClassErrorType = object instanceof ConeClassErrorType ? (ConeClassErrorType)object : null;
        if (coneClassErrorType == null) {
            return;
        }
        ConeClassErrorType errorType = coneClassErrorType;
        object = resolvedTypeRef.getSource();
        if (object == null) {
            return;
        }
        Object source = object;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorType.getDiagnostic(), (FirSourceElement)source, this.getReporter(), data, null, 16, null);
    }

    @Override
    public void visitErrorNamedReference(@NotNull FirErrorNamedReference errorNamedReference, @NotNull CheckerContext data) {
        FirQualifiedAccess qualifiedAccess;
        FirQualifiedAccess firQualifiedAccess;
        Intrinsics.checkNotNullParameter(errorNamedReference, "errorNamedReference");
        Intrinsics.checkNotNullParameter(data, "data");
        FirSourceElement firSourceElement = errorNamedReference.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        FirQualifiedAccess firQualifiedAccess2 = CollectionsKt.lastOrNull(data.getQualifiedAccesses());
        if (firQualifiedAccess2 == null) {
            firQualifiedAccess = null;
        } else {
            FirQualifiedAccess firQualifiedAccess3 = firQualifiedAccess2;
            boolean bl = false;
            boolean bl2 = false;
            FirQualifiedAccess it = firQualifiedAccess3;
            boolean bl3 = false;
            firQualifiedAccess = qualifiedAccess = it instanceof FirQualifiedAccessExpression && Intrinsics.areEqual(it.getCalleeReference(), errorNamedReference) ? firQualifiedAccess3 : null;
        }
        if (Intrinsics.areEqual(source.getElementType(), KtNodeTypes.ANNOTATION_ENTRY) && errorNamedReference.getDiagnostic() instanceof ConeUnresolvedNameError) {
            return;
        }
        if (Intrinsics.areEqual(source.getKind(), FirFakeSourceElementKind.ArrayAccessNameReference.INSTANCE) && errorNamedReference.getDiagnostic() instanceof ConeUnresolvedNameError) {
            return;
        }
        firQualifiedAccess2 = qualifiedAccess;
        if (this.hasUnresolvedNameError(firQualifiedAccess2 == null ? null : firQualifiedAccess2.getDispatchReceiver()) || this.hasUnresolvedNameError((firQualifiedAccess2 = qualifiedAccess) == null ? null : firQualifiedAccess2.getExtensionReceiver()) || this.hasUnresolvedNameError((firQualifiedAccess2 = qualifiedAccess) == null ? null : firQualifiedAccess2.getExplicitReceiver())) {
            return;
        }
        this.reportFirDiagnostic(errorNamedReference.getDiagnostic(), source, this.getReporter(), data, (firQualifiedAccess2 = qualifiedAccess) == null ? null : firQualifiedAccess2.getSource());
    }

    private final boolean hasUnresolvedNameError(FirExpression $this$hasUnresolvedNameError) {
        FirExpression firExpression2 = $this$hasUnresolvedNameError;
        FirTypeRef firTypeRef = firExpression2 == null ? null : firExpression2.getTypeRef();
        FirErrorTypeRef firErrorTypeRef = firTypeRef instanceof FirErrorTypeRef ? (FirErrorTypeRef)firTypeRef : null;
        ConeDiagnostic coneDiagnostic = firErrorTypeRef == null ? null : firErrorTypeRef.getDiagnostic();
        return coneDiagnostic instanceof ConeUnresolvedNameError;
    }

    @Override
    public void visitErrorExpression(@NotNull FirErrorExpression errorExpression, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(errorExpression, "errorExpression");
        Intrinsics.checkNotNullParameter(data, "data");
        FirSourceElement firSourceElement = errorExpression.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorExpression.getDiagnostic(), source, this.getReporter(), data, null, 16, null);
    }

    @Override
    public void visitErrorFunction(@NotNull FirErrorFunction errorFunction, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(errorFunction, "errorFunction");
        Intrinsics.checkNotNullParameter(data, "data");
        FirSourceElement firSourceElement = errorFunction.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorFunction.getDiagnostic(), source, this.getReporter(), data, null, 16, null);
    }

    @Override
    public void visitErrorResolvedQualifier(@NotNull FirErrorResolvedQualifier errorResolvedQualifier, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(errorResolvedQualifier, "errorResolvedQualifier");
        Intrinsics.checkNotNullParameter(data, "data");
        FirSourceElement firSourceElement = errorResolvedQualifier.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorResolvedQualifier.getDiagnostic(), source, this.getReporter(), data, null, 16, null);
    }

    private final void reportFirDiagnostic(ConeDiagnostic diagnostic, FirSourceElement source, DiagnosticReporter reporter, CheckerContext context2, FirSourceElement qualifiedAccessSource) {
        if (Intrinsics.areEqual(source.getElementType(), KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) {
            return;
        }
        if (Intrinsics.areEqual(source.getKind(), FirFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE) && (diagnostic instanceof ConeUnresolvedNameError || diagnostic instanceof ConeAmbiguityError || diagnostic instanceof ConeInapplicableCandidateError)) {
            return;
        }
        if (Intrinsics.areEqual(source.getKind(), FirFakeSourceElementKind.ImplicitConstructor.INSTANCE) || Intrinsics.areEqual(source.getKind(), FirFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
            return;
        }
        for (FirDiagnostic<FirSourceElement> coneDiagnostic : ConeDiagnosticToFirDiagnosticKt.toFirDiagnostics(diagnostic, source, qualifiedAccessSource)) {
            reporter.report(coneDiagnostic, context2);
        }
    }

    static /* synthetic */ void reportFirDiagnostic$default(ErrorNodeDiagnosticCollectorComponent errorNodeDiagnosticCollectorComponent, ConeDiagnostic coneDiagnostic, FirSourceElement firSourceElement, DiagnosticReporter diagnosticReporter, CheckerContext checkerContext, FirSourceElement firSourceElement2, int n, Object object) {
        if ((n & 0x10) != 0) {
            firSourceElement2 = null;
        }
        errorNodeDiagnosticCollectorComponent.reportFirDiagnostic(coneDiagnostic, firSourceElement, diagnosticReporter, checkerContext, firSourceElement2);
    }
}

