/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/FileClassAnnotationsChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "()V", "alwaysApplicable", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "Lkotlin/collections/HashSet;", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "frontend.java"})
public final class FileClassAnnotationsChecker
implements AdditionalAnnotationChecker {
    @NotNull
    public static final FileClassAnnotationsChecker INSTANCE = new FileClassAnnotationsChecker();
    @NotNull
    private static final HashSet<FqName> alwaysApplicable;

    private FileClassAnnotationsChecker() {
    }

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace) {
        KtAnnotationEntry entry;
        boolean isMultifileClass;
        ArrayList<Pair<KtAnnotationEntry, Object>> fileAnnotationsToCheck;
        block13: {
            boolean bl;
            Intrinsics.checkNotNullParameter(entries, "entries");
            Intrinsics.checkNotNullParameter(actualTargets, "actualTargets");
            Intrinsics.checkNotNullParameter(trace, "trace");
            boolean bl2 = false;
            fileAnnotationsToCheck = new ArrayList<Pair<KtAnnotationEntry, Object>>();
            for (KtAnnotationEntry ktAnnotationEntry : entries) {
                Object classDescriptor3;
                Set<KotlinTarget> applicableTargets;
                AnnotationDescriptor annotationDescriptor;
                AnnotationDescriptor annotationDescriptor2;
                Object object;
                KtAnnotationUseSiteTarget pair = ktAnnotationEntry.getUseSiteTarget();
                if ((pair == null ? null : pair.getAnnotationUseSiteTarget()) != AnnotationUseSiteTarget.FILE || (object = (AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, ktAnnotationEntry)) == null || (object = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor2 = (annotationDescriptor = object))) == null || (applicableTargets = AnnotationChecker.Companion.applicableTargetSet((ClassDescriptor)(classDescriptor3 = object))) == null || !applicableTargets.contains((Object)KotlinTarget.FILE)) continue;
                fileAnnotationsToCheck.add(new Pair<KtAnnotationEntry, Object>(ktAnnotationEntry, classDescriptor3));
            }
            Iterable iterable = fileAnnotationsToCheck;
            boolean bl3 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : iterable) {
                    Pair it = (Pair)element$iv;
                    boolean bl32 = false;
                    if (!Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)it.getSecond()), JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS())) continue;
                    bl = true;
                    break block13;
                }
                bl = isMultifileClass = false;
            }
        }
        if (isMultifileClass) {
            for (Pair pair : fileAnnotationsToCheck) {
                entry = (KtAnnotationEntry)pair.component1();
                ClassDescriptor classDescriptor2 = (ClassDescriptor)pair.component2();
                FqName classFqName = DescriptorUtilsKt.getFqNameSafe(classDescriptor2);
                if (alwaysApplicable.contains(classFqName) || DescriptorUtilsKt.getAnnotationRetention(classDescriptor2) == KotlinRetention.SOURCE) continue;
                trace.report(ErrorsJvm.ANNOTATION_IS_NOT_APPLICABLE_TO_MULTIFILE_CLASSES.on((KtAnnotationEntry)((PsiElement)entry), classFqName));
            }
        } else {
            for (Pair pair : fileAnnotationsToCheck) {
                boolean bl;
                block14: {
                    String value2;
                    KtStringTemplateEntry[] stringTemplateEntries;
                    KtExpression argumentExpression;
                    KtElementImplStub ktElementImplStub;
                    entry = (KtAnnotationEntry)pair.component1();
                    ClassDescriptor classDescriptor2 = (ClassDescriptor)pair.component2();
                    if (!Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(classDescriptor2), JvmFileClassUtil.INSTANCE.getJVM_PACKAGE_NAME())) continue;
                    Object object = entry.getValueArguments();
                    Intrinsics.checkNotNullExpressionValue(object, "entry.valueArguments");
                    KtStringTemplateEntry[] ktStringTemplateEntryArray = CollectionsKt.firstOrNull(object);
                    KtExpression bl32 = ktStringTemplateEntryArray == null ? null : ktStringTemplateEntryArray.getArgumentExpression();
                    if (bl32 == null || (object = (ktElementImplStub = (argumentExpression = bl32) instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)argumentExpression : null) == null ? null : ktElementImplStub.getEntries()) == null || (stringTemplateEntries = (ktStringTemplateEntryArray = object)).length > 1) continue;
                    ktElementImplStub = ArraysKt.singleOrNull(stringTemplateEntries);
                    object = ktElementImplStub instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)ktElementImplStub : null;
                    String string2 = value2 = object == null ? null : ((KtLiteralStringTemplateEntry)object).getText();
                    if (value2 == null) {
                        trace.report(ErrorsJvm.JVM_PACKAGE_NAME_CANNOT_BE_EMPTY.on((KtAnnotationEntry)((PsiElement)entry)));
                        continue;
                    }
                    if (!FqNamesUtilKt.isValidJavaFqName(value2)) {
                        trace.report(ErrorsJvm.JVM_PACKAGE_NAME_MUST_BE_VALID_NAME.on((KtAnnotationEntry)((PsiElement)entry)));
                        continue;
                    }
                    Iterable $this$any$iv = entry.getContainingKtFile().getDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtDeclaration it = (KtDeclaration)element$iv;
                            boolean bl4 = false;
                            if (!(!(it instanceof KtFunction) && !(it instanceof KtProperty) && !(it instanceof KtTypeAlias))) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                trace.report(ErrorsJvm.JVM_PACKAGE_NAME_NOT_SUPPORTED_IN_FILES_WITH_CLASSES.on((KtAnnotationEntry)((PsiElement)entry)));
            }
        }
    }

    static {
        FqName[] fqNameArray = new FqName[]{JvmFileClassUtil.INSTANCE.getJVM_NAME(), JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS()};
        alwaysApplicable = SetsKt.hashSetOf(fqNameArray);
    }
}

