/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirErrorExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirErrorLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirBlockImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.fir.visitors.TransformData;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u001a;\u0010\u0018\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001d2\b\u0010\u001e\u001a\u0004\u0018\u0001H\u00192\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010!\u001a\u0018\u0010\"\u001a\u00020#2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020 \u001a\u0018\u0010$\u001a\u00020%2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020 \u001a\u0012\u0010&\u001a\u00020'*\u00020(2\u0006\u0010)\u001a\u00020'\u001a\f\u0010*\u001a\u0004\u0018\u00010+*\u00020\u0001\u001a\u0010\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010-*\u00020\u0001\u001a+\u0010.\u001a\u00020(\"\u0004\b\u0000\u0010/*\u00020(2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/012\u0006\u00102\u001a\u0002H/\u00a2\u0006\u0002\u00103\u001a8\u00104\u001a\u00020(\"\u0004\b\u0000\u0010/*\u00020(2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/012\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u000207\u0012\n\u0012\b\u0012\u0004\u0012\u0002H/0806\"\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"6\u0010\u0005\u001a\"\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006j\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00118\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00118\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00069"}, d2={"argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "getArgument", "(Lorg/jetbrains/kotlin/fir/expressions/FirCall;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "argumentMapping", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lkotlin/collections/LinkedHashMap;", "getArgumentMapping", "(Lorg/jetbrains/kotlin/fir/expressions/FirCall;)Ljava/util/LinkedHashMap;", "arguments", "", "getArguments", "(Lorg/jetbrains/kotlin/fir/expressions/FirCall;)Ljava/util/List;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "getClassId", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;)Lorg/jetbrains/kotlin/name/ClassId;", "coneClassLikeType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "getConeClassLikeType", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "buildConstOrErrorExpression", "T", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "kind", "Lorg/jetbrains/kotlin/fir/expressions/FirConstKind;", "value", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "(Lorg/jetbrains/kotlin/fir/FirSourceElement;Lorg/jetbrains/kotlin/fir/expressions/FirConstKind;Ljava/lang/Object;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "buildErrorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "buildErrorLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorLoop;", "replaceFirstStatement", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "statement", "toResolvedCallableReference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "toResolvedCallableSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "transformAllStatementsExceptLast", "D", "transformer", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "data", "(Lorg/jetbrains/kotlin/fir/expressions/FirBlock;Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "transformStatementsIndexed", "dataProducer", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/fir/visitors/TransformData;", "tree"})
public final class FirExpressionUtilKt {
    @Nullable
    public static final ConeClassLikeType getConeClassLikeType(@NotNull FirAnnotationCall $this$coneClassLikeType) {
        Intrinsics.checkNotNullParameter($this$coneClassLikeType, "<this>");
        boolean $i$f$getConeClassLikeType = false;
        FirTypeRef firTypeRef = $this$coneClassLikeType.getAnnotationTypeRef();
        FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        return coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
    }

    @Nullable
    public static final ClassId getClassId(@NotNull FirAnnotationCall $this$classId) {
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter($this$classId, "<this>");
        boolean $i$f$getClassId = false;
        FirAnnotationCall $this$coneClassLikeType$iv = $this$classId;
        boolean $i$f$getConeClassLikeType = false;
        FirTypeRef firTypeRef = $this$coneClassLikeType$iv.getAnnotationTypeRef();
        FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        return coneClassLikeType == null ? null : ((coneClassLikeLookupTag = coneClassLikeType.getLookupTag()) == null ? null : coneClassLikeLookupTag.getClassId());
    }

    @NotNull
    public static final <T> FirExpression buildConstOrErrorExpression(@Nullable FirSourceElement source, @NotNull FirConstKind<T> kind, @Nullable T value2, @NotNull ConeDiagnostic diagnostic) {
        FirExpression firExpression2;
        boolean bl;
        boolean bl2;
        FirConstExpression firConstExpression;
        Intrinsics.checkNotNullParameter(kind, "kind");
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        T t = value2;
        if (t == null) {
            firConstExpression = null;
        } else {
            T t2 = t;
            bl2 = false;
            bl = false;
            T it = t2;
            boolean bl3 = false;
            firConstExpression = FirConstExpressionBuilderKt.buildConstExpression$default(source, kind, it, null, 8, null);
        }
        FirConstExpression firConstExpression2 = firConstExpression;
        if (firConstExpression2 == null) {
            boolean $i$f$buildErrorExpression = false;
            boolean bl4 = false;
            FirErrorExpressionBuilder firErrorExpressionBuilder = new FirErrorExpressionBuilder();
            bl2 = false;
            bl = false;
            FirErrorExpressionBuilder $this$buildConstOrErrorExpression_u24lambda_u2d1 = firErrorExpressionBuilder;
            boolean bl5 = false;
            $this$buildConstOrErrorExpression_u24lambda_u2d1.setSource(source);
            $this$buildConstOrErrorExpression_u24lambda_u2d1.setDiagnostic(diagnostic);
            firExpression2 = firErrorExpressionBuilder.build();
        } else {
            firExpression2 = firConstExpression2;
        }
        return firExpression2;
    }

    @NotNull
    public static final List<FirExpression> getArguments(@NotNull FirCall $this$arguments) {
        Intrinsics.checkNotNullParameter($this$arguments, "<this>");
        boolean $i$f$getArguments = false;
        return $this$arguments.getArgumentList().getArguments();
    }

    @NotNull
    public static final FirExpression getArgument(@NotNull FirCall $this$argument) {
        Intrinsics.checkNotNullParameter($this$argument, "<this>");
        boolean $i$f$getArgument = false;
        return CollectionsKt.first($this$argument.getArgumentList().getArguments());
    }

    @Nullable
    public static final LinkedHashMap<FirExpression, FirValueParameter> getArgumentMapping(@NotNull FirCall $this$argumentMapping) {
        Intrinsics.checkNotNullParameter($this$argumentMapping, "<this>");
        boolean $i$f$getArgumentMapping = false;
        FirArgumentList firArgumentList = $this$argumentMapping.getArgumentList();
        FirResolvedArgumentList firResolvedArgumentList = firArgumentList instanceof FirResolvedArgumentList ? (FirResolvedArgumentList)firArgumentList : null;
        return firResolvedArgumentList == null ? null : firResolvedArgumentList.getMapping();
    }

    @Nullable
    public static final FirResolvedNamedReference toResolvedCallableReference(@NotNull FirExpression $this$toResolvedCallableReference) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableReference, "<this>");
        if ($this$toResolvedCallableReference instanceof FirWrappedArgumentExpression) {
            return FirExpressionUtilKt.toResolvedCallableReference(((FirWrappedArgumentExpression)$this$toResolvedCallableReference).getExpression());
        }
        FirResolvable firResolvable = $this$toResolvedCallableReference instanceof FirResolvable ? (FirResolvable)((Object)$this$toResolvedCallableReference) : null;
        FirReference firReference = firResolvable == null ? null : firResolvable.getCalleeReference();
        return firReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firReference : null;
    }

    @Nullable
    public static final FirCallableSymbol<?> toResolvedCallableSymbol(@NotNull FirExpression $this$toResolvedCallableSymbol) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableSymbol, "<this>");
        FirResolvedNamedReference firResolvedNamedReference = FirExpressionUtilKt.toResolvedCallableReference($this$toResolvedCallableSymbol);
        return (FirCallableSymbol)(firResolvedNamedReference == null ? null : firResolvedNamedReference.getResolvedSymbol());
    }

    @NotNull
    public static final FirErrorLoop buildErrorLoop(@Nullable FirSourceElement source, @NotNull ConeDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        boolean $i$f$buildErrorLoop = false;
        boolean bl = false;
        FirErrorLoopBuilder firErrorLoopBuilder = new FirErrorLoopBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirErrorLoopBuilder $this$buildErrorLoop_u24lambda_u2d2 = firErrorLoopBuilder;
        boolean bl4 = false;
        $this$buildErrorLoop_u24lambda_u2d2.setSource(source);
        $this$buildErrorLoop_u24lambda_u2d2.setDiagnostic(diagnostic);
        return firErrorLoopBuilder.build();
    }

    @NotNull
    public static final FirErrorExpression buildErrorExpression(@Nullable FirSourceElement source, @NotNull ConeDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        boolean $i$f$buildErrorExpression = false;
        boolean bl = false;
        FirErrorExpressionBuilder firErrorExpressionBuilder = new FirErrorExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirErrorExpressionBuilder $this$buildErrorExpression_u24lambda_u2d3 = firErrorExpressionBuilder;
        boolean bl4 = false;
        $this$buildErrorExpression_u24lambda_u2d3.setSource(source);
        $this$buildErrorExpression_u24lambda_u2d3.setDiagnostic(diagnostic);
        return firErrorExpressionBuilder.build();
    }

    @NotNull
    public static final <D> FirBlock transformStatementsIndexed(@NotNull FirBlock $this$transformStatementsIndexed, @NotNull FirTransformer<? super D> transformer2, @NotNull Function1<? super Integer, ? extends TransformData<? extends D>> dataProducer) {
        Intrinsics.checkNotNullParameter($this$transformStatementsIndexed, "<this>");
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        Intrinsics.checkNotNullParameter(dataProducer, "dataProducer");
        FirBlock firBlock = $this$transformStatementsIndexed;
        if (firBlock instanceof FirBlockImpl) {
            List<FirStatement> $this$transformInplace$iv = ((FirBlockImpl)$this$transformStatementsIndexed).getStatements();
            boolean $i$f$transformInplace = false;
            ListIterator<FirStatement> iterator$iv = $this$transformInplace$iv.listIterator();
            int index$iv = 0;
            while (iterator$iv.hasNext()) {
                FirPureAbstractElement next$iv = (FirPureAbstractElement)((Object)iterator$iv.next());
                int n = index$iv;
                index$iv = n + 1;
                TransformData<? extends D> data$iv = dataProducer.invoke(n);
                if (!(data$iv instanceof TransformData.Data)) {
                    if (Intrinsics.areEqual(data$iv, TransformData.Nothing.INSTANCE)) continue;
                    throw new NoWhenBranchMatchedException();
                }
                Object data$iv2 = ((TransformData.Data)data$iv).getValue();
                FirElement result$iv = (FirElement)next$iv.transform(transformer2, data$iv2).getSingle();
                iterator$iv.set((FirStatement)result$iv);
            }
        } else if (firBlock instanceof FirSingleExpressionBlock) {
            TransformData.Data data;
            TransformData<Object> transformData = dataProducer.invoke(0);
            TransformData.Data data2 = data = transformData instanceof TransformData.Data ? (TransformData.Data)transformData : null;
            if (data != null && (transformData = data.getValue()) != null) {
                TransformData<Object> transformData2 = transformData;
                boolean bl = false;
                boolean bl2 = false;
                TransformData<Object> it = transformData2;
                boolean bl3 = false;
                $this$transformStatementsIndexed.transformStatements(transformer2, it);
            }
        }
        return $this$transformStatementsIndexed;
    }

    @NotNull
    public static final <D> FirBlock transformAllStatementsExceptLast(@NotNull FirBlock $this$transformAllStatementsExceptLast, @NotNull FirTransformer<? super D> transformer2, D data) {
        Intrinsics.checkNotNullParameter($this$transformAllStatementsExceptLast, "<this>");
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        int threshold = $this$transformAllStatementsExceptLast.getStatements().size() - 1;
        return FirExpressionUtilKt.transformStatementsIndexed($this$transformAllStatementsExceptLast, transformer2, new Function1<Integer, TransformData<? extends D>>(threshold, data){
            final /* synthetic */ int $threshold;
            final /* synthetic */ D $data;
            {
                this.$threshold = $threshold;
                this.$data = $data;
                super(1);
            }

            @NotNull
            public final TransformData<D> invoke(int index2) {
                return index2 < this.$threshold ? (TransformData)new TransformData.Data<D>(this.$data) : (TransformData)TransformData.Nothing.INSTANCE;
            }
        });
    }

    @NotNull
    public static final FirStatement replaceFirstStatement(@NotNull FirBlock $this$replaceFirstStatement, @NotNull FirStatement statement2) {
        Intrinsics.checkNotNullParameter($this$replaceFirstStatement, "<this>");
        Intrinsics.checkNotNullParameter(statement2, "statement");
        boolean bl = $this$replaceFirstStatement instanceof FirBlockImpl;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = Intrinsics.stringPlus("replaceFirstStatement should not be called for ", Reflection.getOrCreateKotlinClass($this$replaceFirstStatement.getClass()).getSimpleName());
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        FirStatement existed = ((FirBlockImpl)$this$replaceFirstStatement).getStatements().get(0);
        ((FirBlockImpl)$this$replaceFirstStatement).getStatements().set(0, statement2);
        return existed;
    }
}

